/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpBootstrap {
    private static final Log LOG = LogFactory.getLog(TcpBootstrap.class);
    private final int WANTED_HOSTS = 15;
    private final ExecutorService bootstrapQueue = ExecutorsHelper.newProcessingQueue("TCP Bootstrap");
    private final List<URI> hosts = new ArrayList<URI>();
    private final Set<URI> hostsSet = new HashSet<URI>();
    private final Set<URI> attemptedHosts;
    private boolean dirty = false;
    private final HttpExecutor httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ConnectionServices connectionServices;

    @Inject
    protected TcpBootstrap(HttpExecutor httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, ConnectionServices connectionServices) {
        this(600000L, httpExecutor, defaultParams, connectionServices);
    }

    protected TcpBootstrap(long expiryTime, HttpExecutor httpExecutor, Provider<HttpParams> defaultParams, ConnectionServices connectionServices) {
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<URI>(100, expiryTime);
    }

    public synchronized int getSize() {
        return this.hostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug("Clearing attempted host caches");
        this.attemptedHosts.clear();
    }

    public synchronized boolean fetchHosts(TcpBootstrapListener listener) {
        if (this.dirty) {
            Collections.shuffle(this.hosts);
            this.dirty = false;
        }
        return this.doFetch(listener);
    }

    private boolean doFetch(TcpBootstrapListener listener) {
        ArrayList<HttpUriRequest> requests = new ArrayList<HttpUriRequest>();
        HashMap<HttpUriRequest, URI> requestToHost = new HashMap<HttpUriRequest, URI>();
        for (URI host : this.hosts) {
            if (this.attemptedHosts.contains(host)) continue;
            HttpUriRequest request = this.newRequest(host);
            requests.add(request);
            requestToHost.put(request, host);
        }
        if (requests.isEmpty()) {
            return false;
        }
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 5000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.executeAny(new Listener(requestToHost, listener), this.bootstrapQueue, requests, params, new Cancellable(){

            public boolean isCancelled() {
                return TcpBootstrap.this.connectionServices.isConnected();
            }
        });
        return true;
    }

    private HttpUriRequest newRequest(URI host) {
        host = URI.create(host.toString() + "?hostfile=1" + "&client=" + "LIME" + "&version=" + EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()));
        HttpGet get = new HttpGet(host);
        get.addHeader("Cache-Control", "no-cache");
        return get;
    }

    private int parseResponse(HttpResponse response, TcpBootstrapListener listener) {
        if (response.getEntity() == null) {
            LOG.warn("No response entity!");
            return 0;
        }
        String line = null;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try {
            InputStream in = response.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                Endpoint host = new Endpoint(line, true);
                endpoints.add(host);
            }
        }
        catch (IllegalArgumentException bad) {
            LOG.error("IAE", bad);
        }
        catch (IOException e) {
            LOG.error("IOX", e);
        }
        if (!endpoints.isEmpty()) {
            return listener.handleHosts(endpoints);
        }
        return 0;
    }

    public synchronized boolean add(URI e) {
        if (this.hostsSet.contains(e)) {
            return false;
        }
        this.hosts.add(e);
        this.hostsSet.add(e);
        this.dirty = true;
        return true;
    }

    public void loadDefaults() {
        this.add(URI.create("http://secondary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://tertiary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://leet.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://sissy.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://ein.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://zwei.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://drei.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://gnutelladev1.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://gnutelladev2.udp-host-cache.com:8080/gwc/"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TcpBootstrapListener {
        public int handleHosts(Collection<? extends Endpoint> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements HttpClientListener {
        private final Map<HttpUriRequest, URI> hosts;
        private final TcpBootstrapListener listener;
        private int totalAdded = 0;

        Listener(Map<HttpUriRequest, URI> hosts, TcpBootstrapListener listener) {
            this.hosts = hosts;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed request: " + request.getRequestLine());
            }
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                TcpBootstrap.this.attemptedHosts.add(this.hosts.remove(request));
            }
            this.totalAdded += TcpBootstrap.this.parseResponse(response, this.listener);
            TcpBootstrap.this.httpExecutor.releaseResources(response);
            return this.totalAdded < 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed request: " + request.getRequestLine());
            }
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                TcpBootstrap.this.attemptedHosts.add(this.hosts.remove(request));
            }
            TcpBootstrap.this.httpExecutor.releaseResources(response);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean allowRequest(HttpUriRequest request) {
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                return this.hosts.containsKey(request) && !TcpBootstrap.this.attemptedHosts.contains(this.hosts.get(request));
            }
        }
    }
}

