/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPHostCache {
    private static final Log LOG = LogFactory.getLog(UDPHostCache.class);
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List<ExtendedEndpoint> udpHosts = new ArrayList<ExtendedEndpoint>(100);
    private final Set<ExtendedEndpoint> udpHostsSet = new HashSet<ExtendedEndpoint>();
    private final UDPPinger pinger;
    private final Set<ExtendedEndpoint> attemptedHosts;
    private boolean dirty = false;
    private boolean writeDirty = false;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;
    private static final Comparator<ExtendedEndpoint> FAILURE_COMPARATOR = new FailureComparator();

    protected UDPHostCache(UDPPinger pinger, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this(600000L, pinger, messageRouter, pingRequestFactory, connectionServices, networkInstanceUtils);
    }

    protected UDPHostCache(long expiryTime, UDPPinger pinger, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<ExtendedEndpoint>(100, expiryTime);
        this.pinger = pinger;
        this.messageRouter = messageRouter;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public synchronized void write(Writer out) throws IOException {
        for (ExtendedEndpoint e : this.udpHosts) {
            e.write(out);
        }
        this.writeDirty = false;
    }

    public synchronized boolean isWriteDirty() {
        return this.writeDirty;
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug("Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        for (ExtendedEndpoint ep : this.attemptedHosts) {
            ep.decrementUDPHostCacheFailure();
            if (ep.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(ep);
            }
            this.dirty = true;
            this.writeDirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList<ExtendedEndpoint> validHosts = new ArrayList<ExtendedEndpoint>(Math.min(5, this.udpHosts.size()));
        LinkedList<ExtendedEndpoint> invalidHosts = new LinkedList<ExtendedEndpoint>();
        for (ExtendedEndpoint next : this.udpHosts) {
            if (validHosts.size() >= 5) break;
            if (this.attemptedHosts.contains(next)) continue;
            if (!this.networkInstanceUtils.isValidExternalIpPort(next) || !NetworkUtils.isValidIpPort(next) || this.networkInstanceUtils.isPrivateAddress(next.getAddress())) {
                invalidHosts.add(next);
                continue;
            }
            validHosts.add(next);
        }
        for (ExtendedEndpoint next : invalidHosts) {
            this.remove(next);
        }
        this.attemptedHosts.addAll(validHosts);
        return this.fetch(validHosts);
    }

    protected synchronized boolean fetch(Collection<? extends ExtendedEndpoint> hosts) {
        if (hosts.isEmpty()) {
            LOG.debug("No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching endpoints from " + hosts + " host caches");
        }
        this.pinger.rank(hosts, new HostExpirer(hosts), new Cancellable(){

            public boolean isCancelled() {
                return UDPHostCache.this.connectionServices.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return this.pingRequestFactory.createUHCPing();
    }

    public synchronized boolean remove(ExtendedEndpoint e) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removing endpoint: " + e);
        }
        boolean removed1 = this.udpHosts.remove(e);
        boolean removed2 = this.udpHostsSet.remove(e);
        assert (removed1 == removed2) : "Set " + removed1 + " but queue " + removed2;
        if (removed1) {
            this.writeDirty = true;
        }
        return removed1;
    }

    public synchronized boolean add(ExtendedEndpoint e) {
        assert (e.isUDPHostCache());
        if (this.udpHostsSet.contains(e)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            ExtendedEndpoint removed = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(removed);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ejected: " + removed);
            }
        }
        this.udpHosts.add(e);
        this.udpHostsSet.add(e);
        this.dirty = true;
        this.writeDirty = true;
        return true;
    }

    public void loadDefaults() {
        this.createAndAdd("uhc2.limewire.com", 20181);
        this.createAndAdd("uhc3.limewire.com", 51180);
        this.createAndAdd("uhc.udp-host-cache.com", 9999);
        this.createAndAdd("secondary.udp-host-cache.com", 9999);
        this.createAndAdd("tertiary.udp-host-cache.com", 9999);
        this.createAndAdd("leet.gtkg.org", 1337);
        this.createAndAdd("sissy.gtkg.org", 51557);
        this.createAndAdd("ein.gtkg.net", 60666);
        this.createAndAdd("zwei.gtkg.net", 61666);
        this.createAndAdd("drei.gtkg.net", 62666);
    }

    private void createAndAdd(String host, int port) {
        try {
            ExtendedEndpoint ep = new ExtendedEndpoint(host, port).setUDPHostCache(true);
            this.add(ep);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailureComparator
    implements Comparator<ExtendedEndpoint> {
        private FailureComparator() {
        }

        @Override
        public int compare(ExtendedEndpoint e1, ExtendedEndpoint e2) {
            return e1.getUDPHostCacheFailures() - e2.getUDPHostCacheFailures();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HostExpirer
    implements MessageListener {
        private final Set<ExtendedEndpoint> hosts = new StrictIpPortSet<ExtendedEndpoint>();
        private final Set<ExtendedEndpoint> allHosts;
        private byte[] guid;

        public HostExpirer(Collection<? extends ExtendedEndpoint> hostsToAdd) {
            this.hosts.addAll(hostsToAdd);
            this.allHosts = new HashSet<ExtendedEndpoint>(hostsToAdd);
            this.removeDuplicates(hostsToAdd, this.hosts);
        }

        private void removeDuplicates(Collection<? extends ExtendedEndpoint> all, Collection<? extends ExtendedEndpoint> some) {
            HashSet<? extends ExtendedEndpoint> duplicates = new HashSet<ExtendedEndpoint>(all);
            duplicates.removeAll(some);
            for (ExtendedEndpoint extendedEndpoint : duplicates) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing duplicate entry: " + extendedEndpoint);
                }
                UDPHostCache.this.remove(extendedEndpoint);
            }
        }

        @Override
        public void processMessage(Message m, ReplyHandler handler) {
            if (handler instanceof UDPReplyHandler) {
                if (this.hosts.remove(handler) && LOG.isTraceEnabled()) {
                    LOG.trace("Recieved: " + m);
                }
                if (this.hosts.isEmpty()) {
                    ((MessageRouter)UDPHostCache.this.messageRouter.get()).unregisterMessageListener(this.guid, this);
                }
            }
        }

        @Override
        public void registered(byte[] g) {
            this.guid = g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregistered(byte[] g) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                for (ExtendedEndpoint ep : this.hosts) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No response from cache: " + ep);
                    }
                    ep.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                    if (ep.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(ep);
                }
                this.allHosts.removeAll(this.hosts);
                for (ExtendedEndpoint ep : this.allHosts) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Valid response from cache: " + ep);
                    }
                    ep.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                }
            }
        }
    }
}

