/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnetOptions
implements Serializable {
    private static final long serialVersionUID = 5612757489102667276L;
    public static final String MAGNET = "magnet:?";
    private static final String HTTP = "http://";
    private static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private final Map<Option, List<String>> optionsMap;
    private transient String[] defaultURLs;
    private transient String localizedErrorMessage;
    private transient URN urn;
    private transient String extractedFileName;
    private transient Set<URN> guidUrns;
    private volatile transient long fileSize = -2L;

    public static MagnetOptions createMagnet(FileDetails fileDetails) {
        long fileSize;
        EnumMap<Option, List<String>> map = new EnumMap<Option, List<String>>(Option.class);
        map.put(Option.DN, Collections.singletonList(fileDetails.getFileName()));
        URN urn = fileDetails.getSHA1Urn();
        if (urn != null) {
            MagnetOptions.addAppend(map, Option.XT, urn.httpStringValue());
        }
        InetSocketAddress isa = fileDetails.getInetSocketAddress();
        String url = null;
        if (isa != null && urn != null) {
            StringBuilder addr = new StringBuilder(HTTP);
            addr.append(isa.getAddress().getHostAddress()).append(':').append(isa.getPort()).append("/uri-res/N2R?");
            addr.append(urn.httpStringValue());
            url = addr.toString();
            MagnetOptions.addAppend(map, Option.XS, url);
        }
        byte[] clientGuid = fileDetails.getClientGUID();
        URN guidUrn = null;
        if (clientGuid != null) {
            guidUrn = URN.createGUIDUrn(new GUID(clientGuid));
            MagnetOptions.addAppend(map, Option.XS, guidUrn.httpStringValue());
        }
        if ((fileSize = fileDetails.getFileSize()) >= 0L) {
            MagnetOptions.addAppend(map, Option.XL, Long.toString(fileSize));
        }
        MagnetOptions magnet = new MagnetOptions(map);
        magnet.urn = urn;
        if (url != null) {
            magnet.defaultURLs = new String[]{url};
        }
        if (guidUrn != null) {
            magnet.guidUrns = Collections.singleton(guidUrn);
        }
        magnet.fileSize = fileSize >= 0L ? fileSize : -1L;
        return magnet;
    }

    public static MagnetOptions createMagnet(String keywordTopics, String fileName, URN urn, String[] defaultURLs) {
        return MagnetOptions.createMagnet(keywordTopics, fileName, urn, defaultURLs, null);
    }

    public static MagnetOptions createMagnet(String keywordTopics, String fileName, URN urn, String[] defaultURLs, Set<? extends URN> guidUrns) {
        HashMap<Option, List<String>> map = new HashMap<Option, List<String>>();
        ArrayList<String> kt = new ArrayList<String>(1);
        kt.add(keywordTopics);
        map.put(Option.KT, kt);
        ArrayList<String> dn = new ArrayList<String>(1);
        dn.add(fileName);
        map.put(Option.DN, dn);
        if (urn != null) {
            MagnetOptions.addAppend(map, Option.XT, urn.httpStringValue());
        }
        if (defaultURLs != null) {
            for (int i = 0; i < defaultURLs.length; ++i) {
                MagnetOptions.addAppend(map, Option.AS, defaultURLs[i]);
            }
        }
        if (guidUrns != null) {
            for (URN uRN : guidUrns) {
                if (!uRN.isGUID()) {
                    throw new IllegalArgumentException("Not a GUID urn: " + uRN);
                }
                MagnetOptions.addAppend(map, Option.XS, uRN.httpStringValue());
            }
        }
        MagnetOptions magnet = new MagnetOptions(map);
        magnet.urn = urn;
        if (defaultURLs != null) {
            magnet.defaultURLs = new String[defaultURLs.length];
            System.arraycopy(defaultURLs, 0, magnet.defaultURLs, 0, magnet.defaultURLs.length);
        } else {
            magnet.defaultURLs = new String[0];
        }
        if (guidUrns != null) {
            magnet.guidUrns = Collections.unmodifiableSet(new HashSet<URN>(guidUrns));
        }
        return magnet;
    }

    public static MagnetOptions[] parseMagnets(String magnets) {
        ArrayList<MagnetOptions> list = new ArrayList<MagnetOptions>();
        StringTokenizer tokens = new StringTokenizer(magnets, System.getProperty("line.separator"));
        while (tokens.hasMoreTokens()) {
            String next = tokens.nextToken();
            MagnetOptions[] options = MagnetOptions.parseMagnet(next);
            if (options.length <= 0) continue;
            list.addAll(Arrays.asList(options));
        }
        return list.toArray(new MagnetOptions[0]);
    }

    public static MagnetOptions[] parseMagnet(String arg) {
        HashMap<Integer, HashMap<Option, List<String>>> options = new HashMap<Integer, HashMap<Option, List<String>>>();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.toLowerCase(Locale.US).startsWith(MAGNET)) {
            return new MagnetOptions[0];
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            Option option;
            int index;
            String cmdstr;
            String keystr;
            block11: {
                keystr = st.nextToken();
                int start = (keystr = keystr.trim()).indexOf("=") + 1;
                if (start == 0) continue;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                try {
                    cmdstr = URLDecoder.decode(cmdstr);
                }
                catch (IOException e1) {
                    continue;
                }
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block11;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            Integer iIndex = new Integer(index);
            HashMap<Option, List<String>> curOptions = (HashMap<Option, List<String>>)options.get(iIndex);
            if (curOptions == null) {
                curOptions = new HashMap<Option, List<String>>();
                options.put(iIndex, curOptions);
            }
            if ((option = Option.valueFor(keystr)) == null) continue;
            MagnetOptions.addAppend(curOptions, option, cmdstr);
        }
        MagnetOptions[] ret = new MagnetOptions[options.size()];
        int i = 0;
        for (Map current : options.values()) {
            ret[i++] = new MagnetOptions(current);
        }
        return ret;
    }

    private static void addAppend(Map<Option, List<String>> map, Option key, String value) {
        List<String> l = map.get((Object)key);
        if (l == null) {
            l = new ArrayList<String>(1);
            map.put(key, l);
        }
        l.add(value);
    }

    private MagnetOptions(Map<Option, List<String>> options) {
        this.optionsMap = Collections.unmodifiableMap(options);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        StringBuilder ret = new StringBuilder(MAGNET);
        for (String xt : this.getExactTopics()) {
            ret.append("&xt=").append(xt);
        }
        if (this.getDisplayName() != null) {
            ret.append("&dn=").append(EncodingUtils.encode(this.getDisplayName()));
        }
        if (this.getKeywordTopic() != null) {
            ret.append("&kt=").append(EncodingUtils.encode(this.getKeywordTopic()));
        }
        for (String xs : this.getXS()) {
            ret.append("&xs=").append(xs);
        }
        for (String as : this.getAS()) {
            ret.append("&as=").append(as);
        }
        for (String xl : this.getXL()) {
            ret.append("&xl=").append(xl);
        }
        return ret.toString();
    }

    public URN getSHA1Urn() {
        if (this.urn == null) {
            this.urn = this.extractSHA1URNFromList(this.getExactTopics());
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getXS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getAS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromURLS(this.getDefaultURLs());
            }
            if (this.urn == null) {
                this.urn = URN.INVALID;
            }
        }
        if (this.urn == URN.INVALID) {
            return null;
        }
        return this.urn;
    }

    private URN extractSHA1URNFromURLS(String[] defaultURLs) {
        for (int i = 0; i < defaultURLs.length; ++i) {
            try {
                URI uri = URIUtils.toURI(defaultURLs[i]);
                String query = uri.getQuery();
                if (query == null) continue;
                return URN.createSHA1Urn(uri.getQuery());
            }
            catch (URISyntaxException e) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isDownloadable() {
        if (this.getDefaultURLs().length > 0) {
            return true;
        }
        return this.getSHA1Urn() != null && this.getQueryString() != null;
    }

    public boolean isHashOnly() {
        String kt = this.getKeywordTopic();
        String dn = this.getDisplayName();
        return !(kt != null && kt.length() <= 0 || dn != null && dn.length() <= 0 || !this.getAS().isEmpty() || !this.getXS().isEmpty() || this.getExactTopics().isEmpty());
    }

    public String getQueryString() {
        String kt = this.getKeywordTopic();
        if (kt != null && kt.length() > 0) {
            return kt;
        }
        String dn = this.getDisplayName();
        if (dn != null && dn.length() > 0) {
            return dn;
        }
        return null;
    }

    public boolean isKeywordTopicOnly() {
        String kt = this.getKeywordTopic();
        String dn = this.getDisplayName();
        return kt != null && kt.length() > 0 && (dn == null || dn.length() > 0) && this.getAS().isEmpty() && this.getXS().isEmpty() && this.getExactTopics().isEmpty();
    }

    private URN extractSHA1URNFromList(List<String> strings) {
        for (String str : strings) {
            try {
                return URN.createSHA1Urn(str);
            }
            catch (IOException ignored) {
            }
        }
        return null;
    }

    private List<String> getPotentialURLs() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.addAll(this.getPotentialURLs(this.getExactTopics()));
        urls.addAll(this.getPotentialURLs(this.getXS()));
        urls.addAll(this.getPotentialURLs(this.getAS()));
        return urls;
    }

    private List<String> getPotentialURNs() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.addAll(this.getPotentialURNs(this.getExactTopics()));
        urls.addAll(this.getPotentialURNs(this.getXS()));
        urls.addAll(this.getPotentialURNs(this.getAS()));
        return urls;
    }

    private List<String> getPotentialURNs(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str : strings) {
            if (!str.toLowerCase(Locale.US).startsWith("urn:")) continue;
            ret.add(str);
        }
        return ret;
    }

    private List<String> getPotentialURLs(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str : strings) {
            if (!str.toLowerCase(Locale.US).startsWith(HTTP)) continue;
            ret.add(str);
        }
        return ret;
    }

    public String[] getDefaultURLs() {
        if (this.defaultURLs == null) {
            List<String> urls = this.getPotentialURLs();
            Iterator<String> it = urls.iterator();
            while (it.hasNext()) {
                try {
                    String nextURL = it.next();
                    URIUtils.toURI(nextURL);
                }
                catch (URISyntaxException e) {
                    it.remove();
                    this.localizedErrorMessage = e.getLocalizedMessage();
                }
            }
            this.defaultURLs = urls.toArray(new String[urls.size()]);
        }
        return this.defaultURLs;
    }

    public Set<URN> getGUIDUrns() {
        if (this.guidUrns != null) {
            return this.guidUrns;
        }
        Set<URN> urns = null;
        List<String> potentialUrns = this.getPotentialURNs();
        for (String candidate : potentialUrns) {
            try {
                URN urn = URN.createGUIDUrn(candidate);
                if (urns == null) {
                    urns = new HashSet<URN>(2);
                }
                urns.add(urn);
            }
            catch (IOException ie) {}
        }
        urns = urns == null ? Collections.emptySet() : Collections.unmodifiableSet(urns);
        this.guidUrns = urns;
        return urns;
    }

    public String getDisplayName() {
        List<String> list = this.optionsMap.get((Object)Option.DN);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getFileNameForSaving() {
        if (this.extractedFileName != null) {
            return this.extractedFileName;
        }
        String name = this.getRawNameForSaving();
        while (name.startsWith(".") || name.startsWith("\\") || name.startsWith("/")) {
            name = name.substring(1);
        }
        this.extractedFileName = name;
        return this.extractedFileName;
    }

    private String getRawNameForSaving() {
        String tempFileName = this.getDisplayName();
        if (tempFileName != null && tempFileName.length() > 0) {
            return tempFileName;
        }
        tempFileName = this.getKeywordTopic();
        if (tempFileName != null && tempFileName.length() > 0) {
            return tempFileName;
        }
        URN urn = this.getSHA1Urn();
        if (urn != null) {
            tempFileName = urn.toString();
            return tempFileName;
        }
        String[] urls = this.getDefaultURLs();
        if (urls.length > 0) {
            try {
                URI uri = URIUtils.toURI(urls[0]);
                tempFileName = MagnetOptions.extractFileName(uri);
                if (tempFileName != null && tempFileName.length() > 0) {
                    return tempFileName;
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        try {
            File file = FileUtils.createTempFile("magnet", "");
            file.deleteOnExit();
            tempFileName = file.getName();
            return tempFileName;
        }
        catch (IOException ie) {
            tempFileName = DOWNLOAD_PREFIX;
            return tempFileName;
        }
    }

    public String getKeywordTopic() {
        List<String> list = this.optionsMap.get((Object)Option.KT);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public long getFileSize() {
        if (this.fileSize == -2L) {
            List<String> lengthValues = this.getList(Option.XL);
            long size = -1L;
            for (String value : lengthValues) {
                try {
                    size = Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {}
            }
            this.fileSize = size >= 0L ? size : -1L;
        }
        return this.fileSize;
    }

    public List<String> getExactTopics() {
        return this.getList(Option.XT);
    }

    public List<String> getXS() {
        return this.getList(Option.XS);
    }

    public List<String> getXL() {
        return this.getList(Option.XL);
    }

    public List<String> getAS() {
        return this.getList(Option.AS);
    }

    private List<String> getList(Option key) {
        List<String> l = this.optionsMap.get((Object)key);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public String getErrorMessage() {
        return this.localizedErrorMessage;
    }

    public static String extractFileName(URI uri) {
        String path = null;
        String host = null;
        path = uri.getPath();
        host = uri.getHost();
        if (path != null && path.length() > 0) {
            int i = path.lastIndexOf(47);
            if (i < 0) {
                return path;
            }
            if (i >= 0 && i < path.length() - 1) {
                return path.substring(i + 1);
            }
        }
        if (host != null) {
            return DOWNLOAD_PREFIX + host;
        }
        return DOWNLOAD_PREFIX;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Option {
        XS,
        XT,
        AS,
        DN,
        KT,
        XL;


        public static Option valueFor(String str) {
            for (Option option : Option.values()) {
                if (!str.toUpperCase(Locale.US).startsWith(option.toString())) continue;
                return option;
            }
            return null;
        }
    }
}

