/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.RemoteClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public final class BugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;
    private static BugManager INSTANCE;
    private final String TITLE = I18n.tr("Internal Error");
    private static final int DIALOG_BOX_WIDTH = 300;
    private static final int DIALOG_BOX_HEIGHT = 100;
    private static final String TEXT_AREA_DESCRIPTION_TEXT;
    private final ExecutorService BUGS_QUEUE = ExecutorsHelper.newProcessingQueue(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "BugProcessor");
            t.setDaemon(true);
            return t;
        }
    });
    private final Map<String, Long> BUG_TIMES = Collections.synchronizedMap(new HashMap());
    private final Object WRITE_LOCK = new Object();
    private final byte[] SEPARATOR = "-----------------\n".getBytes();
    private volatile long _nextAllowedTime = 0L;
    private volatile int _dialogsShowing = 0;
    private final int MAX_DIALOGS = 3;
    private boolean dirty = false;
    @InspectionPoint(value="bug report")
    private static final Inspectable INSPECTABLE;

    public static synchronized BugManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new BugManager();
        }
        return INSTANCE;
    }

    private BugManager() {
        this.loadOldBugs();
    }

    public void shutdown() {
        this.writeBugsToDisk();
    }

    public void handleBug(Throwable bug, String threadName, String detail) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        if (bug instanceof IOException && IOUtils.handleException((IOException)bug, IOUtils.ErrorType.GENERIC)) {
            return;
        }
        bug.printStackTrace();
        LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(bug, threadName, detail, false);
        if (BugSettings.LOG_BUGS_LOCALLY.getValue()) {
            this.logBugLocally(info);
        }
        boolean sent = false;
        if (!LimeWireUtils.isTestingVersion()) {
            if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
                return;
            }
            if (!this.shouldInform(info)) {
                return;
            }
            if (this.isSendableVersion() && (LimeWireUtils.isAlphaRelease() || BugSettings.USE_BUG_SERVLET.getValue())) {
                sent = true;
            }
            if (sent) {
                this.sendToServlet(info);
            }
        }
        if (!sent && this._dialogsShowing < 3) {
            this.reviewBug(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logBugLocally(LocalClientInfo info) {
        File f = BugSettings.BUG_LOG_FILE.getValue();
        FileUtils.setWriteable(f);
        BufferedOutputStream os = null;
        try {
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                if (f.length() > (long)BugSettings.MAX_BUGFILE_SIZE.getValue()) {
                    f.delete();
                }
                os = new BufferedOutputStream(new FileOutputStream(f.getPath(), true));
                ((OutputStream)os).write((new Date().toString() + "\n").getBytes());
                ((OutputStream)os).write(info.toBugReport().getBytes());
                ((OutputStream)os).write(this.SEPARATOR);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException ignored) {
            IOUtils.close(os);
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadOldBugs() {
        ObjectInputStream in;
        block6: {
            in = null;
            File f = BugSettings.BUG_INFO_FILE.getValue();
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
                String version = (String)in.readObject();
                long nextTime = in.readLong();
                if (version.equals(LimeWireUtils.getLimeWireVersion())) {
                    Map<String, Long> bugs = GenericsUtils.scanForMap(in.readObject(), String.class, Long.class, GenericsUtils.ScanMode.REMOVE);
                    this._nextAllowedTime = nextTime;
                    long now = System.currentTimeMillis();
                    for (Map.Entry<String, Long> entry : bugs.entrySet()) {
                        Long allowed = entry.getValue();
                        if (allowed == null || now >= allowed) continue;
                        this.BUG_TIMES.put(entry.getKey(), allowed);
                    }
                    break block6;
                }
                if (!BugSettings.IGNORE_ALL_BUGS.getValue()) break block6;
                BugSettings.IGNORE_ALL_BUGS.setValue(false);
                BugSettings.USE_BUG_SERVLET.setValue(false);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                catch (Throwable throwable2) {
                    IOUtils.close(in);
                    throw throwable2;
                }
            }
        }
        IOUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeBugsToDisk() {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            if (!this.dirty) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                File f = BugSettings.BUG_INFO_FILE.getValue();
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                String version = LimeWireUtils.getLimeWireVersion();
                out.writeObject(version);
                out.writeLong(this._nextAllowedTime);
                out.writeObject(this.BUG_TIMES);
                out.flush();
            }
            catch (Exception exception) {
                IOUtils.close(out);
                catch (Throwable throwable) {
                    IOUtils.close(out);
                    throw throwable;
                }
            }
            IOUtils.close(out);
            this.dirty = false;
        }
    }

    private boolean shouldInform(LocalClientInfo info) {
        long now = System.currentTimeMillis();
        if (now < this._nextAllowedTime) {
            return false;
        }
        Long allowed = this.BUG_TIMES.get(info.getParsedBug());
        return allowed == null || now >= allowed;
    }

    private boolean isSendableVersion() {
        Version lastVersion;
        Version myVersion;
        try {
            myVersion = new Version(LimeWireUtils.getLimeWireVersion());
            lastVersion = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException vfe) {
            return false;
        }
        return myVersion.compareTo(lastVersion) >= 0;
    }

    private static String warning() {
        String msg = "Uijt!jt!MjnfXjsf/!Uif!pggjdjbm!xfctjuf!jt!xxx/mjnfxjsf/dpn/";
        StringBuilder ret = new StringBuilder(msg.length());
        for (int i = 0; i < msg.length(); ++i) {
            ret.append((char)(msg.charAt(i) - '\u0001'));
        }
        return ret.toString();
    }

    private void reviewBug(final LocalClientInfo info) {
        ++this._dialogsShowing;
        final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(300, 100);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        boolean sendable = this.isSendableVersion();
        String msg = sendable ? I18n.tr("LimeWire has encountered an internal error. It is possible for LimeWire to recover and continue running normally. To aid with debugging, please click 'Send' to notify LimeWire about the problem. If desired, you can click 'Review' to look at the information that will be sent. Thank you.") : I18n.tr("LimeWire has encountered an internal error. It is possible for LimeWire to recover and continue running normally. To continue using LimeWire, click 'Discard'. If desired, you can click 'Review' to look at the information about the error.");
        msg = BugManager.warning() + "\n\n" + msg;
        MultiLineLabel label = new MultiLineLabel(msg, 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        labelPanel.add((Component)label, constraints);
        String textAreaDescription = TEXT_AREA_DESCRIPTION_TEXT;
        final JTextArea userCommentsTextArea = new JTextArea(textAreaDescription);
        userCommentsTextArea.setLineWrap(true);
        userCommentsTextArea.setWrapStyleWord(true);
        userCommentsTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (userCommentsTextArea.getText().equals(TEXT_AREA_DESCRIPTION_TEXT)) {
                    userCommentsTextArea.selectAll();
                }
            }
        });
        JScrollPane userCommentsScrollPane = new JScrollPane(userCommentsTextArea);
        userCommentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        userCommentsScrollPane.setPreferredSize(new Dimension(400, 80));
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton(I18n.tr("Send"));
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String userComments = userCommentsTextArea.getText();
                if (!userComments.equals(TEXT_AREA_DESCRIPTION_TEXT)) {
                    info.addUserComments(userComments);
                }
                BugManager.this.sendToServlet(info);
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        JButton reviewButton = new JButton(I18n.tr("Review"));
        reviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String userComments = userCommentsTextArea.getText();
                if (!userComments.equals(TEXT_AREA_DESCRIPTION_TEXT)) {
                    info.addUserComments(userComments);
                }
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                textArea.setCaretPosition(0);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                MessageService.instance().showMessage(scroller);
            }
        });
        JButton discardButton = new JButton(I18n.tr("Discard"));
        discardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        if (sendable) {
            buttonPanel.add(sendButton);
        }
        buttonPanel.add(reviewButton);
        buttonPanel.add(discardButton);
        JPanel optionsPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        optionsPanel.setLayout(new BorderLayout());
        final JRadioButton alwaysSend = new JRadioButton(I18n.tr("Always Send Immediately"));
        final JRadioButton alwaysReview = new JRadioButton(I18n.tr("Always Ask For Review"));
        final JRadioButton alwaysDiscard = new JRadioButton(I18n.tr("Always Discard All Errors"));
        innerPanel.add(Box.createVerticalStrut(6));
        if (!LimeWireUtils.isTestingVersion()) {
            if (sendable) {
                innerPanel.add(alwaysSend);
            }
            innerPanel.add(alwaysReview);
            innerPanel.add(alwaysDiscard);
        }
        innerPanel.add(Box.createVerticalStrut(6));
        optionsPanel.add((Component)innerPanel, "West");
        bg.add(alwaysSend);
        bg.add(alwaysReview);
        bg.add(alwaysDiscard);
        bg.setSelected(alwaysReview.getModel(), true);
        ActionListener alwaysListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == alwaysSend) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_BUG_SERVLET.setValue(true);
                } else if (e.getSource() == alwaysReview) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_BUG_SERVLET.setValue(false);
                } else if (e.getSource() == alwaysDiscard) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(true);
                }
            }
        };
        alwaysSend.addActionListener(alwaysListener);
        alwaysReview.addActionListener(alwaysListener);
        alwaysDiscard.addActionListener(alwaysListener);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        mainPanel.add((Component)labelPanel, constraints);
        if (sendable) {
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(20, 0, 6, 0);
            mainPanel.add((Component)userCommentsScrollPane, constraints);
        }
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        mainPanel.add((Component)optionsPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        mainPanel.add((Component)buttonPanel, constraints);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        if (GUIMediator.isAppVisible()) {
            DIALOG.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = DIALOG.getSize();
            DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
        try {
            DIALOG.setVisible(true);
        }
        catch (InternalError ie) {
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            // empty catch block
        }
    }

    private void servletSendFailed(LocalClientInfo info) {
        ++this._dialogsShowing;
        final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 300);
        Dimension ERROR_DIMENSION = new Dimension(300, 200);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(I18n.tr("LimeWire was unable to connect to the bug server in order to send the below bug report. For further help and to aid with debugging, please visit www.limewire.com and click 'Support'. Thank you."), 400);
        JPanel labelPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(label);
        innerPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerPanel);
        labelPanel.add(Box.createHorizontalGlue());
        String bugInfo = info.toBugReport().trim() + "\n\n" + "FILES IN CURRENT DIRECTORY NOT LISTED.\n" + "SIZE: 0";
        final JTextArea textArea = new JTextArea(bugInfo);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(ERROR_DIMENSION);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton(I18n.tr("Copy Report"));
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
                textArea.setCaretPosition(0);
            }
        });
        JButton quitButton = new JButton(I18n.tr("OK"));
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add(labelPanel);
        mainPanel.add(scroller);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        try {
            DIALOG.pack();
        }
        catch (OutOfMemoryError oome) {
            return;
        }
        if (GUIMediator.isAppVisible()) {
            DIALOG.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = DIALOG.getSize();
            DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
        DIALOG.setVisible(true);
    }

    private void sendToServlet(LocalClientInfo info) {
        this.BUGS_QUEUE.execute(new ServletSender(info));
    }

    static {
        TEXT_AREA_DESCRIPTION_TEXT = I18n.tr("Please add any comments you may have (e.g what caused the error). \nThank you and please use English.");
        INSPECTABLE = new Inspectable(){

            public Object inspect() {
                if (!ApplicationSettings.USAGE_STATS.getValue() && !LimeWireUtils.isAlphaRelease()) {
                    return "Denied";
                }
                Exception e = new Exception();
                e.setStackTrace(new StackTraceElement[0]);
                LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(e, "", "", false);
                return info.getShortParamList();
            }
        };
    }

    private class ServletSender
    implements Runnable {
        final LocalClientInfo INFO;

        ServletSender(LocalClientInfo info) {
            this.INFO = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RemoteClientInfo remoteInfo = new ServletAccessor().getRemoteBugInfo(this.INFO);
            if (remoteInfo == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BugManager.this.servletSendFailed(ServletSender.this.INFO);
                    }
                });
                return;
            }
            long now = System.currentTimeMillis();
            long thisNextTime = remoteInfo.getNextThisBugTime();
            long anyNextTime = remoteInfo.getNextAnyBugTime();
            Object object = BugManager.this.WRITE_LOCK;
            synchronized (object) {
                if (anyNextTime != 0L) {
                    BugManager.this._nextAllowedTime = now + thisNextTime;
                    BugManager.this.dirty = true;
                }
                if (thisNextTime != 0L) {
                    BugManager.this.BUG_TIMES.put(this.INFO.getParsedBug(), new Long(now + thisNextTime));
                    BugManager.this.dirty = true;
                }
                BugManager.this.writeBugsToDisk();
            }
        }
    }
}

