/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionBandwidthStatistics;
import com.limegroup.gnutella.connection.ConnectionBandwidthStatisticsImpl;
import com.limegroup.gnutella.connection.ConnectionCapabilities;
import com.limegroup.gnutella.connection.ConnectionCapabilitiesImpl;
import com.limegroup.gnutella.connection.SimpleProtocolBandwidthTracker;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.NetworkSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.setting.StringSetting;

public abstract class AbstractConnection
implements Connection {
    private final Object pingLock = new Object();
    private final Object pongLock = new Object();
    private final SocketsManager.ConnectType connectType;
    private final String host;
    private final byte[] hostBytes;
    private volatile int port;
    protected volatile Socket socket;
    private final boolean outgoing;
    private volatile byte softMax;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile long nextPingTime = Long.MIN_VALUE;
    private volatile long nextPongTime = Long.MIN_VALUE;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final MessagesSupportedVendorMessage supportedVendorMessage;
    private final ConnectionCapabilities connectionCapabilities;
    private final ConnectionBandwidthStatistics connectionBandwidthStatistics;
    private volatile long connectionTime;
    private final NetworkManager networkManager;
    private final Acceptor acceptor;
    private final SimpleProtocolBandwidthTracker simpleProtocolBandwidthTracker;
    protected volatile byte[] myIp;
    protected static final IOException CONNECTION_CLOSED = new IOException("connection closed");
    private final NetworkInstanceUtils networkInstanceUtils;

    AbstractConnection(String host, int port, SocketsManager.ConnectType connectType, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage supportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        this(host, port, connectType, null, capabilitiesVMFactory, supportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
    }

    AbstractConnection(Socket socket, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage supportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        this(socket.getInetAddress().getHostAddress(), socket.getPort(), SSLUtils.isTLSEnabled(socket) ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN, socket, capabilitiesVMFactory, supportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
    }

    private AbstractConnection(String host, int port, SocketsManager.ConnectType connectType, Socket socket, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage supportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        this.host = host;
        this.port = port;
        this.outgoing = socket == null;
        this.connectType = connectType;
        this.socket = socket;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.supportedVendorMessage = supportedVendorMessage;
        this.connectionCapabilities = new ConnectionCapabilitiesImpl();
        this.connectionBandwidthStatistics = new ConnectionBandwidthStatisticsImpl();
        this.networkManager = networkManager;
        this.acceptor = acceptor;
        this.simpleProtocolBandwidthTracker = new SimpleProtocolBandwidthTracker();
        this.networkInstanceUtils = networkInstanceUtils;
        byte[] hostBytes = null;
        try {
            hostBytes = InetAddress.getByName(this.getAddress()).getAddress();
        }
        catch (UnknownHostException bad) {
            // empty catch block
        }
        this.hostBytes = hostBytes;
        if (!this.outgoing) {
            this.connectionBandwidthStatistics.setTlsOption(SSLUtils.isTLSEnabled(socket), SSLUtils.getSSLBandwidthTracker(socket));
        }
        this.connectionBandwidthStatistics.setRawBandwidthTracker(this.simpleProtocolBandwidthTracker);
    }

    public void sendPostInitializeMessages() {
        try {
            if (this.getConnectionCapabilities().getHeadersRead().supportsVendorMessages() > 0.0f) {
                this.send(this.supportedVendorMessage);
                this.send(this.capabilitiesVMFactory.getCapabilitiesVM());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendUpdatedCapabilities() {
        try {
            if (this.getConnectionCapabilities().getHeadersRead().supportsVendorMessages() > 0.0f) {
                this.send(this.capabilitiesVMFactory.getCapabilitiesVM());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleVendorMessage(VendorMessage vm) {
        if (vm instanceof MessagesSupportedVendorMessage) {
            this.getConnectionCapabilities().setMessagesSupportedVendorMessage((MessagesSupportedVendorMessage)vm);
        } else if (vm instanceof CapabilitiesVM) {
            this.getConnectionCapabilities().setCapabilitiesVendorMessage((CapabilitiesVM)vm);
        } else if (vm instanceof HeaderUpdateVendorMessage) {
            HeaderUpdateVendorMessage huvm = (HeaderUpdateVendorMessage)vm;
            Properties props = this.getConnectionCapabilities().getHeadersRead().props();
            props.putAll((Map<?, ?>)huvm.getProperties());
            this.setHeaders(HandshakeResponse.createResponse(props), null);
        }
    }

    protected void setHeaders(HandshakeResponse headersRead, HandshakeResponse headersWritten) {
        if (headersRead != null) {
            this.getConnectionCapabilities().setHeadersRead(headersRead);
        }
        if (headersWritten != null) {
            this.getConnectionCapabilities().setHeadersWritten(headersWritten);
        }
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public String getAddress() {
        return this.host;
    }

    public byte[] getAddressBytes() {
        return this.hostBytes;
    }

    public int getPort() {
        return this.port;
    }

    public int getListeningPort() {
        if (this.isOutgoing()) {
            if (this.socket == null) {
                return -1;
            }
            return this.socket.getPort();
        }
        return this.getConnectionCapabilities().getHeadersRead().getListeningPort();
    }

    public void setListeningPort(int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.port = port;
    }

    public InetSocketAddress getInetSocketAddress() throws IllegalStateException {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this.socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this.socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
        this.getConnectionBandwidthStatistics().setTlsOption(SSLUtils.isTLSEnabled(socket), SSLUtils.getSSLBandwidthTracker(socket));
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long millis) {
        return (millis - this.getConnectionTime()) / 1000L > 5L;
    }

    public String getPropertyWritten(String name) {
        return this.getConnectionCapabilities().getHeadersWritten().props().getProperty(name);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    protected SocketsManager.ConnectType getConnectType() {
        return this.connectType;
    }

    public final void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        IOUtils.close(this.socket);
        this.closeImpl();
    }

    protected abstract void closeImpl();

    public boolean isWriteDeflated() {
        return this.getConnectionCapabilities().getHeadersWritten().isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this.getConnectionCapabilities().getHeadersRead().isDeflateEnabled();
    }

    public boolean isTLSCapable() {
        if (!this.getConnectionCapabilities().isCapabilitiesVmSet() && this.isTLSEncoded()) {
            return true;
        }
        return this.getConnectionCapabilities().getCapability(ConnectionCapabilities.Capability.TLS) >= 1;
    }

    public boolean isTLSEncoded() {
        return this.connectType == SocketsManager.ConnectType.TLS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.pingLock;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this.nextPingTime) {
                return false;
            }
            this.nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.pongLock;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            if (!this.isStable(curTime)) {
                return false;
            }
            if (curTime < this.nextPongTime) {
                return false;
            }
            int interval = curTime - this.getConnectionTime() < 10000L ? 300 : 12000;
            this.nextPongTime = curTime + (long)interval;
            return true;
        }
    }

    protected void processReadMessage(Message m) {
        this.simpleProtocolBandwidthTracker.addRead(m.getTotalLength());
    }

    protected void processWrittenMessage(Message m) {
        this.simpleProtocolBandwidthTracker.addWritten(m.getTotalLength());
    }

    protected void initializeHandshake() throws IOException {
        if (!this.isOpen()) {
            IOUtils.close(this.getSocket());
            throw CONNECTION_CLOSED;
        }
        InetAddress localAddress = this.getSocket().getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this.getSocket().getInetAddress().equals(localAddress) && this.getPort() == NetworkSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        this.acceptor.setAddress(localAddress);
    }

    protected byte getSoftMax() {
        return this.softMax;
    }

    protected void handshakeInitialized(Handshaker handshaker) {
        this.setHeaders(handshaker.getReadHeaders(), handshaker.getWrittenHeaders());
        this.connectionTime = System.currentTimeMillis();
        this.softMax = ConnectionSettings.SOFT_MAX.getValue();
        if (this.getConnectionCapabilities().isGoodUltrapeer() || this.getConnectionCapabilities().isGoodLeaf()) {
            this.softMax = (byte)(this.softMax + 1);
        }
        this.updateAddress(handshaker.getReadHeaders());
    }

    private void updateAddress(HandshakeResponse readHeaders) {
        String ip = readHeaders.getProperty("Remote-IP");
        if (ip == null) {
            return;
        }
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        if (!NetworkUtils.isValidAddress(ia) || this.networkInstanceUtils.isPrivateAddress(ia)) {
            return;
        }
        this.myIp = ia.getAddress();
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            StringSetting addr = ConnectionSettings.FORCED_IP_ADDRESS_STRING;
            if (!ip.equals(addr.getValue())) {
                addr.setValue(ip);
                this.networkManager.addressChanged();
            }
        } else if (!NetworkUtils.isValidAddress(this.networkManager.getAddress())) {
            this.acceptor.setAddress(ia);
        }
        this.acceptor.setExternalAddress(ia);
    }

    public void handleSimppVM(SimppVM simppVM) throws IOException {
        this.send(simppVM);
    }

    public String toString() {
        return "CONNECTION: host=" + this.host + " port=" + this.port;
    }

    public String getLocalePref() {
        return this.getConnectionCapabilities().getHeadersRead().getLocalePref();
    }

    public ConnectionCapabilities getConnectionCapabilities() {
        return this.connectionCapabilities;
    }

    public ConnectionBandwidthStatistics getConnectionBandwidthStatistics() {
        return this.connectionBandwidthStatistics;
    }
}

