/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.util.List;
import java.util.Map;
import org.limewire.collection.Buffer;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionStats {
    private volatile int _numMessagesSent;
    private volatile int _numMessagesReceived;
    private volatile int _numReceivedMessagesDropped;
    private volatile int _numSentMessagesDropped;
    private volatile long repliesReceived;
    private volatile long repliesSent;
    private volatile long queriesReceived;
    private volatile long queriesSent;
    private volatile int _lastReceived;
    private volatile int _lastRecvDropped;
    private volatile int _lastSent;
    private volatile int _lastSentDropped;
    private final Buffer<Byte> responsesPerReply = new Buffer(200);
    private final Buffer<Byte> altsPerResponse = new Buffer(200);
    private final Buffer<Short> altsPerReply = new Buffer(200);

    public int getSent() {
        return this._numMessagesSent;
    }

    public int getReceived() {
        return this._numMessagesReceived;
    }

    public int getSentDropped() {
        return this._numSentMessagesDropped;
    }

    public int getReceivedDropped() {
        return this._numReceivedMessagesDropped;
    }

    public long getRepliesReceived() {
        return this.repliesReceived;
    }

    public void addSentDropped(int dropped) {
        this._numSentMessagesDropped += dropped;
    }

    public void addSent(Message m) {
        ++this._numMessagesSent;
        if (m instanceof QueryRequest) {
            ++this.queriesSent;
        } else if (m instanceof QueryReply) {
            ++this.repliesSent;
        }
    }

    public void addReceivedDropped() {
        ++this._numReceivedMessagesDropped;
    }

    public void addReceived() {
        ++this._numMessagesReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(QueryReply r) {
        List<Response> responses;
        byte count = (byte)r.getUniqueResultCount();
        try {
            responses = r.getResultsAsList();
        }
        catch (BadPacketException ignore) {
            return;
        }
        ConnectionStats connectionStats = this;
        synchronized (connectionStats) {
            this.responsesPerReply.add(count);
            short total = 0;
            for (Response resp : responses) {
                byte resps = (byte)resp.getLocations().size();
                this.altsPerResponse.add(resps);
                total = (short)(total + resps);
            }
            this.altsPerReply.add(total);
            ++this.repliesReceived;
        }
    }

    public void queryReceived() {
        ++this.queriesReceived;
    }

    public synchronized float getPercentReceivedDropped() {
        int rdiff = this._numMessagesReceived - this._lastReceived;
        int ddiff = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return percent;
    }

    public synchronized float getPercentSentDropped() {
        int rdiff = this._numMessagesSent - this._lastSent;
        int ddiff = this._numSentMessagesDropped - this._lastSentDropped;
        float percent = rdiff == 0 ? 0.0f : (float)ddiff / (float)rdiff * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(Map<String, Object> m) {
        m.put("nqr", this.repliesReceived);
        m.put("nqs", this.repliesSent);
        m.put("npr", this.queriesReceived);
        m.put("nps", this.queriesSent);
        ConnectionStats connectionStats = this;
        synchronized (connectionStats) {
            int i;
            m.put("nqr", this.repliesReceived);
            byte[] resps = new byte[this.responsesPerReply.size()];
            byte[] alts = new byte[this.altsPerResponse.size()];
            byte[] altsReply = new byte[this.altsPerReply.size() * 2];
            for (i = 0; i < this.responsesPerReply.size(); ++i) {
                resps[i] = this.responsesPerReply.get(i);
            }
            for (i = 0; i < this.altsPerResponse.size(); ++i) {
                alts[i] = this.altsPerResponse.get(i);
            }
            for (i = 0; i < this.altsPerReply.size(); ++i) {
                ByteUtils.short2leb(this.altsPerReply.get(i), altsReply, i * 2);
            }
            m.put("respreply", resps);
            m.put("altresp", alts);
            m.put("altreply", altsReply);
        }
    }
}

