/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.connection.GnutellaConnection;
import com.limegroup.gnutella.connection.MessageReaderFactory;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.RoutedConnectionFactory;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.handshaking.HandshakeResponderFactory;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.version.UpdateHandler;
import java.net.Socket;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RoutedConnectionFactoryImpl
implements RoutedConnectionFactory {
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final HeadersFactory headersFactory;
    private final HandshakeResponderFactory handshakeResponderFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final Provider<MessageDispatcher> messageDispatcher;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<SocketsManager> socketsManager;
    private final Provider<Acceptor> acceptor;
    private final MessagesSupportedVendorMessage supportedVendorMessage;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<ConnectionServices> connectionServices;
    private final GuidMapManager guidMapManager;
    private final SpamFilterFactory spamFilterFactory;
    private final MessageFactory messageFactory;
    private final MessageReaderFactory messageReaderFactory;
    private final ApplicationServices applicationServices;
    private final Provider<SecureMessageVerifier> secureMessageVerifier;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public RoutedConnectionFactoryImpl(Provider<ConnectionManager> connectionManager, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, Provider<MessageDispatcher> messageDispatcher, Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker, Provider<SearchResultHandler> searchResultHandler, CapabilitiesVMFactory capabilitiesVMFactory, Provider<SocketsManager> socketsManager, Provider<Acceptor> acceptor, MessagesSupportedVendorMessage supportedVendorMessage, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, Provider<ConnectionServices> connectionServices, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageFactory messageFactory, MessageReaderFactory messageReaderFactory, ApplicationServices applicationServices, Provider<SecureMessageVerifier> secureMessageVerifier, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = messageDispatcher;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.applicationServices = applicationServices;
        this.searchResultHandler = searchResultHandler;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.socketsManager = socketsManager;
        this.acceptor = acceptor;
        this.supportedVendorMessage = supportedVendorMessage;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.connectionServices = connectionServices;
        this.guidMapManager = guidMapManager;
        this.spamFilterFactory = spamFilterFactory;
        this.messageFactory = messageFactory;
        this.messageReaderFactory = messageReaderFactory;
        this.secureMessageVerifier = secureMessageVerifier;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public RoutedConnection createRoutedConnection(String host, int port) {
        return this.createRoutedConnection(host, port, SocketsManager.ConnectType.PLAIN);
    }

    @Override
    public RoutedConnection createRoutedConnection(String host, int port, SocketsManager.ConnectType type) {
        return new GnutellaConnection(host, port, type, this.connectionManager.get(), this.networkManager, this.queryRequestFactory, this.headersFactory, this.handshakeResponderFactory, this.queryReplyFactory, this.messageDispatcher.get(), this.networkUpdateSanityChecker.get(), this.searchResultHandler.get(), this.capabilitiesVMFactory, this.socketsManager.get(), this.acceptor.get(), this.supportedVendorMessage, this.simppManager, this.updateHandler, this.connectionServices, this.guidMapManager, this.spamFilterFactory, this.messageReaderFactory, this.messageFactory, this.applicationServices, this.secureMessageVerifier.get(), this.outOfBandStatistics, this.networkInstanceUtils);
    }

    @Override
    public RoutedConnection createRoutedConnection(Socket socket) {
        return new GnutellaConnection(socket, this.connectionManager.get(), this.networkManager, this.queryRequestFactory, this.headersFactory, this.handshakeResponderFactory, this.queryReplyFactory, this.messageDispatcher.get(), this.networkUpdateSanityChecker.get(), this.searchResultHandler.get(), this.capabilitiesVMFactory, this.acceptor.get(), this.supportedVendorMessage, this.simppManager, this.updateHandler, this.connectionServices, this.guidMapManager, this.spamFilterFactory, this.messageReaderFactory, this.messageFactory, this.applicationServices, this.secureMessageVerifier.get(), this.outOfBandStatistics, this.networkInstanceUtils);
    }
}

