/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DHTSettings;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTNodeFetcher {
    private static final Log LOG = LogFactory.getLog(DHTNodeFetcher.class);
    private final DHTBootstrapper bootstrapper;
    private volatile long lastRequest = 0L;
    private ScheduledFuture<?> fetcherTask = null;
    private final Object fetcherTaskLock = new Object();
    private final AtomicBoolean pingingSingleHost = new AtomicBoolean(false);
    private UDPPinger pinger;
    private volatile int pingExpireTime = -1;
    private final ConnectionServices connectionServices;
    private final Provider<HostCatcher> hostCatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<UDPPinger> udpPingerFactory;
    private final PingRequestFactory pingRequestFactory;

    public DHTNodeFetcher(DHTBootstrapper bootstrapper, ConnectionServices connectionServices, Provider<HostCatcher> hostCatcher, ScheduledExecutorService backgroundExecutor, Provider<UDPPinger> udpPingerFactory, PingRequestFactory pingRequestFactory) {
        this.connectionServices = connectionServices;
        this.hostCatcher = hostCatcher;
        this.backgroundExecutor = backgroundExecutor;
        this.udpPingerFactory = udpPingerFactory;
        this.bootstrapper = bootstrapper;
        this.pingRequestFactory = pingRequestFactory;
    }

    private synchronized void requestDHTHosts() {
        LOG.debug("Requesting DHT hosts");
        if (!this.connectionServices.isConnected()) {
            return;
        }
        List<ExtendedEndpoint> dhtHosts = this.hostCatcher.get().getDHTSupportEndpoint(0);
        boolean haveActive = false;
        for (ExtendedEndpoint ep : dhtHosts) {
            if (!DHTManager.DHTMode.ACTIVE.equals((Object)ep.getDHTMode())) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding active host from HostCatcher: " + ep.getInetSocketAddress());
            }
            haveActive = true;
            this.bootstrapper.addBootstrapHost(ep.getInetSocketAddress());
        }
        if (haveActive) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastRequest < DHTSettings.DHT_NODE_FETCHER_TIME.getValue()) {
            return;
        }
        if (this.pingingSingleHost.get()) {
            return;
        }
        this.lastRequest = now;
        PingRequest m = this.pingRequestFactory.createUDPingWithDHTIPPRequest();
        UDPPingerRequestListener listener = new UDPPingerRequestListener();
        UDPPingRankerCanceller canceller = new UDPPingRankerCanceller();
        if (!dhtHosts.isEmpty()) {
            LOG.debug("Sending ping to dht capable hosts");
            this.hostCatcher.get().getPinger().rank(dhtHosts, listener, canceller, m);
        } else {
            LOG.debug("Sending ping to all hosts");
            this.hostCatcher.get().sendMessageToAllHosts(m, listener, canceller);
        }
    }

    public void requestDHTHosts(SocketAddress hostAddress) {
        if (!this.connectionServices.isConnected()) {
            return;
        }
        if (!(hostAddress instanceof InetSocketAddress)) {
            return;
        }
        if (!this.pingingSingleHost.getAndSet(true)) {
            IpPortImpl ipp = new IpPortImpl((InetSocketAddress)hostAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting DHT hosts from host " + hostAddress);
            }
            PingRequest m = this.pingRequestFactory.createUDPingWithDHTIPPRequest();
            if (this.pinger == null) {
                this.pinger = this.udpPingerFactory.get();
            }
            this.pinger.rank(Arrays.asList(ipp), new SinglePingRequestListener(), null, m, this.pingExpireTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            if (this.fetcherTask != null) {
                return;
            }
            long fetcherTime = DHTSettings.DHT_NODE_FETCHER_TIME.getValue();
            long initialFetch = (long)(Math.random() * (double)fetcherTime);
            Runnable task = new Runnable(){

                public void run() {
                    DHTNodeFetcher.this.requestDHTHosts();
                }
            };
            this.fetcherTask = this.backgroundExecutor.scheduleWithFixedDelay(task, initialFetch, fetcherTime, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            if (this.fetcherTask != null) {
                this.fetcherTask.cancel(true);
                this.fetcherTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            return this.fetcherTask != null;
        }
    }

    private void processPingReply(Message m) {
        Collection<IpPort> list;
        if (!(m instanceof PingReply)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        PingReply reply = (PingReply)m;
        Collection<IpPort> collection = list = ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(reply.getPackedDHTIPPorts()) : reply.getPackedDHTIPPorts();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ping reply from " + reply.getAddress());
        }
        for (IpPort ipp : list) {
            this.bootstrapper.addBootstrapHost(new InetSocketAddress(ipp.getInetAddress(), ipp.getPort()));
        }
    }

    public void setPingExpireTime(int expireTime) {
        this.pingExpireTime = expireTime;
    }

    private class SinglePingRequestListener
    extends UDPPingerRequestListener {
        private SinglePingRequestListener() {
        }

        public void processMessage(Message m, ReplyHandler handler) {
            super.processMessage(m, handler);
            DHTNodeFetcher.this.pingingSingleHost.set(false);
        }

        public void unregistered(byte[] guid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering Ping");
            }
            DHTNodeFetcher.this.pingingSingleHost.set(false);
        }
    }

    private class UDPPingerRequestListener
    implements MessageListener {
        private UDPPingerRequestListener() {
        }

        public void processMessage(Message m, ReplyHandler handler) {
            DHTNodeFetcher.this.processPingReply(m);
        }

        public void registered(byte[] guid) {
        }

        public void unregistered(byte[] guid) {
        }
    }

    private class UDPPingRankerCanceller
    implements Cancellable {
        private UDPPingRankerCanceller() {
        }

        public boolean isCancelled() {
            boolean cancel;
            long delay = System.currentTimeMillis() - DHTNodeFetcher.this.lastRequest;
            boolean bl = cancel = DHTNodeFetcher.this.pingingSingleHost.get() || delay > DHTSettings.MAX_DHT_NODE_FETCHER_TIME.getValue() || !DHTNodeFetcher.this.connectionServices.isConnected() || !DHTNodeFetcher.this.isRunning();
            if (cancel && LOG.isDebugEnabled()) {
                LOG.debug("Cancelling UDP ping after " + delay + " ms, connected: " + DHTNodeFetcher.this.connectionServices.isConnected() + ", waiting: " + DHTNodeFetcher.this.bootstrapper.isWaitingForNodes());
            }
            return cancel;
        }
    }
}

