/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueForSelf;
import org.limewire.io.GGEP;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.util.ByteUtils;

public abstract class AbstractAltLocValue
implements AltLocValue {
    public static final DHTValueType ALT_LOC = DHTValueType.valueOf("Gnutella Alternate Location", "ALOC");
    public static final Version VERSION_ONE;
    public static final Version VERSION;
    static final String CLIENT_ID = "client-id";
    static final String PORT = "port";
    static final String FIREWALLED = "firewalled";
    static final String LENGTH = "length";
    static final String TTROOT = "ttroot";
    static final String TLS = "tls";
    protected final Version version;

    public AbstractAltLocValue(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public DHTValueType getValueType() {
        return ALT_LOC;
    }

    public int size() {
        return this.getValue().length;
    }

    public abstract byte[] getGUID();

    public abstract int getPort();

    public abstract long getFileSize();

    public abstract byte[] getRootHash();

    public abstract boolean isFirewalled();

    public abstract boolean supportsTLS();

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AltLoc: guid=").append(new GUID(this.getGUID())).append(", port=").append(this.getPort()).append(", firewalled=").append(this.isFirewalled()).append(", tls=").append(this.supportsTLS()).append(", fileSize=").append(this.getFileSize()).append(", ttroot=").append(this.getRootHash() != null ? ArrayUtils.toHexString(this.getRootHash()) : "null");
        if (this instanceof AltLocValueForSelf) {
            buffer.append(", local=true");
        }
        return buffer.toString();
    }

    protected static byte[] serialize(AbstractAltLocValue value) {
        Version version = value.getVersion();
        GGEP ggep = new GGEP();
        ggep.put(CLIENT_ID, value.getGUID());
        byte[] port = new byte[2];
        ByteUtils.short2beb((short)value.getPort(), port, 0);
        ggep.put(PORT, port);
        byte[] firewalled = new byte[]{(byte)(value.isFirewalled() ? 1 : 0)};
        ggep.put(FIREWALLED, firewalled);
        if (version.compareTo(VERSION_ONE) >= 0) {
            ggep.put(LENGTH, value.getFileSize());
            byte[] ttroot = value.getRootHash();
            if (ttroot != null) {
                ggep.put(TTROOT, ttroot);
            }
            if (value.supportsTLS()) {
                ggep.put(TLS);
            }
        }
        return ggep.toByteArray();
    }

    static {
        VERSION = VERSION_ONE = Version.valueOf(1);
    }
}

