/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.SearchListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.result.FindValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResultHandler
extends DHTFutureAdapter<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(AbstractResultHandler.class);
    protected final DHTManager dhtManager;
    protected final KUID key;
    private final SearchListener listener;
    protected final DHTValueType valueType;

    AbstractResultHandler(DHTManager dhtManager, KUID key, SearchListener listener, DHTValueType valueType) {
        this.dhtManager = dhtManager;
        this.key = key;
        this.listener = listener;
        this.valueType = valueType;
        if (listener == null) {
            throw new NullPointerException("listener should not be null");
        }
    }

    @Override
    public void handleFutureSuccess(FindValueResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("result: " + result);
        }
        Result outcome = Result.NOT_FOUND;
        if (result.isSuccess()) {
            for (DHTValueEntity dHTValueEntity : result.getEntities()) {
                outcome = this.updateResult(outcome, this.handleDHTValueEntity(dHTValueEntity));
            }
            for (EntityKey entityKey : result.getEntityKeys()) {
                DHTFuture<FindValueResult> future;
                if (!entityKey.getDHTValueType().equals(this.valueType) || (future = this.dhtManager.get(entityKey)) == null) continue;
                try {
                    FindValueResult resultFromKey = (FindValueResult)future.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("result from second lookup: " + resultFromKey);
                    }
                    if (!resultFromKey.isSuccess()) continue;
                    for (DHTValueEntity dHTValueEntity : resultFromKey.getEntities()) {
                        outcome = this.updateResult(outcome, this.handleDHTValueEntity(dHTValueEntity));
                    }
                }
                catch (ExecutionException e) {
                    LOG.error("ExecutionException", e);
                }
                catch (InterruptedException e) {
                    LOG.error("InterruptedException", e);
                }
            }
        }
        if (outcome == Result.NOT_FOUND) {
            LOG.debug("Not found");
            this.listener.searchFailed();
        }
    }

    private Result updateResult(Result oldValue, Result possibleValue) {
        if (oldValue == Result.FOUND || possibleValue == Result.FOUND) {
            return Result.FOUND;
        }
        if (oldValue == Result.NOT_YET_FOUND || possibleValue == Result.NOT_YET_FOUND) {
            return Result.NOT_YET_FOUND;
        }
        return possibleValue;
    }

    protected abstract Result handleDHTValueEntity(DHTValueEntity var1);

    @Override
    public void handleCancellationException(CancellationException e) {
        LOG.error("CancellationException", e);
        this.listener.searchFailed();
    }

    @Override
    public void handleExecutionException(ExecutionException e) {
        LOG.error("ExecutionException", e);
        this.listener.searchFailed();
    }

    @Override
    public void handleInterruptedException(InterruptedException e) {
        LOG.error("InterruptedException", e);
        this.listener.searchFailed();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractResultHandler)) {
            return false;
        }
        AbstractResultHandler other = (AbstractResultHandler)o;
        return this.key.equals(other.key) && this.valueType.equals(other.valueType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Result {
        FOUND(true),
        NOT_FOUND(false),
        NOT_YET_FOUND(false){

            public boolean isFound() {
                throw new UnsupportedOperationException("Should not have been called on " + (Object)((Object)this));
            }
        };

        private final boolean value;

        private Result(boolean value) {
            this.value = value;
        }

        public boolean isFound() {
            return this.value;
        }
    }
}

