/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.limewire.collection.MultiCollection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.DatabaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AltLocModel
implements StorableModel {
    private final Map<KUID, Storable> values = Collections.synchronizedMap(new HashMap());
    private final AltLocValueFactory altLocValueFactory;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final Provider<FileManager> fileManager;

    @Inject
    public AltLocModel(AltLocValueFactory altLocValueFactory, Provider<FileManager> fileManager, Provider<HashTreeCache> tigerTreeCache) {
        this.altLocValueFactory = altLocValueFactory;
        this.fileManager = fileManager;
        this.tigerTreeCache = tigerTreeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Storable> getStorables() {
        if (!DHTSettings.PUBLISH_ALT_LOCS.getValue()) {
            this.values.clear();
            return Collections.emptySet();
        }
        FileDesc[] fds = this.fileManager.get().getAllSharedFileDescriptors();
        ArrayList<Storable> toRemove = new ArrayList<Storable>();
        ArrayList<Storable> toPublish = new ArrayList<Storable>();
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            for (FileDesc fd : fds) {
                URN urn;
                KUID primaryKey;
                if (fd instanceof IncompleteFileDesc || this.values.containsKey(primaryKey = KUIDUtils.toKUID(urn = fd.getSHA1Urn()))) continue;
                long fileSize = fd.getFileSize();
                HashTree hashTree = this.tigerTreeCache.get().getHashTree(urn);
                byte[] ttroot = null;
                if (hashTree != null) {
                    ttroot = hashTree.getRootHashBytes();
                }
                AltLocValue value = this.altLocValueFactory.createAltLocValueForSelf(fileSize, ttroot);
                this.values.put(primaryKey, new Storable(primaryKey, value));
            }
            Iterator<Storable> it = this.values.values().iterator();
            while (it.hasNext()) {
                Storable storable = it.next();
                KUID primaryKey = storable.getPrimaryKey();
                URN urn = KUIDUtils.toURN(primaryKey);
                FileDesc fd = this.fileManager.get().getFileDescForUrn(urn);
                if (fd == null) {
                    storable = new Storable(primaryKey, DHTValue.EMPTY_VALUE);
                    it.remove();
                    toRemove.add(storable);
                    continue;
                }
                if (!this.fileManager.get().isRareFile(fd) || !DatabaseUtils.isPublishingRequired(storable)) continue;
                toPublish.add(storable);
            }
        }
        Collections.shuffle(toPublish);
        return new MultiCollection<Storable>((Collection<Storable>)toRemove, (Collection<Storable>)toPublish);
    }

    @Override
    public void handleStoreResult(Storable storable, StoreResult result) {
    }

    @Override
    public void handleContactChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder("AltLocPublisher: ");
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            buffer.append(CollectionUtils.toString(this.values.values()));
        }
        return buffer.toString();
    }
}

