/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.db.AltLocValueForSelf;
import com.limegroup.gnutella.dht.db.AltLocValueImpl;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;

@Singleton
public class AltLocValueFactoryImpl
implements AltLocValueFactory {
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    @Inject
    public AltLocValueFactoryImpl(NetworkManager networkManager, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    public AltLocValue createDHTValue(DHTValueType type, Version version, byte[] value) throws DHTValueException {
        return this.createFromData(version, value);
    }

    public AltLocValue createAltLocValueForSelf(long fileSize, byte[] ttroot) {
        return new AltLocValueForSelf(fileSize, ttroot, this.networkManager, this.applicationServices);
    }

    public AltLocValue createFromData(Version version, byte[] data) throws DHTValueException {
        return new AltLocValueImpl(version, data);
    }

    AltLocValue createAltLocValue(Version version, byte[] guid, int port, long length, byte[] ttroot, boolean firewalled) {
        return new AltLocValueImpl(version, guid, port, length, ttroot, firewalled, false);
    }
}

