/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import java.io.OutputStream;

class AltLocValueForSelf
extends AbstractAltLocValue {
    private static final long serialVersionUID = 8101291047246461600L;
    private final long fileSize;
    private final byte[] ttroot;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    public AltLocValueForSelf(long fileSize, byte[] ttroot, NetworkManager networkManager, ApplicationServices applicationServices) {
        super(AbstractAltLocValue.VERSION);
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Illegal fileSize: " + fileSize);
        }
        if (ttroot != null && ttroot.length != 24) {
            throw new IllegalArgumentException("Illegal ttroot length: " + ttroot.length);
        }
        this.fileSize = fileSize;
        this.ttroot = ttroot;
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    public byte[] getValue() {
        return AbstractAltLocValue.serialize(this);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.getValue());
    }

    public int getPort() {
        return this.networkManager.getPort();
    }

    public byte[] getGUID() {
        return this.applicationServices.getMyGUID();
    }

    public boolean isFirewalled() {
        return !this.networkManager.acceptedIncomingConnection();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public byte[] getRootHash() {
        return this.ttroot;
    }

    public boolean supportsTLS() {
        return SSLSettings.isIncomingTLSEnabled();
    }
}

