/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.dht.db.AbstractResultHandler;
import com.limegroup.gnutella.dht.db.BlockingSearchListener;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTPushEndpointFinder
implements PushEndpointService {
    private static final Log LOG = LogFactory.getLog(DHTPushEndpointFinder.class);
    private final PushEndpointFactory pushEndpointFactory;
    private final DHTManager dhtManager;

    @Inject
    public DHTPushEndpointFinder(DHTManager dhtManager, PushEndpointFactory pushEndpointFactory) {
        this.dhtManager = dhtManager;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    @Override
    public void findPushEndpoint(GUID guid, SearchListener<PushEndpoint> listener) {
        KUID key;
        EntityKey lookupKey;
        DHTFuture<FindValueResult> future;
        listener = SearchListenerAdapter.nonNullListener(listener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting dht lookup for guid: " + guid);
        }
        if ((future = this.dhtManager.get(lookupKey = EntityKey.createEntityKey(key = KUIDUtils.toKUID(guid), AbstractPushProxiesValue.PUSH_PROXIES))) != null) {
            future.addDHTFutureListener(new PushEndpointHandler(this.dhtManager, guid, key, listener));
        } else {
            LOG.debug("dht manager not bootstrapped or no dht");
            listener.searchFailed();
        }
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID guid) {
        BlockingSearchListener<PushEndpoint> listener = new BlockingSearchListener<PushEndpoint>();
        this.findPushEndpoint(guid, listener);
        return listener.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushEndpointHandler
    extends AbstractResultHandler {
        private final GUID guid;
        private final SearchListener<PushEndpoint> listener;

        private PushEndpointHandler(DHTManager dhtManager, GUID guid, KUID key, SearchListener<PushEndpoint> listener) {
            super(dhtManager, key, listener, AbstractPushProxiesValue.PUSH_PROXIES);
            this.guid = guid;
            this.listener = listener;
        }

        @Override
        protected AbstractResultHandler.Result handleDHTValueEntity(DHTValueEntity entity) {
            DHTValue value = entity.getValue();
            if (!(value instanceof PushProxiesValue)) {
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            Contact creator = entity.getCreator();
            InetAddress addr = ((InetSocketAddress)creator.getContactAddress()).getAddress();
            PushProxiesValue pushProxies = (PushProxiesValue)value;
            byte[] guid = this.guid.bytes();
            if (!Arrays.equals(guid, pushProxies.getGUID())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("The AltLoc and PushProxy GUIDs do not match!");
                }
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            Set<? extends IpPort> proxies = pushProxies.getPushProxies();
            byte features = pushProxies.getFeatures();
            int fwtVersion = pushProxies.getFwtVersion();
            IpPortImpl ipp = new IpPortImpl(addr, pushProxies.getPort());
            PushEndpoint pe = DHTPushEndpointFinder.this.pushEndpointFactory.createPushEndpoint(guid, proxies, features, fwtVersion, ipp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("push endpoint found: " + pe);
            }
            this.listener.handleResult(pe);
            return AbstractResultHandler.Result.FOUND;
        }
    }
}

