/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.dht.db.BlockingSearchListener;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.settings.DHTSettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class PushEndpointManagerImpl
implements PushEndpointService {
    private static final Log LOG = LogFactory.getLog(PushEndpointManagerImpl.class);
    private final PushEndpointCache pushEndpointCache;
    private final PushEndpointService pushEndpointFinder;
    private final ConcurrentMap<GUID, AtomicLong> lastSearchTimeByGUID = new ConcurrentHashMap<GUID, AtomicLong>();
    private volatile long timeBetweenSearches = DHTSettings.TIME_BETWEEN_PUSH_PROXY_QUERIES.getValue();

    @Inject
    public PushEndpointManagerImpl(PushEndpointCache pushEndpointCache, @Named(value="dhtPushEndpointFinder") PushEndpointService pushEndpointFinder) {
        this.pushEndpointCache = pushEndpointCache;
        this.pushEndpointFinder = pushEndpointFinder;
    }

    void setTimeBetweenSearches(long timeBetweenSearches) {
        this.timeBetweenSearches = timeBetweenSearches;
    }

    long getTimeBetweenSearches() {
        return this.timeBetweenSearches;
    }

    @Override
    public void findPushEndpoint(GUID guid, SearchListener<PushEndpoint> listener) {
        listener = SearchListenerAdapter.nonNullListener(listener);
        PushEndpoint cachedPushEndpoint = this.pushEndpointCache.getPushEndpoint(guid);
        if (cachedPushEndpoint != null && !cachedPushEndpoint.getProxies().isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found cached endpoint: " + cachedPushEndpoint);
            }
            listener.handleResult(cachedPushEndpoint);
        } else {
            long currentTime = System.currentTimeMillis();
            AtomicLong lastSearchTime = this.lastSearchTimeByGUID.putIfAbsent(guid, new AtomicLong(currentTime));
            if (lastSearchTime == null) {
                this.startSearch(guid, listener);
            } else {
                long lastSearch = lastSearchTime.longValue();
                if (currentTime - lastSearch > this.timeBetweenSearches) {
                    if (lastSearchTime.compareAndSet(lastSearch, currentTime)) {
                        this.startSearch(guid, listener);
                    } else {
                        listener.searchFailed();
                    }
                } else {
                    listener.searchFailed();
                }
            }
        }
    }

    void startSearch(GUID guid, final SearchListener<PushEndpoint> listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting dht search for: " + guid);
        }
        if (!DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
            listener.searchFailed();
            return;
        }
        this.pushEndpointFinder.findPushEndpoint(guid, new SearchListener<PushEndpoint>(){

            @Override
            public void handleResult(PushEndpoint result) {
                result.updateProxies(true);
                IpPort externalAddress = result.getValidExternalAddress();
                if (externalAddress != null) {
                    PushEndpointManagerImpl.this.pushEndpointCache.setAddr(result.getClientGUID(), externalAddress);
                }
                listener.handleResult(result);
            }

            @Override
            public void searchFailed() {
                LOG.debug("dht search failed");
                listener.searchFailed();
            }
        });
        this.purge();
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID guid) {
        BlockingSearchListener<PushEndpoint> listener = new BlockingSearchListener<PushEndpoint>();
        this.findPushEndpoint(guid, listener);
        return listener.getResult();
    }

    void purge() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry entry : this.lastSearchTimeByGUID.entrySet()) {
            assert (entry != null) : "entry is null: " + this.lastSearchTimeByGUID;
            assert (entry.getValue() != null) : "value of entry is null: " + this.lastSearchTimeByGUID;
            if (currentTime - ((AtomicLong)entry.getValue()).get() <= 2L * this.timeBetweenSearches) continue;
            this.lastSearchTimeByGUID.remove(entry.getKey(), entry.getValue());
        }
    }

    ConcurrentMap<GUID, AtomicLong> getLastSearchTimeByGUID() {
        return this.lastSearchTimeByGUID;
    }
}

