/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.dht.db.PushProxiesValueImpl;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.result.StoreResult;

@Singleton
public class PushProxiesPublisher
implements DHTEventListener {
    private static final Log LOG = LogFactory.getLog(PushProxiesPublisher.class);
    private volatile PushProxiesValue lastSeenValue;
    private volatile PushProxiesValue lastPublishedValue;
    private final PushProxiesValueFactory pushProxiesValueFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private volatile ScheduledFuture publishingFuture;
    private final DHTManager dhtManager;

    @Inject
    public PushProxiesPublisher(PushProxiesValueFactory pushProxiesValueFactory, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, DHTManager dhtManager) {
        this.pushProxiesValueFactory = pushProxiesValueFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.dhtManager = dhtManager;
    }

    private PushProxiesValue getCurrentPushproxiesValue() {
        PushProxiesValue pushProxiesValueForSelf = this.pushProxiesValueFactory.createDHTValueForSelf();
        return pushProxiesValueForSelf.getPushProxies().isEmpty() ? null : PushProxiesPublisher.createCopy(pushProxiesValueForSelf);
    }

    private static final PushProxiesValue createCopy(PushProxiesValue original) {
        return new PushProxiesValueImpl(original.getVersion(), original.getGUID(), original.getFeatures(), original.getFwtVersion(), original.getPort(), original.getPushProxies());
    }

    void publish() {
        PushProxiesValue valueToPublish = this.getValueToPublish();
        if (valueToPublish != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("publishing: " + valueToPublish);
            }
            GUID guid = new GUID(this.lastPublishedValue.getGUID());
            KUID primaryKey = KUIDUtils.toKUID(guid);
            DHTFuture<StoreResult> future = this.dhtManager.put(primaryKey, this.lastPublishedValue);
            if (LOG.isDebugEnabled() && future != null) {
                future.addDHTFutureListener(new DHTFutureListener<StoreResult>(){

                    @Override
                    public void handleCancellationException(CancellationException e) {
                        LOG.debug("cancelled", e);
                    }

                    @Override
                    public void handleExecutionException(ExecutionException e) {
                        LOG.debug("execution", e);
                    }

                    @Override
                    public void handleFutureSuccess(StoreResult result) {
                        LOG.debug("success: " + result);
                    }

                    @Override
                    public void handleInterruptedException(InterruptedException e) {
                        LOG.debug("interrupted", e);
                    }
                });
            }
        }
    }

    PushProxiesValue getValueToPublish() {
        if (this.pushProxiesAreStable() && this.valueToPublishChangedSignificantly()) {
            this.lastPublishedValue = this.lastSeenValue;
            return this.lastPublishedValue;
        }
        return null;
    }

    boolean valueToPublishChangedSignificantly() {
        if (this.lastSeenValue == null || this.lastSeenValue.equals(this.lastPublishedValue)) {
            return false;
        }
        if (this.lastPublishedValue == null) {
            return true;
        }
        if (this.lastSeenValue.getFwtVersion() != this.lastPublishedValue.getFwtVersion()) {
            return true;
        }
        IpPortSet old = new IpPortSet((Collection<? extends IpPort>)this.lastPublishedValue.getPushProxies());
        old.retainAll(this.lastSeenValue.getPushProxies());
        return old.size() < 2;
    }

    boolean pushProxiesAreStable() {
        PushProxiesValue previousValue = this.lastSeenValue;
        this.lastSeenValue = this.getCurrentPushproxiesValue();
        if (this.lastSeenValue == null) {
            return false;
        }
        return this.lastSeenValue.equals(previousValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("PushProxiesPublisher: ");
        buffer.append(this.lastPublishedValue);
        return buffer.toString();
    }

    public synchronized void handleDHTEvent(DHTEvent event) {
        if (event.getType() == DHTEvent.Type.CONNECTED) {
            LOG.debug("starting push proxy publishing");
            if (this.publishingFuture != null) {
                this.publishingFuture.cancel(false);
            }
            long interval = DHTSettings.PUSH_PROXY_STABLE_PUBLISHING_INTERVAL.getValue();
            long initialDelay = (long)(Math.random() * (double)interval);
            this.publishingFuture = this.backgroundExecutor.scheduleAtFixedRate(new PublishingRunnable(), initialDelay, interval, TimeUnit.MILLISECONDS);
        } else if (event.getType() == DHTEvent.Type.STOPPED) {
            LOG.debug("stopping push proxy publishing");
            if (this.publishingFuture != null) {
                this.publishingFuture.cancel(false);
                this.publishingFuture = null;
            }
        }
    }

    private class PublishingRunnable
    implements Runnable {
        private PublishingRunnable() {
        }

        public void run() {
            PushProxiesPublisher.this.publish();
        }
    }
}

