/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.io;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.dht.io.LimeMessageDispatcherImpl;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.io.MessageDispatcherFactory;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeMessageDispatcherFactoryImpl
implements MessageDispatcherFactory {
    private final Provider<MessageDispatcher> messageDispatcher;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<SecureMessageVerifier> secureMessageVerifier;
    private final Provider<UDPService> udpService;
    private final MessageFactory messageFactory;
    @InspectionPoint(value="dht sent messages")
    private final Message.MessageCounter sentDHTMessageCounter = new Message.MessageCounter(50);
    @InspectionPoint(value="dht received messages")
    private final Message.MessageCounter receivedDHTMessageCounter = new Message.MessageCounter(50);
    @InspectionPoint(value="dht sent messages histogram")
    private final InspectionHistogram<DHTMessage.OpCode> sentMessagesHistogram = new InspectionHistogram();
    @InspectionPoint(value="dht received messages histogram")
    private final InspectionHistogram<DHTMessage.OpCode> receivedMessagesHistogram = new InspectionHistogram();
    private final CountingMessageDispatcherListener dispatcherListener = new CountingMessageDispatcherListener();

    @Inject
    public LimeMessageDispatcherFactoryImpl(Provider<MessageDispatcher> messageDispatcher, Provider<MessageRouter> messageRouter, Provider<SecureMessageVerifier> secureMessageVerifier, Provider<UDPService> udpService, MessageFactory messageFactory) {
        this.messageDispatcher = messageDispatcher;
        this.messageRouter = messageRouter;
        this.secureMessageVerifier = secureMessageVerifier;
        this.udpService = udpService;
        this.messageFactory = messageFactory;
    }

    @Override
    public org.limewire.mojito.io.MessageDispatcher create(Context context) {
        LimeMessageDispatcherImpl messageDispatcherImpl = new LimeMessageDispatcherImpl(context, this.udpService, this.secureMessageVerifier, this.messageRouter, this.messageDispatcher, this.messageFactory);
        messageDispatcherImpl.addMessageDispatcherListener(this.dispatcherListener);
        return messageDispatcherImpl;
    }

    private class CountingMessageDispatcherListener
    implements MessageDispatcher.MessageDispatcherListener {
        private CountingMessageDispatcherListener() {
        }

        public void handleMessageDispatcherEvent(MessageDispatcher.MessageDispatcherEvent event) {
            switch (event.getEventType()) {
                case MESSAGE_RECEIVED: {
                    LimeMessageDispatcherFactoryImpl.this.receivedDHTMessageCounter.countMessage((Message)((Object)event.getMessage()));
                    LimeMessageDispatcherFactoryImpl.this.receivedMessagesHistogram.count(event.getMessage().getOpCode());
                    break;
                }
                case MESSAGE_SENT: {
                    LimeMessageDispatcherFactoryImpl.this.sentDHTMessageCounter.countMessage((Message)((Object)event.getMessage()));
                    LimeMessageDispatcherFactoryImpl.this.sentMessagesHistogram.count(event.getMessage().getOpCode());
                }
            }
        }
    }
}

