/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.util;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.limewire.mojito.KUID;

public class KUIDUtils {
    private KUIDUtils() {
    }

    public static KUID toKUID(URN urn) {
        if (!urn.isSHA1()) {
            throw new IllegalArgumentException("Expected a SHA-1 URN: " + urn);
        }
        return KUID.createWithBytes(urn.getBytes());
    }

    public static URN toURN(KUID kuid) {
        try {
            return URN.createSHA1UrnFromBytes(kuid.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KUID toKUID(GUID guid) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(guid.bytes());
            byte[] digest = md.digest();
            return KUID.createWithBytes(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

