/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.DIMEException;
import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.util.BufferUtils;
import org.limewire.util.ByteUtils;

public class AsyncDimeRecordReader
extends ReadState {
    private static final Log LOG = LogFactory.getLog(AsyncDimeRecordReader.class);
    private ByteBuffer header = ByteBuffer.allocate(12);
    private static final int OPTIONS = 0;
    private static final int OPTIONS_P = 1;
    private static final int ID = 2;
    private static final int ID_P = 3;
    private static final int TYPE = 4;
    private static final int TYPE_P = 5;
    private static final int DATA = 6;
    private static final int DATA_P = 7;
    private static final int TOTAL = 8;
    private ByteBuffer[] parts;

    public DIMERecord getRecord() throws DIMEException {
        if (this.parts == null || this.parts[6].hasRemaining() || this.parts[7].hasRemaining()) {
            return null;
        }
        try {
            return new DIMERecord(this.header.get(0), this.header.get(1), this.parts[0].array(), this.parts[2].array(), this.parts[4].array(), this.parts[6].array());
        }
        catch (IllegalArgumentException iae) {
            throw new DIMEException(iae);
        }
    }

    protected boolean processRead(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
        if (this.fill(this.header, rc, buffer)) {
            LOG.debug("Header not full, leaving.");
            return true;
        }
        if (this.parts == null) {
            this.createOtherStructures();
        }
        for (int i = 0; i < 8; ++i) {
            if (i != 0 && this.parts[i - 1].hasRemaining() || !this.fill(this.parts[i], rc, buffer)) continue;
            return true;
        }
        return false;
    }

    private boolean fill(ByteBuffer current, ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
        int read = BufferUtils.readAll(buffer, rc, current);
        LOG.debug("Filling current.  Left: " + current.remaining());
        if (current.hasRemaining()) {
            if (read == -1) {
                throw new IOException("EOF");
            }
            return true;
        }
        return false;
    }

    private void createOtherStructures() throws DIMEException {
        try {
            DIMERecord.validateFirstBytes(this.header.get(0), this.header.get(1));
        }
        catch (IllegalArgumentException iae) {
            throw new DIMEException(iae);
        }
        byte[] headerArr = this.header.array();
        int optionsLength = ByteUtils.beb2int(headerArr, 2, 2);
        int idLength = ByteUtils.beb2int(headerArr, 4, 2);
        int typeLength = ByteUtils.beb2int(headerArr, 6, 2);
        int dataLength = ByteUtils.beb2int(headerArr, 8, 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating dime record.  optionsLength: " + optionsLength + ", idLength: " + idLength + ", typeLength: " + typeLength + ", dataLength: " + dataLength);
        }
        if (dataLength < 0) {
            throw new DIMEException("data too big.");
        }
        this.parts = new ByteBuffer[8];
        this.parts[0] = this.createBuffer(optionsLength);
        this.parts[1] = this.createBuffer(DIMERecord.calculatePaddingLength(optionsLength));
        this.parts[2] = this.createBuffer(idLength);
        this.parts[3] = this.createBuffer(DIMERecord.calculatePaddingLength(idLength));
        this.parts[4] = this.createBuffer(typeLength);
        this.parts[5] = this.createBuffer(DIMERecord.calculatePaddingLength(typeLength));
        this.parts[6] = this.createBuffer(dataLength);
        this.parts[7] = this.createBuffer(DIMERecord.calculatePaddingLength(dataLength));
    }

    private ByteBuffer createBuffer(int length) {
        if (length == 0) {
            return BufferUtils.getEmptyBuffer();
        }
        return ByteBuffer.allocate(length);
    }

    public long getAmountProcessed() {
        long read = this.header.position();
        if (this.parts != null) {
            for (int i = 0; i < 8; ++i) {
                read += (long)this.parts[i].position();
            }
        }
        return read;
    }
}

