/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.SourceRanker;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceRanker
implements SourceRanker {
    protected MeshHandler meshHandler;

    @Override
    public boolean addToPool(Collection<? extends RemoteFileDesc> hosts) {
        boolean ret = false;
        for (RemoteFileDesc remoteFileDesc : hosts) {
            if (!this.addToPool(remoteFileDesc)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public abstract boolean addToPool(RemoteFileDesc var1);

    @Override
    public abstract boolean hasMore();

    @Override
    public abstract RemoteFileDesc getBest();

    @Override
    public abstract Collection<RemoteFileDesc> getShareableHosts();

    @Override
    public abstract int getNumKnownHosts();

    @Override
    public synchronized boolean hasNonBusy() {
        return this.getNumKnownHosts() > this.getNumBusyHosts();
    }

    @Override
    public synchronized int getNumBusyHosts() {
        int ret = 0;
        long now = System.currentTimeMillis();
        for (RemoteFileDesc rfd : this.getPotentiallyBusyHosts()) {
            if (!rfd.isBusy(now)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public synchronized int calculateWaitTime() {
        if (!this.hasMore()) {
            return 0;
        }
        int waitTime = Integer.MAX_VALUE;
        long now = System.currentTimeMillis();
        for (RemoteFileDesc rfd : this.getPotentiallyBusyHosts()) {
            if (!rfd.isBusy(now)) continue;
            waitTime = Math.min(waitTime, rfd.getWaitTime(now));
        }
        return waitTime * 1000;
    }

    protected abstract Collection<RemoteFileDesc> getPotentiallyBusyHosts();

    @Override
    public synchronized void stop() {
        this.clearState();
        this.meshHandler = null;
    }

    protected void clearState() {
    }

    @Override
    public synchronized void setMeshHandler(MeshHandler handler) {
        this.meshHandler = handler;
    }

    @Override
    public synchronized MeshHandler getMeshHandler() {
        return this.meshHandler;
    }
}

