/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.DownloadStatsTracker;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.VerifyingFile;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.inspection.InspectionPoint;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class DownloadWorkerFactoryImpl
implements DownloadWorkerFactory {
    private final HTTPDownloaderFactory httpDownloaderFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final ScheduledExecutorService nioExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final SocketsManager socketsManager;
    @InspectionPoint(value="download connection stats")
    private final DownloadStatsTracker statsTracker;

    @Inject
    public DownloadWorkerFactoryImpl(HTTPDownloaderFactory httpDownloaderFactory, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="nioExecutor") ScheduledExecutorService nioExecutor, Provider<PushDownloadManager> pushDownloadManager, SocketsManager socketsManager, DownloadStatsTracker statsTracker) {
        this.httpDownloaderFactory = httpDownloaderFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.nioExecutor = nioExecutor;
        this.pushDownloadManager = pushDownloadManager;
        this.socketsManager = socketsManager;
        this.statsTracker = statsTracker;
    }

    @Override
    public DownloadWorker create(DownloadWorkerSupport manager, RemoteFileDesc rfd, VerifyingFile vf) {
        return new DownloadWorker(manager, rfd, vf, this.httpDownloaderFactory, this.backgroundExecutor, this.nioExecutor, this.pushDownloadManager, this.socketsManager, this.statsTracker);
    }
}

