/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Mutable;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.LWSIntegrationServices;
import com.limegroup.gnutella.downloader.LWSIntegrationServicesDelegate;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.Visitor;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.lws.server.LWSUtil;
import com.limegroup.gnutella.settings.LWSSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.Tagged;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;

@Singleton
public final class LWSIntegrationServicesImpl
implements LWSIntegrationServices {
    private static final Log LOG = LogFactory.getLog(LWSIntegrationServicesImpl.class);
    private static final int CALL_GET_DOWNLOAD_PROGRESS_PERIOD_MILLIS = 300000;
    private static final int CHECK_EVER_ACTIVE_DOWNLOADER_IDS_2_DOWNLOADERS_PERIOD_MILLIS = 10000;
    private long lastTimeWeCalledGetDownloadProgress = -1L;
    private final LWSManager lwsManager;
    private final DownloadServices downloadServices;
    private final LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final ScheduledExecutorService scheduler;
    private final Map<String, String> downloaderIDs2progressBarIDs = new HashMap<String, String>();
    private final Map<String, DownloaderInterface> everActiveDownloaderIDs2Downloaders = new HashMap<String, DownloaderInterface>();
    private String downloadPrefix;

    @Inject
    public LWSIntegrationServicesImpl(LWSManager lwsManager, DownloadServices downloadServices, LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate, RemoteFileDescFactory remoteFileDescFactory, @Named(value="backgroundExecutor") ScheduledExecutorService scheduler) {
        this(lwsManager, downloadServices, lwsIntegrationServicesDelegate, remoteFileDescFactory, scheduler, LWSSettings.LWS_DOWNLOAD_PREFIX.getValue());
    }

    LWSIntegrationServicesImpl(LWSManager lwsManager, DownloadServices downloadServices, LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate, RemoteFileDescFactory remoteFileDescFactory, ScheduledExecutorService scheduler, String downloadPrefix) {
        this.lwsManager = lwsManager;
        this.downloadServices = downloadServices;
        this.lwsIntegrationServicesDelegate = lwsIntegrationServicesDelegate;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.scheduler = scheduler;
        this.downloadPrefix = downloadPrefix;
        this.scheduler.schedule(new Runnable(){

            public void run() {
                long now = System.currentTimeMillis();
                if (LWSIntegrationServicesImpl.this.lastTimeWeCalledGetDownloadProgress != -1L && now - LWSIntegrationServicesImpl.this.lastTimeWeCalledGetDownloadProgress < 300000L) {
                    return;
                }
                LWSIntegrationServicesImpl.this.getDownloadProgress();
            }
        }, 300000L, TimeUnit.MILLISECONDS);
        this.scheduler.schedule(new Runnable(){

            public void run() {
                LWSIntegrationServicesImpl.this.checkEverActiveDownloaderIDs2Downloaders();
            }
        }, 10000L, TimeUnit.MILLISECONDS);
    }

    public void setDownloadPrefix(String downloadPrefix) {
        this.downloadPrefix = downloadPrefix;
    }

    public RemoteFileDesc createRemoteFileDescriptor(String fileName, String urlString, long length) throws IOException, URISyntaxException, HttpException, InterruptedException {
        String baseDir = "http://" + this.downloadPrefix;
        if (fileName == null) {
            fileName = this.fileNameFromURL(urlString);
        }
        String urlStr = baseDir + urlString;
        URL url = new URL(urlStr);
        RemoteFileDesc rfd = this.remoteFileDescFactory.createUrlRemoteFileDesc(url, fileName, null, length);
        rfd.setHTTP11(false);
        return rfd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downloader createDownloader(RemoteFileDesc rfd, File saveDir) throws SaveLocationException {
        String fileName = rfd.getFileName();
        final Mutable<Downloader> downloader = new Mutable<Downloader>();
        LWSIntegrationServicesDelegate lWSIntegrationServicesDelegate = this.lwsIntegrationServicesDelegate;
        synchronized (lWSIntegrationServicesDelegate) {
            final File saveFile = new File(saveDir, fileName);
            this.lwsIntegrationServicesDelegate.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    if (d.conflictsSaveFile(saveFile)) {
                        downloader.set(d);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (downloader.get() == null) {
            downloader.set(this.downloadServices.downloadFromStore(rfd, true, saveDir, fileName));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Have downloader " + downloader.toString());
        }
        return (Downloader)downloader.get();
    }

    public void init() {
        this.lwsManager.registerHandler("GetDownloadProgress", new LWSManagerCommandResponseHandlerWithCallback("GetDownloadProgress"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return LWSIntegrationServicesImpl.this.getDownloadProgress();
            }
        });
        this.lwsManager.registerHandler("Download", new LWSManagerCommandResponseHandlerWithCallback("Download"){

            @Override
            protected String handleRest(Map<String, String> args) {
                Tagged<String> idOfTheProgressBarString;
                Tagged<String> urlString = LWSUtil.getArg(args, "url", "downloading");
                if (!urlString.isValid()) {
                    return urlString.getValue();
                }
                Tagged<String> fileString = LWSUtil.getArg(args, "file", "downloading");
                if (!fileString.isValid()) {
                    LOG.info("no file name given to downloader...");
                }
                if (!(idOfTheProgressBarString = LWSUtil.getArg(args, "id", "downloading")).isValid()) {
                    return idOfTheProgressBarString.getValue();
                }
                Tagged<String> lengthString = LWSUtil.getArg(args, "length", "downloading");
                long length = -1L;
                if (lengthString.isValid()) {
                    try {
                        length = Long.parseLong(lengthString.getValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                try {
                    File saveDir = SharingSettings.getSaveLWSDirectory();
                    RemoteFileDesc rfd = LWSIntegrationServicesImpl.this.createRemoteFileDescriptor(fileString.getValue(), urlString.getValue(), length);
                    Downloader theDownloader = LWSIntegrationServicesImpl.this.createDownloader(rfd, saveDir);
                    long idOfTheDownloader = System.identityHashCode(theDownloader);
                    LWSIntegrationServicesImpl.this.downloaderIDs2progressBarIDs.put(String.valueOf(idOfTheDownloader), idOfTheProgressBarString.getValue());
                    return idOfTheDownloader + " " + idOfTheProgressBarString.getValue();
                }
                catch (IOException e) {
                }
                catch (HttpException e) {
                }
                catch (InterruptedException e) {
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                return "invalid.download";
            }
        });
        this.lwsManager.registerHandler("PauseDownload", new LWSManagerCommandResponseForDownloading("PauseDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.pause();
            }
        });
        this.lwsManager.registerHandler("StopDownload", new LWSManagerCommandResponseForDownloading("StopDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.stop();
            }
        });
        this.lwsManager.registerHandler("ResumeDownload", new LWSManagerCommandResponseForDownloading("ResumeDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.resume();
            }
        });
        this.lwsManager.registerHandler("PauseAllDownloads", new LWSManagerCommandResponseForDownloadingAll("PauseAllDownloads", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.pause();
            }
        });
        this.lwsManager.registerHandler("StopAllDownloads", new LWSManagerCommandResponseForDownloadingAll("StopAllDownloads", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.stop();
            }
        });
        this.lwsManager.registerHandler("ResumeAllDownloads", new LWSManagerCommandResponseForDownloadingAll("ResumeAllDownloads", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.resume();
            }
        });
        this.lwsManager.registerHandler("GetInfo", new LWSManagerCommandResponseHandlerWithCallback("GetInfo"){

            private void add(StringBuffer b, String name, Object value) {
                b.append(name);
                b.append('=');
                b.append(value);
                b.append('\t');
            }

            @Override
            protected String handleRest(Map<String, String> args) {
                StringBuffer res = new StringBuffer();
                this.add(res, "version", LimeWireUtils.getLimeWireVersion());
                this.add(res, "major.version.number", LimeWireUtils.getMajorVersionNumber());
                this.add(res, "minor.version.number", LimeWireUtils.getMinorVersionNumber());
                this.add(res, "vendor", LimeWireUtils.getVendor());
                this.add(res, "service.version.number", LimeWireUtils.getServiceVersionNumber());
                this.add(res, "is.alpha.release", LimeWireUtils.isAlphaRelease());
                this.add(res, "is.beta.release", LimeWireUtils.isBetaRelease());
                this.add(res, "is.pro", LimeWireUtils.isPro());
                this.add(res, "is.testing.version", LimeWireUtils.isTestingVersion());
                return res.toString();
            }
        });
    }

    private static String downloadStatusToString(Downloader.DownloadStatus s) {
        if (s == Downloader.DownloadStatus.INITIALIZING) {
            return "Initializing";
        }
        if (s == Downloader.DownloadStatus.QUEUED) {
            return "Queued";
        }
        if (s == Downloader.DownloadStatus.CONNECTING) {
            return "Connecting";
        }
        if (s == Downloader.DownloadStatus.DOWNLOADING) {
            return "Downloading";
        }
        if (s == Downloader.DownloadStatus.BUSY) {
            return "Busy";
        }
        if (s == Downloader.DownloadStatus.COMPLETE) {
            return "Complete";
        }
        if (s == Downloader.DownloadStatus.ABORTED) {
            return "Aborted";
        }
        if (s == Downloader.DownloadStatus.GAVE_UP) {
            return "Gave up";
        }
        if (s == Downloader.DownloadStatus.DISK_PROBLEM) {
            return "Disk problem";
        }
        if (s == Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS) {
            return "Waiting for gnet results";
        }
        if (s == Downloader.DownloadStatus.CORRUPT_FILE) {
            return "Corrupt_FILE";
        }
        if (s == Downloader.DownloadStatus.REMOTE_QUEUED) {
            return "Remote_QUEUED";
        }
        if (s == Downloader.DownloadStatus.HASHING) {
            return "Hashing";
        }
        if (s == Downloader.DownloadStatus.SAVING) {
            return "Saving";
        }
        if (s == Downloader.DownloadStatus.WAITING_FOR_USER) {
            return "Waiting for user";
        }
        if (s == Downloader.DownloadStatus.WAITING_FOR_CONNECTIONS) {
            return "Waiting for connections";
        }
        if (s == Downloader.DownloadStatus.ITERATIVE_GUESSING) {
            return "Iterative guessing";
        }
        if (s == Downloader.DownloadStatus.QUERYING_DHT) {
            return "Querying DHT";
        }
        if (s == Downloader.DownloadStatus.IDENTIFY_CORRUPTION) {
            return "Identify corruption";
        }
        if (s == Downloader.DownloadStatus.RECOVERY_FAILED) {
            return "Recovery failed";
        }
        if (s == Downloader.DownloadStatus.PAUSED) {
            return "Paused";
        }
        if (s == Downloader.DownloadStatus.INVALID) {
            return "Invalid";
        }
        if (s == Downloader.DownloadStatus.RESUMING) {
            return "Resuming";
        }
        if (s == Downloader.DownloadStatus.FETCHING) {
            return "Fetching";
        }
        return null;
    }

    private String fileNameFromURL(String urlString) {
        int ilast = urlString.lastIndexOf("/");
        if (ilast == -1) {
            ilast = urlString.lastIndexOf("\\");
        }
        return urlString.substring(ilast + 1);
    }

    private synchronized String getDownloadProgress() {
        this.lastTimeWeCalledGetDownloadProgress = System.currentTimeMillis();
        final StringBuffer res = new StringBuffer();
        final HashSet activeDownloaderIDS = new HashSet();
        this.lwsIntegrationServicesDelegate.visitDownloads(new Visitor<CoreDownloader>(){

            @Override
            public boolean visit(CoreDownloader d) {
                if (d == null) {
                    return true;
                }
                if (!(d instanceof StoreDownloader)) {
                    return true;
                }
                String id = String.valueOf(System.identityHashCode(d));
                if (!LWSIntegrationServicesImpl.this.everActiveDownloaderIDs2Downloaders.containsKey(id)) {
                    LWSIntegrationServicesImpl.this.everActiveDownloaderIDs2Downloaders.put(id, new HeavyWeightDownloaderInterface(d));
                }
                activeDownloaderIDS.add(id);
                LWSIntegrationServicesImpl.this.recordProgress(d, res, id);
                return true;
            }
        });
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (String downloaderID : this.everActiveDownloaderIDs2Downloaders.keySet()) {
            DownloaderInterface d = this.everActiveDownloaderIDs2Downloaders.get(downloaderID);
            if (activeDownloaderIDS.contains(downloaderID)) continue;
            this.recordProgress(d, res, downloaderID);
            idsToRemove.add(downloaderID);
        }
        for (String idToRemove : idsToRemove) {
            this.everActiveDownloaderIDs2Downloaders.remove(idToRemove);
            this.downloaderIDs2progressBarIDs.remove(idToRemove);
        }
        return res.toString();
    }

    private void recordProgress(DownloaderInterface d, StringBuffer res, String id) {
        this.recordProgress(res, d.getAmountRead(), d.getContentLength(), d.getState(), id);
    }

    private void recordProgress(CoreDownloader d, StringBuffer res, String id) {
        this.recordProgress(res, d.getAmountRead(), d.getContentLength(), d.getState(), id);
    }

    private void recordProgress(StringBuffer res, long read, long total, Downloader.DownloadStatus state, String id) {
        String ratio = String.valueOf((float)read / (float)total);
        String status = LWSIntegrationServicesImpl.downloadStatusToString(state);
        String progressBarID = this.downloaderIDs2progressBarIDs.get(id);
        res.append(id);
        res.append(" ");
        res.append(progressBarID);
        res.append(" ");
        res.append(ratio);
        res.append(":");
        res.append(status);
        res.append("|");
    }

    synchronized void checkEverActiveDownloaderIDs2Downloaders() {
        DownloaderInterface d;
        ArrayList<String> idsToChange = new ArrayList<String>();
        for (String downloaderID : this.everActiveDownloaderIDs2Downloaders.keySet()) {
            d = this.everActiveDownloaderIDs2Downloaders.get(downloaderID);
            if (!d.isCompleted() || !d.isHeavyWeight()) continue;
            idsToChange.add(downloaderID);
        }
        for (String id : idsToChange) {
            d = this.everActiveDownloaderIDs2Downloaders.get(id);
            this.everActiveDownloaderIDs2Downloaders.remove(id);
            this.everActiveDownloaderIDs2Downloaders.put(id, new LightWeightDownloaderInterface(d));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LWSManagerCommandResponseForDownloadingAll
    extends LWSManagerCommandResponseHandlerWithCallback {
        private final LWSIntegrationServicesDelegate del;

        LWSManagerCommandResponseForDownloadingAll(String name, LWSIntegrationServicesDelegate del) {
            super(name);
            this.del = del;
        }

        protected abstract void takeAction(Downloader var1);

        @Override
        protected final String handleRest(Map<String, String> args) {
            final StringBuffer res = new StringBuffer();
            final ArrayList downloadersToAffect = new ArrayList();
            this.del.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    String hash = String.valueOf(System.identityHashCode(d));
                    for (String id : LWSIntegrationServicesImpl.this.downloaderIDs2progressBarIDs.keySet()) {
                        if (!hash.equals(id)) continue;
                        downloadersToAffect.add(d);
                        if (res.length() > 0) {
                            res.append(" ");
                        }
                        res.append(id);
                        break;
                    }
                    return true;
                }
            });
            for (int i = 0; i < downloadersToAffect.size(); ++i) {
                this.takeAction((Downloader)downloadersToAffect.get(i));
            }
            return res.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LWSManagerCommandResponseForDownloading
    extends LWSManagerCommandResponseHandlerWithCallback {
        private final LWSIntegrationServicesDelegate del;

        LWSManagerCommandResponseForDownloading(String name, LWSIntegrationServicesDelegate del) {
            super(name);
            this.del = del;
        }

        protected abstract void takeAction(Downloader var1);

        @Override
        protected final String handleRest(Map<String, String> args) {
            Tagged<String> idOfTheDownloader = LWSUtil.getArg(args, "id", "downloading");
            if (!idOfTheDownloader.isValid()) {
                return idOfTheDownloader.getValue();
            }
            final String id = idOfTheDownloader.getValue();
            final Mutable<String> res = new Mutable<String>("OK");
            this.del.visitDownloads(new Visitor<CoreDownloader>(){

                @Override
                public boolean visit(CoreDownloader d) {
                    String hash = String.valueOf(System.identityHashCode(d));
                    if (hash.equals(id)) {
                        LWSManagerCommandResponseForDownloading.this.takeAction(d);
                        res.set(hash);
                        return false;
                    }
                    return true;
                }
            });
            return res.get();
        }
    }

    static final class LightWeightDownloaderInterface
    implements DownloaderInterface {
        private final long amountRead;
        private final long contentLength;
        private final Downloader.DownloadStatus state;

        LightWeightDownloaderInterface(DownloaderInterface d) {
            this.amountRead = d.getAmountRead();
            this.contentLength = d.getContentLength();
            this.state = d.getState();
        }

        public boolean isHeavyWeight() {
            return false;
        }

        public long getAmountRead() {
            return this.amountRead;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public Downloader.DownloadStatus getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return true;
        }

        public void release() {
        }
    }

    static final class HeavyWeightDownloaderInterface
    implements DownloaderInterface {
        private Downloader d;

        HeavyWeightDownloaderInterface(Downloader d) {
            this.d = d;
        }

        public boolean isHeavyWeight() {
            return true;
        }

        public long getAmountRead() {
            return this.d.getAmountRead();
        }

        public long getContentLength() {
            return this.d.getContentLength();
        }

        public Downloader.DownloadStatus getState() {
            return this.d.getState();
        }

        public boolean isCompleted() {
            return this.d.isCompleted();
        }

        public void release() {
            this.d = null;
        }
    }

    private static interface DownloaderInterface {
        public long getAmountRead();

        public long getContentLength();

        public Downloader.DownloadStatus getState();

        public boolean isCompleted();

        public boolean isHeavyWeight();

        public void release();
    }
}

