/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyRanker
extends AbstractSourceRanker {
    private static final Log LOG = LogFactory.getLog(LegacyRanker.class);
    private final Set<RemoteFileDesc> rfds = new HashSet<RemoteFileDesc>();

    @Override
    public synchronized boolean addToPool(RemoteFileDesc host) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding host " + host + " to be ranked");
        }
        return this.rfds.add(host);
    }

    @Override
    public synchronized RemoteFileDesc getBest() {
        if (!this.hasMore()) {
            return null;
        }
        RemoteFileDesc ret = LegacyRanker.getBest(this.rfds.iterator());
        boolean removed = this.rfds.remove(ret);
        assert (removed) : "unable to remove RFD.";
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best we came with is " + ret);
        }
        return ret;
    }

    static RemoteFileDesc getBest(Iterator<RemoteFileDesc> iter) {
        RemoteFileDesc ret = iter.next();
        long now = System.currentTimeMillis();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = iter.next();
            if (rfd.isBusy(now)) continue;
            if (ret.isBusy(now)) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        return ret;
    }

    @Override
    public boolean hasMore() {
        return !this.rfds.isEmpty();
    }

    @Override
    public Collection<RemoteFileDesc> getShareableHosts() {
        return this.rfds;
    }

    @Override
    protected Collection<RemoteFileDesc> getPotentiallyBusyHosts() {
        return this.rfds;
    }

    @Override
    public int getNumKnownHosts() {
        return this.rfds.size();
    }
}

