/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.DualIterator;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingRanker
extends AbstractSourceRanker
implements MessageListener,
Cancellable {
    private static final Log LOG = LogFactory.getLog(PingRanker.class);
    private static final Comparator<RemoteFileDesc> RFD_COMPARATOR = new RFDComparator();
    private static final Comparator<RemoteFileDesc> ALT_DEPRIORITIZER = new RFDAltDeprioritizer();
    private Set<RemoteFileDesc> newHosts;
    private TreeMap<IpPort, RemoteFileDesc> pingedHosts;
    private Set<RemoteFileDesc> testedLocations;
    private TreeSet<RemoteFileDesc> verifiedHosts;
    private URN sha1;
    private GUID myGUID;
    private boolean running;
    private long lastPingTime;
    private final NetworkManager networkManager;
    private final UDPPinger udpPinger;
    private final MessageRouter messageRouter;
    private final RemoteFileDescFactory remoteFileDescFactory;

    protected PingRanker(NetworkManager networkManager, UDPPinger udpPinger, MessageRouter messageRouter, RemoteFileDescFactory remoteFileDescFactory) {
        this.networkManager = networkManager;
        this.udpPinger = udpPinger;
        this.messageRouter = messageRouter;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.pingedHosts = new TreeMap(IpPort.COMPARATOR);
        this.testedLocations = new HashSet<RemoteFileDesc>();
        this.newHosts = new HashSet<RemoteFileDesc>();
        this.verifiedHosts = new TreeSet<RemoteFileDesc>(RFD_COMPARATOR);
    }

    @Override
    public synchronized boolean addToPool(Collection<? extends RemoteFileDesc> c) {
        ArrayList<? extends RemoteFileDesc> l = c instanceof List ? (ArrayList<? extends RemoteFileDesc>)c : new ArrayList<RemoteFileDesc>(c);
        Collections.sort(l, ALT_DEPRIORITIZER);
        return this.addInternal(l);
    }

    private boolean addInternal(Collection<? extends RemoteFileDesc> c) {
        boolean ret = false;
        for (RemoteFileDesc remoteFileDesc : c) {
            if (!this.addInternal(remoteFileDesc)) continue;
            ret = true;
        }
        this.pingNewHosts();
        return ret;
    }

    @Override
    public synchronized boolean addToPool(RemoteFileDesc host) {
        boolean ret = this.addInternal(host);
        this.pingNewHosts();
        return ret;
    }

    private boolean addInternal(RemoteFileDesc host) {
        if (this.sha1 == null) {
            if (host.getSHA1Urn() != null) {
                this.sha1 = host.getSHA1Urn();
            } else {
                return this.testedLocations.add(host);
            }
        }
        if (this.running && this.knowsAboutHost(host)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding new host " + host + " " + host.getPushAddr());
        }
        boolean ret = false;
        ret = host.isReplyToMulticast() ? this.verifiedHosts.add(host) : this.newHosts.add(host);
        ret |= !this.running;
        if (this.myGUID == null && this.meshHandler != null) {
            this.myGUID = new GUID(GUID.makeGuid());
            this.messageRouter.registerMessageListener(this.myGUID.bytes(), this);
        }
        return ret;
    }

    private boolean knowsAboutHost(RemoteFileDesc host) {
        return this.newHosts.contains(host) || this.verifiedHosts.contains(host) || this.testedLocations.contains(host);
    }

    @Override
    public synchronized RemoteFileDesc getBest() throws NoSuchElementException {
        RemoteFileDesc ret;
        if (!this.hasMore()) {
            return null;
        }
        if (!this.verifiedHosts.isEmpty()) {
            LOG.debug("getting a verified host");
            ret = this.verifiedHosts.first();
            this.verifiedHosts.remove(ret);
        } else {
            LOG.debug("getting a non-verified host");
            DualIterator<RemoteFileDesc> dual = new DualIterator<RemoteFileDesc>(this.testedLocations.iterator(), this.newHosts.iterator());
            ret = LegacyRanker.getBest(dual);
            this.newHosts.remove(ret);
            this.testedLocations.remove(ret);
            if (ret.needsPush()) {
                for (IpPort ipPort : ret.getPushProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            } else {
                this.pingedHosts.remove(ret);
            }
        }
        this.pingNewHosts();
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best host we came up with is " + ret + " " + ret.getPushAddr());
        }
        return ret;
    }

    private void pingNewHosts() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.hasNonBusy()) {
            return;
        }
        if (this.sha1 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastPingTime < (long)DownloadSettings.WORKER_INTERVAL.getValue()) {
            return;
        }
        HeadPing ping = new HeadPing(this.myGUID, this.sha1, this.getPingFlags());
        int batch = DownloadSettings.PING_BATCH.getValue();
        ArrayList<RemoteFileDesc> toSend = new ArrayList<RemoteFileDesc>(batch);
        int sent = 0;
        Iterator<RemoteFileDesc> iter = this.newHosts.iterator();
        while (iter.hasNext() && sent < batch) {
            RemoteFileDesc rfd = iter.next();
            if (rfd.isBusy(now)) continue;
            iter.remove();
            if (rfd.needsPush()) {
                if (rfd.getPushProxies().size() > 0 && rfd.getSHA1Urn() != null) {
                    this.pingProxies(rfd);
                }
            } else {
                this.pingedHosts.put(rfd, rfd);
                toSend.add(rfd);
            }
            this.testedLocations.add(rfd);
            ++sent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nverified hosts " + this.verifiedHosts.size() + "\npingedHosts " + this.pingedHosts.values().size() + "\nnewHosts " + this.newHosts.size() + "\npinging hosts: " + sent);
        }
        this.udpPinger.rank(toSend, null, this, ping);
        this.lastPingTime = now;
    }

    @Override
    protected Collection<RemoteFileDesc> getPotentiallyBusyHosts() {
        return this.newHosts;
    }

    private void pingProxies(RemoteFileDesc rfd) {
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT() && rfd.supportsFWTransfer()) {
            HeadPing pushPing = new HeadPing(this.myGUID, rfd.getSHA1Urn(), new GUID(rfd.getPushAddr().getClientGUID()), this.getPingFlags());
            for (IpPort ipPort : rfd.getPushProxies()) {
                this.pingedHosts.put(ipPort, rfd);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("pinging push location " + rfd.getPushAddr());
            }
            this.udpPinger.rank(rfd.getPushProxies(), null, this, pushPing);
        }
    }

    private int getPingFlags() {
        int flags = 3;
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT()) {
            flags |= 4;
        }
        return flags;
    }

    @Override
    public synchronized boolean hasMore() {
        return !this.verifiedHosts.isEmpty() || !this.newHosts.isEmpty() || !this.testedLocations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(Message m, ReplyHandler handler) {
        MeshHandler mesh;
        RemoteFileDesc rfd;
        Set<RemoteFileDesc> alts = null;
        PingRanker pingRanker = this;
        synchronized (pingRanker) {
            if (!this.running) {
                return;
            }
            if (!(m instanceof HeadPong)) {
                return;
            }
            HeadPong pong = (HeadPong)m;
            for (PushEndpoint pushEndpoint : pong.getPushLocs()) {
                pushEndpoint.updateProxies(true);
            }
            if (!this.pingedHosts.containsKey(handler)) {
                return;
            }
            rfd = this.pingedHosts.remove(handler);
            this.testedLocations.remove(rfd);
            if (LOG.isDebugEnabled()) {
                LOG.debug("received a pong " + pong + " from " + handler + " for rfd " + rfd + " with PE " + rfd.getPushAddr());
            }
            if (!pong.hasFile() && pong.isRoutingBroken() && rfd.needsPush()) {
                return;
            }
            if (pong.isFirewalled()) {
                for (IpPort ipPort : rfd.getPushProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            }
            mesh = this.meshHandler;
            if (pong.hasFile()) {
                pong.updateRFD(rfd);
                if (rfd.isBusy()) {
                    this.newHosts.add(rfd);
                } else {
                    this.verifiedHosts.add(rfd);
                }
                alts = pong.getAllLocsRFD(rfd, this.remoteFileDescFactory);
            }
        }
        if (alts == null) {
            mesh.informMesh(rfd, false);
        } else {
            mesh.addPossibleSources(alts);
        }
    }

    @Override
    public synchronized void registered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker registered with guid " + new GUID(guid).toHexString());
        }
        this.running = true;
    }

    @Override
    public synchronized void unregistered(byte[] guid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker unregistered with guid " + new GUID(guid).toHexString());
        }
        this.running = false;
        this.newHosts.addAll(this.verifiedHosts);
        this.newHosts.addAll(this.testedLocations);
        this.verifiedHosts.clear();
        this.pingedHosts.clear();
        this.testedLocations.clear();
        this.lastPingTime = 0L;
    }

    @Override
    public synchronized boolean isCancelled() {
        return !this.running || this.verifiedHosts.size() >= DownloadSettings.MAX_VERIFIED_HOSTS.getValue();
    }

    @Override
    protected synchronized void clearState() {
        if (this.myGUID != null) {
            this.messageRouter.unregisterMessageListener(this.myGUID.bytes(), this);
            this.myGUID = null;
        }
    }

    @Override
    public synchronized Collection<RemoteFileDesc> getShareableHosts() {
        ArrayList<RemoteFileDesc> ret = new ArrayList<RemoteFileDesc>(this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size());
        ret.addAll(this.verifiedHosts);
        ret.addAll(this.newHosts);
        ret.addAll(this.testedLocations);
        return ret;
    }

    @Override
    public synchronized int getNumKnownHosts() {
        return this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFDAltDeprioritizer
    implements Comparator<RemoteFileDesc> {
        private RFDAltDeprioritizer() {
        }

        @Override
        public int compare(RemoteFileDesc rfd1, RemoteFileDesc rfd2) {
            if (rfd1.isFromAlternateLocation() != rfd2.isFromAlternateLocation()) {
                if (rfd1.isFromAlternateLocation()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFDComparator
    implements Comparator<RemoteFileDesc> {
        private RFDComparator() {
        }

        @Override
        public int compare(RemoteFileDesc pongA, RemoteFileDesc pongB) {
            if (pongA.isReplyToMulticast() != pongB.isReplyToMulticast()) {
                if (pongA.isReplyToMulticast()) {
                    return -1;
                }
                return 1;
            }
            if (pongA.getQueueStatus() > pongB.getQueueStatus()) {
                return 1;
            }
            if (pongA.getQueueStatus() < pongB.getQueueStatus()) {
                return -1;
            }
            if (pongA.needsPush() != pongB.needsPush()) {
                if (pongA.needsPush()) {
                    return -1;
                }
                return 1;
            }
            if (pongA.isPartialSource() != pongB.isPartialSource()) {
                if (pongA.isPartialSource()) {
                    return -1;
                }
                return 1;
            }
            return pongA.hashCode() - pongB.hashCode();
        }
    }
}

