/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.BiasedRandomDownloadStrategy;
import com.limegroup.gnutella.downloader.RandomDownloadStrategy;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.settings.DownloadSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectionStrategyFactory {
    private static final Log LOG = LogFactory.getLog(SelectionStrategyFactory.class);

    public static SelectionStrategy getStrategyFor(String extension, long fileSize) {
        if (extension != null && extension.length() > 0) {
            String[] previewableExtensions = DownloadSettings.PREVIEWABLE_EXTENSIONS.getValue();
            for (int i = previewableExtensions.length - 1; i >= 0; --i) {
                if (!previewableExtensions[i].equalsIgnoreCase(extension)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Extension (" + extension + ") is previewable.");
                }
                return new BiasedRandomDownloadStrategy(fileSize);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extension (" + extension + ") is not previewable.");
        }
        return new RandomDownloadStrategy(fileSize);
    }
}

