/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.settings.DownloadSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SourceRankerFactory {
    private final NetworkManager networkManager;
    private final Provider<UDPPinger> udpPingerFactory;
    private final Provider<MessageRouter> messageRouter;
    private final RemoteFileDescFactory remoteFileDescFactory;

    @Inject
    public SourceRankerFactory(NetworkManager networkManager, Provider<UDPPinger> udpPingerFactory, Provider<MessageRouter> messageRouter, RemoteFileDescFactory remoteFileDescFactory) {
        this.networkManager = networkManager;
        this.udpPingerFactory = udpPingerFactory;
        this.messageRouter = messageRouter;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    public SourceRanker getAppropriateRanker() {
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            return new PingRanker(this.networkManager, this.udpPingerFactory.get(), this.messageRouter.get(), this.remoteFileDescFactory);
        }
        return new LegacyRanker();
    }

    public SourceRanker getAppropriateRanker(SourceRanker original) {
        AbstractSourceRanker better;
        if (original == null) {
            return this.getAppropriateRanker();
        }
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            if (original instanceof PingRanker) {
                return original;
            }
            better = new PingRanker(this.networkManager, this.udpPingerFactory.get(), this.messageRouter.get(), this.remoteFileDescFactory);
        } else {
            if (original instanceof LegacyRanker) {
                return original;
            }
            better = new LegacyRanker();
        }
        better.setMeshHandler(original.getMeshHandler());
        better.addToPool(original.getShareableHosts());
        original.stop();
        return better;
    }
}

