/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.templates.StoreFileNameTemplateProcessor;
import com.limegroup.gnutella.templates.StoreSubDirectoryTemplateProcessor;
import com.limegroup.gnutella.templates.StoreTemplateProcessor;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreDownloaderImpl
extends ManagedDownloaderImpl
implements StoreDownloader {
    private final MetaDataFactory metaDataFactory;

    @Inject
    public StoreDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, MetaDataFactory metaDataFactory) {
        super(saveLocationManager, downloadManager, fileManager, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, savedFileManager, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider);
        this.metaDataFactory = metaDataFactory;
    }

    @Override
    public QueryRequest newRequery() throws CantResumeException {
        return null;
    }

    @Override
    public boolean allowAddition(RemoteFileDesc other) {
        return false;
    }

    @Override
    public boolean canSendRequeryNow() {
        return false;
    }

    @Override
    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1L) {
            super.initializeIncompleteFile();
        }
    }

    @Override
    public Endpoint getChatEnabledHost() {
        return null;
    }

    @Override
    public boolean hasChatEnabledHost() {
        return false;
    }

    @Override
    public RemoteFileDesc getBrowseEnabledHost() {
        return null;
    }

    @Override
    public boolean hasBrowseEnabledHost() {
        return false;
    }

    @Override
    public int getNumberOfAlternateLocations() {
        return 0;
    }

    @Override
    public int getNumberOfInvalidAlternateLocations() {
        return 0;
    }

    @Override
    protected File getSuggestedSaveLocation(File defaultSaveFile, File newDownloadFile) throws IOException {
        if (!newDownloadFile.getName().toLowerCase(Locale.US).endsWith("mp3")) {
            return defaultSaveFile;
        }
        AudioMetaData metaData = null;
        try {
            MetaReader reader = this.metaDataFactory.parse(newDownloadFile);
            metaData = (AudioMetaData)reader.getMetaData();
        }
        catch (IOException e) {
            return defaultSaveFile;
        }
        if (metaData == null) {
            return defaultSaveFile;
        }
        HashMap<String, String> subs = new HashMap<String, String>();
        if (!this.createSubstitutes(subs, metaData)) {
            return defaultSaveFile;
        }
        File realOutputDir = this.getLWSDirectory(SharingSettings.getSaveLWSDirectory(), subs);
        if (!FileUtils.setWriteable(realOutputDir)) {
            return defaultSaveFile;
        }
        return new File(realOutputDir, this.getLWSFileName(defaultSaveFile, subs));
    }

    private File getLWSDirectory(File directory, Map<String, String> subs) {
        String template = SharingSettings.getSubDirectoryLWSTemplate();
        if (template == null || template.length() == 0) {
            return directory;
        }
        File outDir = null;
        try {
            outDir = new StoreSubDirectoryTemplateProcessor().getOutputDirectory(template, subs, directory);
        }
        catch (StoreTemplateProcessor.IllegalTemplateException e) {
            return directory;
        }
        if (outDir == null) {
            return directory;
        }
        outDir.mkdirs();
        FileUtils.setWriteable(outDir);
        if (!(outDir.isDirectory() && outDir.canRead() && outDir.canWrite())) {
            return directory;
        }
        return outDir;
    }

    private String getLWSFileName(File defaultSaveFile, Map<String, String> subs) {
        String currentFileName = defaultSaveFile.getName();
        String template = SharingSettings.getFileNameLWSTemplate();
        try {
            currentFileName = new StoreFileNameTemplateProcessor().getFileName(template, subs);
            if (currentFileName == null || currentFileName.length() == 0) {
                return defaultSaveFile.getName();
            }
        }
        catch (StoreTemplateProcessor.IllegalTemplateException e) {
            return defaultSaveFile.getName();
        }
        String ext = FileUtils.getFileExtension(defaultSaveFile);
        if (ext != null) {
            return currentFileName + "." + ext;
        }
        return defaultSaveFile.getName();
    }

    private boolean createSubstitutes(Map<String, String> subs, AudioMetaData metaData) {
        String artist = metaData.getArtist();
        String album = metaData.getAlbum();
        String track = metaData.getTrack();
        String title = metaData.getTitle();
        if (artist == null || album == null || title == null || track == null) {
            return false;
        }
        artist = CommonUtils.santizeString(artist);
        album = CommonUtils.santizeString(album);
        track = StoreDownloaderImpl.sanitizeTrack(track);
        title = CommonUtils.santizeString(title);
        subs.put("artist", artist);
        subs.put("album", album);
        subs.put("title", title);
        subs.put("track", track);
        return true;
    }

    private static String sanitizeTrack(String track) {
        String[] subStrings = track.split("/");
        String trackNumber = subStrings[0].trim();
        if (trackNumber.length() == 1) {
            trackNumber = 0 + trackNumber;
        }
        return trackNumber;
    }

    @Override
    protected URN saveTreeHash(URN fileHash) {
        return null;
    }

    @Override
    protected void shareSavedFile(File saveFile) {
        this.fileManager.addFileIfShared(saveFile);
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.STORE;
    }

    @Override
    protected boolean shouldPublishIFD() {
        return false;
    }
}

