/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.limegroup.gnutella.downloader.ChunkDiskJob;
import com.limegroup.gnutella.downloader.DelayedWrite;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.downloader.SelectionStrategyFactory;
import com.limegroup.gnutella.tigertree.HashTree;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.Range;
import org.limewire.io.DiskException;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyingFile {
    static final Log LOG = LogFactory.getLog(VerifyingFile.class);
    static final float MAX_CORRUPTION = 0.9f;
    static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final int VERIFYABLE_CHUNK = 65536;
    private volatile RandomAccessFile fos;
    private volatile boolean isOpen;
    private final long completedSize;
    private long lostSize;
    private final IntervalSet verifiedBlocks;
    private IntervalSet leasedBlocks;
    private IntervalSet partialBlocks;
    private IntervalSet savedCorruptBlocks;
    private IntervalSet pendingBlocks;
    private SelectionStrategy blockChooser = null;
    private HashTree hashTree;
    private String expectedHashRoot;
    private boolean hashTreeRequested;
    private boolean discardBad = true;
    private IOException storedException;
    private long existingFileSize = -1L;
    private int chunksScheduledPerFile = 0;
    private MultiIterable<Range> allBlocksIterable = null;
    private final Provider<DiskController> diskController;

    VerifyingFile(long completedSize, Provider<DiskController> diskController) {
        this.completedSize = completedSize;
        this.verifiedBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
        this.pendingBlocks = new IntervalSet();
        this.partialBlocks = new IntervalSet();
        this.savedCorruptBlocks = new IntervalSet();
        this.diskController = diskController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws IOException {
        if (this.completedSize == -1L) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
            if (!parentFile.exists()) {
                throw new IOException("permission denied");
            }
            FileUtils.setWriteable(parentFile);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        SelectionStrategy myStrategy = SelectionStrategyFactory.getStrategyFor(FileUtils.getFileExtension(file), this.completedSize);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            this.storedException = null;
            this.blockChooser = myStrategy;
            this.isOpen = true;
        }
    }

    public synchronized void addInterval(Range interval) {
        this.partialBlocks.add(interval);
    }

    public void registerWriteCallback(WriteRequest request, WriteCallback callback) {
        request.startScheduling();
        if (this.writeBlockImpl(request)) {
            callback.writeScheduled();
        } else {
            this.diskController.get().addDelayedWrite(new VerifyingFileDelayedWrite(request, callback, this));
        }
    }

    public boolean writeBlock(WriteRequest request) {
        if (!this.validateState(request)) {
            return true;
        }
        request.startProcessing();
        this.updateState(request.in);
        boolean canWrite = this.diskController.get().canWriteNow();
        if (canWrite) {
            return this.writeBlockImpl(request);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBlockImpl(WriteRequest request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("trying to write block at offset " + request.currPos + " with size " + request.length);
        }
        if (!this.validateState(request)) {
            return true;
        }
        byte[] temp = this.diskController.get().getWriteChunk();
        if (temp == null) {
            return false;
        }
        request.setDone();
        assert (temp.length >= request.length) : "bad length: " + request.length + ", needed <= " + temp.length;
        System.arraycopy(request.buf, request.start, temp, 0, request.length);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            ++this.chunksScheduledPerFile;
        }
        this.diskController.get().addDiskJob(new ChunkHandler(temp, request.in));
        return true;
    }

    private synchronized void updateState(Range intvl) {
        assert (this.leasedBlocks.contains(intvl)) : "trying to write an interval " + intvl + " that wasn't leased.\n" + this.dumpState();
        assert (!(this.partialBlocks.contains(intvl) || this.savedCorruptBlocks.contains(intvl) || this.pendingBlocks.contains(intvl))) : "trying to write an interval " + intvl + " that was already written" + this.dumpState();
        this.leasedBlocks.delete(intvl);
        if (this.verifiedBlocks.containsAny(intvl)) {
            IntervalSet remaining = new IntervalSet();
            remaining.add(intvl);
            remaining.delete(this.verifiedBlocks);
            this.pendingBlocks.add(remaining);
        } else {
            this.pendingBlocks.add(intvl);
        }
    }

    private boolean validateState(WriteRequest request) {
        if (request.length == 0) {
            return false;
        }
        if (this.fos == null) {
            throw new IllegalStateException("no fos!");
        }
        return this.isOpen();
    }

    public void setScanForExistingBlocks(boolean scan, long length) throws IOException {
        if (scan && length != 0L) {
            if (length > this.completedSize) {
                throw new IOException("invalid completed size or length");
            }
            this.existingFileSize = length;
        } else {
            this.existingFileSize = -1L;
        }
    }

    public synchronized String dumpState() {
        return "verified:" + this.verifiedBlocks + "\npartial:" + this.partialBlocks + "\ndiscarded:" + this.savedCorruptBlocks + "\npending:" + this.pendingBlocks + "\nleased:" + this.leasedBlocks;
    }

    public Range leaseWhite() throws NoSuchElementException {
        return this.leaseWhiteHelper(null, this.completedSize);
    }

    public Range leaseWhite(long chunkSize) throws NoSuchElementException {
        return this.leaseWhiteHelper(null, chunkSize);
    }

    public Range leaseWhite(IntervalSet ranges) throws NoSuchElementException {
        return this.leaseWhiteHelper(ranges, 131072L);
    }

    public Range leaseWhite(IntervalSet ranges, long chunkSize) throws NoSuchElementException {
        return this.leaseWhiteHelper(ranges, chunkSize);
    }

    public synchronized void releaseBlock(Range in) {
        assert (this.leasedBlocks.contains(in)) : "trying to release an interval " + in + " that wasn't leased " + this.dumpState();
        if (LOG.isInfoEnabled()) {
            LOG.info("Releasing interval: " + in + " state " + this.dumpState());
        }
        this.leasedBlocks.delete(in);
    }

    public synchronized Iterable<Range> getVerifiedBlocks() {
        return this.verifiedBlocks;
    }

    public synchronized IntervalSet getVerifiedIntervalSet() {
        return this.verifiedBlocks;
    }

    public synchronized IntervalSet getPartialIntervalSet() {
        return this.partialBlocks;
    }

    public synchronized IntervalSet.ByteIntervals toBytes() {
        return this.verifiedBlocks.toBytes();
    }

    public String toString() {
        return this.dumpState();
    }

    public synchronized List<Range> getSerializableBlocks() {
        IntervalSet ret = new IntervalSet();
        for (Range next : new MultiIterable<Range>(this.verifiedBlocks, this.partialBlocks, this.savedCorruptBlocks)) {
            ret.add(next);
        }
        return ret.getAllIntervalsAsList();
    }

    public synchronized Iterable<Range> getBlocks() {
        if (this.allBlocksIterable == null) {
            this.allBlocksIterable = new MultiIterable<Range>(this.verifiedBlocks, this.partialBlocks, this.savedCorruptBlocks, this.pendingBlocks);
        }
        return this.allBlocksIterable;
    }

    public synchronized long getOffsetForPreview() {
        if (!this.savedCorruptBlocks.isEmpty()) {
            IntervalSet lump = new IntervalSet();
            lump.add(this.savedCorruptBlocks);
            lump.add(this.verifiedBlocks);
            lump.add(this.partialBlocks);
            if (lump.getFirst().getLow() != 0L) {
                return 0L;
            }
            return lump.getFirst().getHigh();
        }
        IntervalSet firsts = new IntervalSet();
        if (!this.verifiedBlocks.isEmpty()) {
            firsts.add(this.verifiedBlocks.getFirst());
        }
        if (!this.partialBlocks.isEmpty()) {
            firsts.add(this.partialBlocks.getFirst());
        }
        if (firsts.isEmpty() || firsts.getFirst().getLow() != 0L) {
            return 0L;
        }
        return firsts.getFirst().getHigh();
    }

    public synchronized List<Range> getVerifiedBlocksAsList() {
        return this.verifiedBlocks.getAllIntervalsAsList();
    }

    public synchronized long getBlockSize() {
        return this.verifiedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize();
    }

    public synchronized long getPendingSize() {
        return this.pendingBlocks.getSize();
    }

    public synchronized long getVerifiedBlockSize() {
        return this.verifiedBlocks.getSize();
    }

    public synchronized long getAmountLost() {
        return this.lostSize;
    }

    public synchronized boolean isComplete() {
        if (this.hashTree != null) {
            return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() == this.completedSize;
        }
        return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.partialBlocks.getSize() == this.completedSize;
    }

    public synchronized String listMissingPieces() {
        IntervalSet all = new IntervalSet();
        all.add(Range.createRange(0L, this.completedSize - 1L));
        all.delete(this.verifiedBlocks);
        all.delete(this.savedCorruptBlocks);
        if (this.hashTree == null) {
            all.delete(this.partialBlocks);
        }
        return all.toString() + ", pending: " + this.pendingBlocks.toString() + ", has tree? " + (this.hashTree != null) + ", verified: " + this.verifiedBlocks + ", savedCorrupt: " + this.savedCorruptBlocks + ", partial: " + this.partialBlocks;
    }

    public synchronized void waitForPendingIfNeeded() throws InterruptedException, DiskException {
        if (this.storedException != null) {
            throw new DiskException(this.storedException);
        }
        while (!this.isComplete() && this.getBlockSize() == this.completedSize) {
            if (this.storedException != null) {
                throw new DiskException(this.storedException);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("waiting for a pending chunk to verify or write..");
            }
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForPending(int timeout) throws InterruptedException, DiskException {
        if (this.storedException != null) {
            throw new DiskException(this.storedException);
        }
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            while (this.chunksScheduledPerFile > 0) {
                this.wait(timeout);
            }
        }
    }

    public synchronized boolean isHopeless() {
        return (float)this.lostSize >= 0.9f * (float)this.completedSize;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized long hasFreeBlocksToAssign() {
        return this.completedSize - (this.verifiedBlocks.getSize() + this.leasedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isOpen = false;
        if (this.fos == null) {
            return;
        }
        try {
            VerifyingFile verifyingFile = this;
            synchronized (verifyingFile) {
                while (this.chunksScheduledPerFile > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized Range leaseWhiteHelper(IntervalSet availableBytes, long chunkSize) throws NoSuchElementException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing white, state:\n" + this.dumpState());
        }
        if (availableBytes == null) {
            availableBytes = IntervalSet.createSingletonSet(0L, this.completedSize - 1L);
        }
        IntervalSet neededBytes = IntervalSet.createSingletonSet(0L, this.completedSize - 1L);
        neededBytes.delete(this.verifiedBlocks);
        neededBytes.delete(this.leasedBlocks);
        neededBytes.delete(this.partialBlocks);
        neededBytes.delete(this.savedCorruptBlocks);
        neededBytes.delete(this.pendingBlocks);
        if (LOG.isDebugEnabled()) {
            LOG.debug("needed bytes: " + neededBytes);
        }
        availableBytes.delete(neededBytes.invert(this.completedSize));
        Range ret = this.blockChooser.pickAssignment(availableBytes, neededBytes, chunkSize);
        this.leaseBlock(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing white interval " + ret + "\nof available intervals " + neededBytes);
        }
        return ret;
    }

    private synchronized void leaseBlock(Range in) {
        this.leasedBlocks.add(in);
    }

    public synchronized void setExpectedHashTreeRoot(String root) {
        this.expectedHashRoot = root;
    }

    public synchronized HashTree getHashTree() {
        return this.hashTree;
    }

    public synchronized boolean setHashTree(HashTree tree) {
        if (this.expectedHashRoot != null && tree != null && !tree.getRootHash().equalsIgnoreCase(this.expectedHashRoot)) {
            return false;
        }
        if (tree != null && tree.getFileSize() != this.completedSize) {
            return false;
        }
        HashTree previous = this.hashTree;
        if (previous != null && tree != null && !previous.getRootHash().equals(tree.getRootHash())) {
            if (this.verifiedBlocks.getSize() > 262144L) {
                return false;
            }
            if (this.verifiedBlocks.getSize() > 0L) {
                this.partialBlocks.add(this.verifiedBlocks);
                this.verifiedBlocks.clear();
                this.diskController.get().addDiskJobWithoutChunk(new EmptyVerifier(this.existingFileSize));
            }
        }
        this.hashTree = tree;
        if (previous == null && tree != null && (this.existingFileSize != -1L || this.pendingBlocks.getSize() == 0L && this.partialBlocks.getSize() > 0L)) {
            this.diskController.get().addDiskJobWithoutChunk(new EmptyVerifier(this.existingFileSize));
            this.existingFileSize = -1L;
        }
        return true;
    }

    public synchronized void setHashTreeRequested(boolean yes) {
        this.hashTreeRequested = yes;
    }

    public synchronized boolean isHashTreeRequested() {
        return this.hashTreeRequested;
    }

    public synchronized void setDiscardUnverified(boolean yes) {
        this.discardBad = yes;
    }

    public synchronized int getChunkSize() {
        return this.hashTree == null ? 131072 : this.hashTree.getNodeSize();
    }

    private void verifyChunks() {
        this.verifyChunks(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyChunks(long existingFileSize) {
        boolean fullScan = existingFileSize != -1L;
        HashTree tree = this.getHashTree();
        if (tree != null) {
            for (Range i : this.findVerifyableBlocks(existingFileSize)) {
                byte[] tmp;
                boolean good = !tree.isCorrupt(i, this.fos, tmp = this.diskController.get().getPowerOf2Chunk(Math.min(65536, tree.getNodeSize())));
                VerifyingFile verifyingFile = this;
                synchronized (verifyingFile) {
                    this.partialBlocks.delete(i);
                    if (good) {
                        this.verifiedBlocks.add(i);
                    } else if (!fullScan) {
                        if (!this.discardBad) {
                            this.savedCorruptBlocks.add(i);
                        }
                        this.lostSize += i.getHigh() - i.getLow() + 1L;
                    }
                }
            }
        }
    }

    private synchronized List<Range> findVerifyableBlocks(long existingFileSize) {
        List<Range> partial;
        if (LOG.isTraceEnabled()) {
            LOG.trace("trying to find verifyable blocks out of " + this.partialBlocks);
        }
        boolean fullScan = existingFileSize != -1L;
        ArrayList<Range> verifyable = new ArrayList<Range>(2);
        int chunkSize = this.getChunkSize();
        if (fullScan) {
            IntervalSet temp = this.partialBlocks.clone();
            temp.add(Range.createRange(0L, existingFileSize));
            partial = temp.getAllIntervalsAsList();
        } else {
            partial = this.partialBlocks.getAllIntervalsAsList();
        }
        for (int i = 0; i < partial.size(); ++i) {
            Range current = partial.get(i);
            long lowChunkOffset = current.getLow() - current.getLow() % (long)chunkSize;
            if (current.getLow() % (long)chunkSize != 0L) {
                lowChunkOffset += (long)chunkSize;
            }
            while (current.getHigh() >= lowChunkOffset + (long)chunkSize - 1L) {
                Range complete = Range.createRange(lowChunkOffset, lowChunkOffset + (long)chunkSize - 1L);
                verifyable.add(complete);
                lowChunkOffset += (long)chunkSize;
            }
        }
        if (!partial.isEmpty()) {
            Range last;
            long lastChunkOffset = this.completedSize - this.completedSize % (long)chunkSize;
            if (lastChunkOffset == this.completedSize) {
                lastChunkOffset -= (long)chunkSize;
            }
            if ((last = partial.get(partial.size() - 1)).getHigh() == this.completedSize - 1L && last.getLow() <= lastChunkOffset) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding the last chunk for verification");
                }
                verifyable.add(Range.createRange(lastChunkOffset, last.getHigh()));
            }
        }
        return verifyable;
    }

    public static class WriteRequest {
        public final long currPos;
        public final int start;
        public final int length;
        public final byte[] buf;
        public final Range in;
        private boolean processed;
        private boolean done;
        private boolean scheduled;

        WriteRequest(long currPos, int start, int length, byte[] buf) {
            this.currPos = currPos;
            this.start = start;
            this.length = length;
            this.buf = buf;
            this.in = Range.createRange(currPos, currPos + (long)length - 1L);
        }

        private synchronized void startProcessing() {
            if (this.isInvalidForWriting()) {
                throw new IllegalStateException("invalid request state");
            }
            this.processed = true;
        }

        private synchronized void startScheduling() {
            if (this.isInvalidForCallback()) {
                throw new IllegalStateException("invalid request state");
            }
            this.scheduled = true;
        }

        private synchronized void setDone() {
            if (this.done) {
                throw new IllegalStateException("invalid request state");
            }
            this.done = true;
        }

        public synchronized boolean isInvalidForCallback() {
            return !this.processed || this.done || this.scheduled;
        }

        public synchronized boolean isInvalidForWriting() {
            return this.done || this.processed;
        }
    }

    private static class VerifyingFileDelayedWrite
    implements DelayedWrite {
        private final WriteRequest request;
        private final WriteCallback callback;
        private final VerifyingFile vf;

        VerifyingFileDelayedWrite(WriteRequest request, WriteCallback callback, VerifyingFile vf) {
            this.request = request;
            this.callback = callback;
            this.vf = vf;
        }

        public boolean write() {
            if (this.vf.writeBlockImpl(this.request)) {
                this.callback.writeScheduled();
                return true;
            }
            return false;
        }
    }

    static interface WriteCallback {
        public void writeScheduled();
    }

    private class EmptyVerifier
    implements Runnable {
        private final long existingFileSize;

        EmptyVerifier(long existingFileSize) {
            this.existingFileSize = existingFileSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VerifyingFile.this.verifyChunks(this.existingFileSize);
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                VerifyingFile.this.notify();
            }
        }
    }

    private class ChunkHandler
    extends ChunkDiskJob {
        private final Range intvl;
        private boolean freedPending;

        public ChunkHandler(byte[] buf, Range intvl) {
            super(buf);
            this.freedPending = false;
            this.intvl = intvl;
            long length = intvl.getHigh() - intvl.getLow() + 1L;
            assert (length <= (long)buf.length) : "invalid length " + length + " vs buf " + buf.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runChunkJob(byte[] buf) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Writing intvl: " + this.intvl);
                }
                Object object = VerifyingFile.this.fos;
                synchronized (object) {
                    VerifyingFile.this.fos.seek(this.intvl.getLow());
                    VerifyingFile.this.fos.write(buf, 0, (int)(this.intvl.getHigh() - this.intvl.getLow() + 1L));
                }
                object = VerifyingFile.this;
                synchronized (object) {
                    VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    VerifyingFile.this.partialBlocks.add(this.intvl);
                    this.freedPending = true;
                }
                VerifyingFile.this.verifyChunks();
            }
            catch (IOException diskIO) {
                VerifyingFile verifyingFile = VerifyingFile.this;
                synchronized (verifyingFile) {
                    VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    VerifyingFile.this.storedException = diskIO;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                try {
                    if (!this.freedPending) {
                        VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    }
                }
                finally {
                    --VerifyingFile.this.chunksScheduledPerFile;
                    VerifyingFile.this.notifyAll();
                }
            }
        }
    }
}

