/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializeSettings;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloadSerializerImpl
implements DownloadSerializer {
    private static final Log LOG = LogFactory.getLog(DownloadSerializerImpl.class);
    private final DownloadSerializeSettings downloadSerializeSettings;

    @Inject
    public DownloadSerializerImpl(DownloadSerializeSettings downloadSerializeSettings) {
        this.downloadSerializeSettings = downloadSerializeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadMemento> readFromDisk() throws IOException {
        Throwable exception;
        List<DownloadMemento> list;
        if (!this.downloadSerializeSettings.getSaveFile().exists() && !this.downloadSerializeSettings.getSaveFile().exists()) {
            return Collections.emptyList();
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getSaveFile())));
            list = GenericsUtils.scanForList(in.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable ignored) {
            try {
                exception = ignored;
                LOG.warn("Error reading normal file.", ignored);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        return list;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getBackupFile())));
            List<DownloadMemento> ignored = GenericsUtils.scanForList(in.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
            return ignored;
        }
        catch (Throwable ignored) {
            LOG.warn("Error reading normal file.", ignored);
        }
        finally {
            IOUtils.close(in);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (IOException)new IOException().initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToDisk(List<? extends DownloadMemento> mementos) {
        File backupFile = this.downloadSerializeSettings.getBackupFile();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(backupFile)));
            out.writeObject(mementos);
        }
        catch (IOException iox) {
            boolean bl;
            try {
                LOG.warn("Unable to write to backup file!", iox);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
            IOUtils.close(out);
            return bl;
        }
        IOUtils.close(out);
        File saveFile = this.downloadSerializeSettings.getSaveFile();
        if (saveFile.equals(backupFile)) {
            LOG.debug("backup == save, nothing more to do");
            return true;
        }
        File saveDir = saveFile.getParentFile();
        File tmpFile = null;
        try {
            tmpFile = FileUtils.createTempFile("lwc", "tmp", saveDir);
        }
        catch (IOException ignored) {
            LOG.warn("Error creating temp file", ignored);
        }
        if (tmpFile != null) {
            tmpFile.delete();
            if (!saveFile.renameTo(tmpFile)) {
                LOG.debug("Unable to rename save to temp, deleting instead!");
                saveFile.delete();
            }
        } else {
            saveFile.delete();
        }
        boolean renamed = backupFile.renameTo(this.downloadSerializeSettings.getSaveFile());
        if (tmpFile != null) {
            if (!renamed) {
                tmpFile.renameTo(saveFile);
            }
            tmpFile.delete();
        }
        return renamed;
    }
}

