/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.mojito.messages.DHTMessage;

abstract class AbstractIPFilter
implements IPFilter {
    private static final Log LOG = LogFactory.getLog(AbstractIPFilter.class);
    private static final IP ALLOWED = new IP(new byte[4]);

    AbstractIPFilter() {
    }

    protected IP extractAddress(Message m) {
        if (m instanceof PingReply) {
            PingReply pr = (PingReply)m;
            return this.getIP(pr.getAddress());
        }
        if (m instanceof QueryReply) {
            QueryReply qr = (QueryReply)m;
            return this.getIP(qr.getIPBytes());
        }
        if (m instanceof PushRequest) {
            PushRequest push = (PushRequest)m;
            return this.getIP(push.getIP());
        }
        if (m instanceof QueryRequest) {
            QueryRequest query = (QueryRequest)m;
            if (query.desiresOutOfBandReplies()) {
                return this.getIP(query.getGUID());
            }
            return ALLOWED;
        }
        if (m instanceof DHTMessage) {
            DHTMessage message = (DHTMessage)((Object)m);
            InetSocketAddress addr = (InetSocketAddress)message.getContact().getContactAddress();
            if (addr != null && addr.getAddress() instanceof Inet4Address) {
                return this.getIP(addr.getAddress().getAddress());
            }
            return ALLOWED;
        }
        return ALLOWED;
    }

    private IP getIP(byte[] host) {
        IP ip = null;
        try {
            ip = new IP(host, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ip;
    }

    private IP getIP(String host) {
        IP ip = null;
        try {
            ip = new IP(host);
        }
        catch (IllegalArgumentException badHost) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("doing dns lookup for " + host);
                }
                InetAddress lookUp = InetAddress.getByName(host);
                host = lookUp.getHostAddress();
                ip = new IP(host);
            }
            catch (UnknownHostException unknownHost) {
            }
            catch (IllegalArgumentException stillBadHost) {
                // empty catch block
            }
        }
        return ip;
    }

    public boolean allow(Message m) {
        return this.allow(this.extractAddress(m));
    }

    public boolean allow(SocketAddress addr) {
        if (!(addr instanceof InetSocketAddress)) {
            return false;
        }
        return this.allow(((InetSocketAddress)addr).getAddress().getAddress());
    }

    public boolean allow(byte[] host) {
        return this.allow(this.getIP(host));
    }

    public boolean allow(String host) {
        return this.allow(this.getIP(host));
    }

    public boolean allow(IP ip) {
        return this.allowAndLog(ip);
    }

    private boolean allowAndLog(IP ip) {
        if (ip == ALLOWED) {
            LOG.debug("allowing non-checkable ip.");
            return true;
        }
        if (ip == null) {
            LOG.debug("not allowing invalid ip");
            return false;
        }
        boolean yes = this.allowImpl(ip);
        if (yes && LOG.isDebugEnabled()) {
            LOG.debug(this.hashCode() + " allowing " + ip);
        } else if (!yes && LOG.isInfoEnabled()) {
            LOG.info(this.hashCode() + " NOT allowing " + ip);
        }
        return yes;
    }

    protected abstract boolean allowImpl(IP var1);
}

