/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AbstractIPFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.settings.FilterSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;

@Singleton
public class HostileFilter
extends AbstractIPFilter {
    private static final Log LOG = LogFactory.getLog(HostileFilter.class);
    private volatile IPList hostileHosts = new IPList();
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HostileFilter(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void refreshHosts(IPFilter.IPFilterCallback callback) {
        this.refreshHosts();
        callback.ipFiltersLoaded();
    }

    public void refreshHosts() {
        LOG.info(this.hashCode() + " refreshing hosts at hostile level");
        IPList newHostile = new IPList();
        String[] allHosts = FilterSettings.HOSTILE_IPS.getValue();
        try {
            for (String ip : allHosts) {
                newHostile.add(new IP(ip));
            }
            if (newHostile.isValidFilter(false, this.networkInstanceUtils)) {
                this.hostileHosts = newHostile;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean hasBlacklistedHosts() {
        return !this.hostileHosts.isEmpty();
    }

    public int logMinDistanceTo(IP ip) {
        return this.hostileHosts.logMinDistanceTo(ip);
    }

    protected boolean allowImpl(IP ip) {
        return !this.hostileHosts.contains(ip);
    }
}

