/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.XMLDocFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.Set;
import java.util.TreeSet;

@Singleton
public final class MutableGUIDFilter
implements SpamFilter {
    private Set<byte[]> _guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
    private final KeywordFilter FILTER;

    MutableGUIDFilter(KeywordFilter filter) {
        this.FILTER = filter;
    }

    MutableGUIDFilter() {
        this(new XMLDocFilter());
        this.FILTER.disallowAdult();
    }

    public synchronized void addGUID(byte[] guid) {
        TreeSet<byte[]> guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
        guids.addAll(this._guids);
        guids.add(guid);
        this._guids = guids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] guid) {
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet<byte[]> guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
                guids.addAll(this._guids);
                guids.remove(guid);
                this._guids = guids;
            }
        }
    }

    public boolean allow(QueryReply qr) {
        if (this._guids.contains(qr.getGUID())) {
            return this.FILTER.allow(qr);
        }
        return true;
    }

    public boolean allow(Message m) {
        if (m instanceof QueryReply) {
            return this.allow((QueryReply)m);
        }
        return true;
    }
}

