/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.HashFilter;
import com.limegroup.gnutella.filters.HostileFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.LocalIPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SpamFilterFactoryImpl
implements SpamFilterFactory {
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<HostileFilter> hostileFilter;
    private final Provider<LocalIPFilter> ipFilter;

    @Inject
    public SpamFilterFactoryImpl(Provider<MutableGUIDFilter> mutableGUIDFilter, Provider<HostileFilter> hostileFilter, Provider<LocalIPFilter> ipFilter) {
        this.mutableGUIDFilter = mutableGUIDFilter;
        this.hostileFilter = hostileFilter;
        this.ipFilter = ipFilter;
    }

    @Override
    public SpamFilter createPersonalFilter() {
        Vector<SpamFilter> buf = new Vector<SpamFilter>();
        LocalIPFilter ipFilter = this.ipFilter.get();
        if (ipFilter.hasBlacklistedHosts()) {
            buf.add(ipFilter);
        }
        String[] badWords = FilterSettings.BANNED_WORDS.getValue();
        boolean filterAdult = FilterSettings.FILTER_ADULT.getValue();
        boolean filterVbs = FilterSettings.FILTER_VBS.getValue();
        boolean filterHtml = FilterSettings.FILTER_HTML.getValue();
        boolean filterWMVASF = FilterSettings.FILTER_WMV_ASF.getValue();
        if (badWords.length != 0 || filterAdult || filterVbs || filterHtml) {
            KeywordFilter kf = new KeywordFilter();
            for (int i = 0; i < badWords.length; ++i) {
                kf.disallow(badWords[i]);
            }
            if (filterAdult) {
                kf.disallowAdult();
            }
            if (filterVbs) {
                kf.disallowVbs();
            }
            if (filterHtml) {
                kf.disallowHtml();
            }
            if (filterWMVASF) {
                kf.disallowWMVASF();
            }
            buf.add(kf);
        }
        SpamReplyFilter spf = new SpamReplyFilter();
        buf.add(spf);
        buf.add(this.mutableGUIDFilter.get());
        return SpamFilterFactoryImpl.compose(buf);
    }

    @Override
    public SpamFilter createRouteFilter() {
        Vector<SpamFilter> buf = new Vector<SpamFilter>();
        buf.add(new RequeryFilter());
        buf.add(new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            buf.add(new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            buf.add(new GreedyQueryFilter());
        }
        if (FilterSettings.FILTER_HASH_QUERIES.getValue()) {
            buf.add(new HashFilter());
        }
        buf.add(this.hostileFilter.get());
        return SpamFilterFactoryImpl.compose(buf);
    }

    private static SpamFilter compose(Vector<? extends SpamFilter> filters) {
        if (filters.size() == 0) {
            return new AllowFilter();
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        Object[] delegates = new SpamFilter[filters.size()];
        filters.copyInto(delegates);
        return new CompositeFilter((SpamFilter[])delegates);
    }
}

