/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDocFilter
extends KeywordFilter {
    private Map<String, List<String>> disallowedFieldValues = new HashMap<String, List<String>>();
    private Map<String, List<String>> disallowedExactFieldValues = new HashMap<String, List<String>>();

    public void addDisallowedEntries(String field, List<String> values) {
        List<String> list = this.disallowedFieldValues.get(field);
        if (list == null) {
            list = new ArrayList<String>(values);
            this.disallowedFieldValues.put(field, list);
        } else {
            list.addAll(values);
        }
    }

    public void addDisallowedExactEntries(String field, List<String> values) {
        List<String> list = this.disallowedExactFieldValues.get(field);
        if (list == null) {
            list = new ArrayList<String>(values);
            this.disallowedExactFieldValues.put(field, list);
        } else {
            list.addAll(values);
        }
    }

    @Override
    public void disallowAdult() {
        this.addDisallowedEntries("videos__video__type__", Arrays.asList("adult"));
        this.addDisallowedEntries("videos__video__rating__", Arrays.asList("adult"));
        this.addDisallowedExactEntries("videos__video__rating__", Arrays.asList("r", "nc-17"));
        super.disallowAdult();
    }

    @Override
    boolean allow(QueryReply qr) {
        if (!super.allow(qr)) {
            return false;
        }
        try {
            for (Response resp : qr.getResultsAsList()) {
                LimeXMLDocument doc = resp.getDocument();
                if (doc == null || this.allowDoc(doc)) continue;
                return false;
            }
            return true;
        }
        catch (BadPacketException bpe) {
            return false;
        }
    }

    protected boolean allowDoc(LimeXMLDocument doc) {
        String values;
        for (Map.Entry<String, List<String>> entry : this.disallowedFieldValues.entrySet()) {
            values = doc.getValue(entry.getKey());
            if (values == null) continue;
            values = values.toLowerCase(Locale.US);
            for (String disallowed : entry.getValue()) {
                if (!values.contains(disallowed)) continue;
                return false;
            }
        }
        for (Map.Entry<String, List<String>> entry : this.disallowedExactFieldValues.entrySet()) {
            values = doc.getValue(entry.getKey());
            if (values == null) continue;
            values = values.toLowerCase(Locale.US);
            for (String disallowed : entry.getValue()) {
                if (!values.equals(disallowed)) continue;
                return false;
            }
        }
        return true;
    }
}

