/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.geocode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.geocode.CachedGeoLocation;
import com.limegroup.gnutella.settings.GeocodeSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.geocode.Geocoder;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CachedGeoLocationImpl
implements CachedGeoLocation {
    private static final Log LOG = LogFactory.getLog(CachedGeoLocationImpl.class);
    private final Provider<Geocoder> geocoder;
    private volatile GeocodeInformation info;
    private final NetworkManager networkManager;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    @Inject
    public CachedGeoLocationImpl(Provider<Geocoder> geocoder, NetworkManager networkManager) {
        this.geocoder = geocoder;
        this.networkManager = networkManager;
    }

    @Override
    public GeocodeInformation getGeocodeInformation() {
        if (this.initialized.compareAndSet(false, true)) {
            LOG.debug("initializing");
            this.initialize();
        }
        return this.info;
    }

    void initialize() {
        this.info = GeocodeInformation.fromProperties(GeocodeSettings.GEO_LOCATION.getValue());
        if (this.info != null) {
            byte[] currentAddress = this.networkManager.getExternalAddress();
            if (currentAddress == null) {
                LOG.debug("no address from networkmanager to compare with");
                return;
            }
            String lastAddress = this.info.getProperty(GeocodeInformation.Property.Ip);
            if (lastAddress != null) {
                try {
                    byte[] lastIp = InetAddress.getByName(lastAddress).getAddress();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("comparing addressed: " + lastAddress + " and " + NetworkUtils.ip2string(currentAddress));
                    }
                    if (NetworkUtils.isCloseIP(currentAddress, lastIp)) {
                        return;
                    }
                }
                catch (UnknownHostException e) {
                    LOG.warn("Unable to get host by name", e);
                }
            }
        }
        Geocoder coder = this.geocoder.get();
        coder.initialize();
        this.info = coder.getGeocodeInformation();
        if (this.info != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("new info: " + this.info);
            }
            GeocodeSettings.GEO_LOCATION.setValue(this.info.toProperties());
        }
    }
}

