/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.geocode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.settings.GeocodeSettings;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.limewire.geocode.AbstractGeocoder;
import org.limewire.http.httpclient.LimeHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GeocoderImpl
extends AbstractGeocoder {
    private final Provider<LimeHttpClient> httpClient;

    @Inject
    public GeocoderImpl(Provider<LimeHttpClient> client) {
        this.httpClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        HttpGet get;
        String url = GeocodeSettings.GEOCODE_URL.getValue();
        if (url == null || url.equals("")) {
            this.setInvalid(new IllegalArgumentException("No URL"));
            return;
        }
        try {
            get = new HttpGet(url);
        }
        catch (URISyntaxException muri) {
            this.setInvalid(muri);
            return;
        }
        LimeHttpClient client = this.httpClient.get();
        HttpResponse response = null;
        try {
            HttpEntity entity;
            response = client.execute(get);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                this.setGeocodeInformation(entity.getContent());
                return;
            }
            this.setInvalid(new IOException("invalid response"));
        }
        catch (HttpException e) {
            this.setInvalid(e);
        }
        catch (IOException e) {
            this.setInvalid(e);
        }
        finally {
            client.releaseConnection(response);
        }
    }
}

