/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.security.AddressSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OnDemandUnicaster {
    private static final Log LOG = LogFactory.getLog(OnDemandUnicaster.class);
    private static final int CLEAR_TIME = 300000;
    private static final int QUERIED_HOSTS_CLEAR_TIME = 30000;
    private final Map<GUID.TimedGUID, Set<IpPort>> _queriedHosts;
    private final Map<GUESSEndpoint, AddressSecurityToken> _queryKeys;
    private final Map<GUESSEndpoint, SendLaterBundle> _bufferedURNs;
    private final QueryRequestFactory queryRequestFactory;
    private final UDPService udpService;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    @InspectionPoint(value="Unicaster class C stats")
    private final Inspectable classCQueried = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            ClassCNetworks cnc = new ClassCNetworks();
            Map map = OnDemandUnicaster.this._queriedHosts;
            synchronized (map) {
                for (Set s : OnDemandUnicaster.this._queriedHosts.values()) {
                    cnc.addAll(s);
                }
            }
            HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
            ret.put("queried", cnc.getTopInspectable(10));
            return ret;
        }
    };

    @Inject
    public OnDemandUnicaster(QueryRequestFactory queryRequestFactory, UDPService udpService, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory) {
        this.queryRequestFactory = queryRequestFactory;
        this.udpService = udpService;
        this.messageRouter = messageRouter;
        this.pingRequestFactory = pingRequestFactory;
        this._queryKeys = new Hashtable<GUESSEndpoint, AddressSecurityToken>();
        this._bufferedURNs = new Hashtable<GUESSEndpoint, SendLaterBundle>();
        this._queriedHosts = new HashMap<GUID.TimedGUID, Set<IpPort>>();
        backgroundExecutor.scheduleWithFixedDelay(new Expirer(), 300000L, 300000L, TimeUnit.MILLISECONDS);
        backgroundExecutor.scheduleWithFixedDelay(new QueriedHostsExpirer(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void handleQueryKeyPong(PingReply pr) throws NullPointerException, IllegalArgumentException {
        if (pr == null) {
            throw new NullPointerException("null pong");
        }
        AddressSecurityToken qk = pr.getQueryKey();
        if (qk == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress address = pr.getInetAddress();
        int port = pr.getPort();
        GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
        this._queryKeys.put(endpoint, qk);
        SendLaterBundle bundle = this._bufferedURNs.remove(endpoint);
        if (bundle != null) {
            this.sendQuery(bundle._queryURN, qk, endpoint);
        }
    }

    public void query(GUESSEndpoint ep, URN queryURN) throws IllegalArgumentException {
        if (ep == null) {
            throw new IllegalArgumentException("No Endpoint!");
        }
        if (queryURN == null) {
            throw new IllegalArgumentException("No urn to look for!");
        }
        AddressSecurityToken key = this._queryKeys.get(ep);
        if (key == null) {
            GUESSEndpoint endpoint = new GUESSEndpoint(ep.getInetAddress(), ep.getPort());
            SendLaterBundle bundle = new SendLaterBundle(queryURN);
            this._bufferedURNs.put(endpoint, bundle);
            PingRequest pr = this.pingRequestFactory.createQueryKeyRequest();
            this.udpService.send(pr, ep.getInetAddress(), ep.getPort());
        } else {
            this.sendQuery(queryURN, key, ep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostQueriedForGUID(GUID guid, IpPort host) {
        Map<GUID.TimedGUID, Set<IpPort>> map = this._queriedHosts;
        synchronized (map) {
            Set<IpPort> hosts = this._queriedHosts.get(new GUID.TimedGUID(guid));
            return hosts != null ? hosts.contains(host) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(URN urn, AddressSecurityToken qk, IpPort ipp) {
        QueryRequest query = this.queryRequestFactory.createQueryKeyQuery(urn, qk);
        GUID qGUID = new GUID(query.getGUID());
        Map<GUID.TimedGUID, Set<IpPort>> map = this._queriedHosts;
        synchronized (map) {
            GUID.TimedGUID guid = new GUID.TimedGUID(qGUID, 30000L);
            IpPortSet hosts = this._queriedHosts.get(guid);
            if (hosts == null) {
                hosts = new IpPortSet();
            }
            hosts.add((IpPort)ipp);
            this._queriedHosts.put(guid, hosts);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending query with GUID: " + qGUID + " for URN: " + urn + " to host: " + ipp);
        }
        this.messageRouter.get().originateQueryGUID(query.getGUID());
        this.udpService.send(query, ipp.getInetAddress(), ipp.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearDataStructures(long lastQueryKeyClearTime, long queryKeyClearInterval) {
        boolean clearedQueryKeys = false;
        if (System.currentTimeMillis() - lastQueryKeyClearTime > queryKeyClearInterval) {
            clearedQueryKeys = true;
            this._queryKeys.clear();
        }
        Map<GUESSEndpoint, SendLaterBundle> map = this._bufferedURNs;
        synchronized (map) {
            Iterator<SendLaterBundle> iter = this._bufferedURNs.values().iterator();
            while (iter.hasNext()) {
                SendLaterBundle bundle = iter.next();
                if (!bundle.shouldExpire()) continue;
                iter.remove();
            }
        }
        return clearedQueryKeys;
    }

    private class QueriedHostsExpirer
    implements Runnable {
        private QueriedHostsExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = OnDemandUnicaster.this._queriedHosts;
            synchronized (map) {
                long now = System.currentTimeMillis();
                Iterator iter = OnDemandUnicaster.this._queriedHosts.keySet().iterator();
                while (iter.hasNext()) {
                    GUID.TimedGUID guid = (GUID.TimedGUID)iter.next();
                    if (!guid.shouldExpire(now)) continue;
                    iter.remove();
                }
            }
        }
    }

    private class Expirer
    implements Runnable {
        private static final int QUERY_KEY_CLEAR_TIME = 86400000;
        private long _lastQueryKeyClearTime = System.currentTimeMillis();

        public void run() {
            if (OnDemandUnicaster.this.clearDataStructures(this._lastQueryKeyClearTime, 86400000L)) {
                this._lastQueryKeyClearTime = System.currentTimeMillis();
            }
        }
    }

    private class SendLaterBundle {
        private static final int MAX_LIFETIME = 60000;
        public final URN _queryURN;
        private final long _creationTime;

        public SendLaterBundle(URN urn) {
            this._queryURN = urn;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._creationTime > 60000L;
        }
    }
}

