/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SeperatorBorder;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList<E>
extends BoxPanel {
    private String disabledTooltip = null;
    private boolean removeable = false;
    private boolean selectOff;
    private JScrollPane scrollPane;
    private JTable checkBoxList;
    private CheckBoxListSelectionListener selectionListener;
    private CheckBoxListCheckChangeListener checkListener;
    private Object parent;
    private int highLightedRow = -1;
    private final Set<E> elements = new HashSet();
    private final Set<E> unchecked = new HashSet();
    private final Set<E> checked = new HashSet();
    private final Set<E> disabled = new HashSet();
    private final Set<E> bolded = new HashSet();
    private Object selected;
    public static final int SELECT_FIRST_ON = 0;
    public static final int SELECT_FIRST_OFF = 1;
    private static final int DEFAULT_ROW_HEIGHT = 22;
    private TextProvider<E> provider;
    private ExtrasProvider<E> extrasProvider;
    private List<E> items;
    private int visibleRowCount = -1;
    public static final String TEXT_PROVIDER_PROPERTY = "textProvider";
    private CheckBoxCellEditor editor;

    public CheckBoxList(Collection<E> elements, Collection<E> notCheckedElements, TextProvider<E> provider, ExtrasProvider<E> separatorProvider, int mode) {
        this.provider = provider;
        this.extrasProvider = separatorProvider;
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        this.parent = this;
        this.selectionListener = null;
        this.selectOff = mode == 1;
        this.initialize();
        this.setElements(elements, notCheckedElements);
    }

    public CheckBoxList(Collection<E> elements, Collection<E> notCheckedElements, TextProvider<E> provider, int mode) {
        this(elements, notCheckedElements, provider, null, mode);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider, boolean checkAll, int mode) {
        this(elements, checkAll ? new HashSet() : elements, provider, null, mode);
    }

    public CheckBoxList(Collection<E> totalElements, Collection<E> notCheckedElements, int mode) {
        this(totalElements, notCheckedElements, new DefaultTextProvider(), null, mode);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider, int mode) {
        this(elements, new HashSet(), provider, null, mode);
    }

    public CheckBoxList(Collection<E> elements) {
        this(elements, new DefaultTextProvider(), 0);
    }

    public CheckBoxList(Collection<E> elements, TextProvider<E> provider) {
        this(elements, provider, 0);
    }

    public void setElements(Collection<E> elements) {
        this.setElements(elements, true);
    }

    public void setElements(Collection<E> elements, boolean checked) {
        if (checked) {
            this.setElements(elements, new HashSet());
        } else {
            this.setElements(elements, elements);
        }
    }

    public void setElements(Collection<E> elements, Collection<E> notCheckedElements) {
        this.items = new ArrayList<E>(elements);
        Object[][] rowData = new Object[elements.size()][1];
        for (int i = 0; i < elements.size(); ++i) {
            rowData[i][0] = this.items.get(i);
        }
        this.elements.clear();
        this.checked.clear();
        this.unchecked.clear();
        this.elements.addAll(elements);
        this.checked.addAll(elements);
        this.checked.removeAll(notCheckedElements);
        this.unchecked.addAll(notCheckedElements);
        if (rowData.length > 0) {
            this.selected = rowData[0];
        }
        this.checkBoxList.setModel(new DefaultTableModel(rowData, new String[]{""}));
    }

    public void update() {
        ((DefaultTableModel)this.checkBoxList.getModel()).fireTableStructureChanged();
    }

    public void removeItem(Object key) {
        HashSet<E> newElements = new HashSet<E>(this.elements);
        HashSet<E> newUnchecked = new HashSet<E>(this.unchecked);
        newElements.remove(key);
        newUnchecked.remove(key);
        this.setElements(newElements, newUnchecked);
    }

    public void setRemovable(boolean state) {
        this.removeable = state;
        this.update();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBoxList.setEnabled(enabled);
    }

    public void setDisabledTooltip(String tooltip) {
        this.disabledTooltip = tooltip;
    }

    public String getDisabledTooltip() {
        return this.disabledTooltip;
    }

    private static void ensureRowVisible(JTable table, int row) {
        if (row != -1) {
            Rectangle cellRect = table.getCellRect(row, 0, false);
            Rectangle visibleRect = table.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                table.scrollRectToVisible(cellRect);
            }
        }
    }

    public void ensureRowVisible(E key) {
        int row;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        for (row = 0; row < this.checkBoxList.getModel().getRowCount(); ++row) {
            Object item = this.checkBoxList.getModel().getValueAt(row, 0);
            if (item == null) {
                return;
            }
            if (item.equals(key)) break;
        }
        CheckBoxList.ensureRowVisible(this.checkBoxList, row);
    }

    public void setItemSelected(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.selected = key;
        this.ensureRowVisible(key);
        this.editor.notifyChange();
        this.update();
    }

    public boolean setItemChecked(E key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.checked.contains(key)) {
            this.checked.add(key);
            this.unchecked.remove(key);
        }
        this.bolded.add(key);
        this.update();
        this.ensureRowVisible(key);
        new Timer(2000, new BoldRemoveListener(key)).start();
        return true;
    }

    public void setItemsEnabled(Set<E> keys, boolean state) {
        if (state) {
            HashSet<E> toUncheck = new HashSet<E>(this.checked);
            toUncheck.retainAll(keys);
            toUncheck.retainAll(this.disabled);
            this.checked.removeAll(toUncheck);
            this.unchecked.addAll(toUncheck);
            this.disabled.removeAll(keys);
        } else {
            this.disabled.addAll(keys);
        }
        this.update();
    }

    public void setItemsChecked(Set<E> keys, boolean state) {
        if (state) {
            this.unchecked.removeAll(keys);
            this.checked.addAll(keys);
        } else {
            this.unchecked.addAll(keys);
            this.checked.removeAll(keys);
        }
        this.update();
    }

    @Override
    public boolean isEnabled() {
        return this.checkBoxList.isEnabled();
    }

    public void setVisibleRowCount(int rows) {
        this.visibleRowCount = rows;
        this.setPreferredSize(this.getPreferredScrollableViewportSize());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.visibleRowCount > 0 && this.items.size() > 0 ? new Dimension(this.getPreferredSize().width, this.visibleRowCount * this.checkBoxList.getRowHeight()) : this.getPreferredSize();
    }

    public void setSelectionListener(CheckBoxListSelectionListener listener) {
        this.selectionListener = listener;
    }

    public void setCheckChangeListener(CheckBoxListCheckChangeListener listener) {
        this.checkListener = listener;
    }

    public void setTextProvider(TextProvider<E> provider) {
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        TextProvider<E> oldProvider = this.provider;
        this.provider = provider;
        this.firePropertyChange(TEXT_PROVIDER_PROPERTY, oldProvider, this.provider);
    }

    public List<E> getCheckedElements() {
        if (this.checkBoxList.isEnabled() && this.checked.size() > 0) {
            HashSet<E> totalChecked = new HashSet<E>(this.checked);
            totalChecked.removeAll(this.disabled);
            return new LinkedList<E>(totalChecked);
        }
        return Collections.emptyList();
    }

    public List<E> getUncheckedElements() {
        if (!this.checkBoxList.isEnabled()) {
            return new LinkedList<E>(this.elements);
        }
        HashSet<E> toUncheck = new HashSet<E>(this.checked);
        toUncheck.retainAll(this.disabled);
        if (this.unchecked.size() > 0) {
            HashSet<E> totalUnchecked = new HashSet<E>(this.unchecked);
            totalUnchecked.addAll(toUncheck);
            return new LinkedList<E>(totalUnchecked);
        }
        return new LinkedList<E>(toUncheck);
    }

    public Set<E> getElements() {
        return new HashSet<E>(this.elements);
    }

    public Set<E> getRawUncheckedElementsAsSet() {
        return new HashSet<E>(this.unchecked);
    }

    public Action[] getActions() {
        return new Action[]{new SelectAllAction(), new DeselectAllAction()};
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editor = new CheckBoxCellEditor();
        this.checkBoxList = new CustomJTable();
        this.checkBoxList.setDefaultRenderer(Object.class, new CheckBoxCellRenderer());
        this.checkBoxList.setDefaultEditor(Object.class, this.editor);
        this.checkBoxList.setRowHeight(22);
        this.checkBoxList.setTableHeader(new JTableHeader());
        this.checkBoxList.getTableHeader().setVisible(false);
        this.checkBoxList.getTableHeader().setSize(0, 0);
        this.scrollPane = new JScrollPane(this.checkBoxList);
        this.add(this.scrollPane);
        this.updateUI();
    }

    private void updateRowHeight() {
        int increment = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
        if (increment != 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.checkBoxList.setRowHeight(Math.max(fm.getHeight() + 5, 24));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.checkBoxList == null) {
            return;
        }
        this.updateRowHeight();
        this.setBackground(UIManager.getColor("List.textBackground"));
        this.checkBoxList.setBackground(UIManager.getColor("List.background"));
        this.checkBoxList.setGridColor(UIManager.getColor("List.background"));
        this.scrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IconDataCheckBox
    extends BoxPanel {
        private E obj;
        private JCheckBox checkBox;
        private JLabel label;
        private com.limegroup.gnutella.gui.CheckBoxList$IconDataCheckBox.DeleteButton button;
        private Border blankBorder;
        private SeperatorBorder sepBorder;
        private Font originalFont;
        private Font boldFont;

        public IconDataCheckBox() {
            super(0);
            this.sepBorder = new SeperatorBorder();
            this.blankBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, (Icon)null);
            this.label = new JLabel();
            this.label.setBorder(this.blankBorder);
            this.checkBox = new JCheckBox("", true);
            this.button = new DeleteButton();
            this.add(Box.createHorizontalStrut(4));
            this.add(this.checkBox);
            this.add(this.label);
            this.add(Box.createHorizontalStrut(1));
            this.add(Box.createHorizontalGlue());
            this.add((Component)this.button);
            this.updateLook();
            this.originalFont = this.label.getFont();
            this.boldFont = this.originalFont.deriveFont(this.originalFont.getStyle() | 1 | 2);
        }

        public E getData() {
            return this.obj;
        }

        public void setRemovable(boolean state) {
            this.button.setVisible(state);
        }

        public void setData(E obj) {
            this.obj = obj;
            String text = CheckBoxList.this.provider.getText(obj);
            this.label.setIcon(CheckBoxList.this.provider.getIcon(obj));
            if (CheckBoxList.this.extrasProvider != null) {
                this.label.setText(text + " " + CheckBoxList.this.extrasProvider.getComment(obj));
                if (CheckBoxList.this.extrasProvider.isSeparated(obj)) {
                    this.label.setBorder(this.sepBorder);
                } else {
                    this.label.setBorder(this.blankBorder);
                }
            } else {
                this.label.setText(text);
            }
            this.setToolTipText(CheckBoxList.this.provider.getToolTipText(obj));
        }

        public void setHighlight(boolean b) {
            this.button.setHighlight(b);
            if (b) {
                this.setToolTipText("Remove...");
            } else {
                this.setToolTipText(CheckBoxList.this.provider.getToolTipText(this.obj));
            }
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.checkBox.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        @Override
        public void setForeground(Color c) {
            if (this.label != null) {
                this.label.setForeground(c);
            }
        }

        public void setBold(boolean b) {
            if (b) {
                this.label.setFont(this.boldFont);
            } else {
                this.label.setFont(this.originalFont);
            }
        }

        private void updateLook() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setForeground(UIManager.getColor("List.foreground"));
            this.checkBox.setFont(UIManager.getFont("Table.font"));
            this.checkBox.setOpaque(false);
            this.label.setBackground(UIManager.getColor("List.background"));
            this.label.setForeground(UIManager.getColor("List.foreground"));
            this.label.setFont(UIManager.getFont("Table.font"));
            this.label.setOpaque(false);
        }

        public void addActionListener(ActionListener l) {
            this.checkBox.addActionListener(l);
        }

        public void addTopMouseListener(MouseListener l) {
            this.addMouseListener(l);
            this.label.addMouseListener(l);
        }

        private class DeleteButton
        extends JButton {
            private Icon iconReg = GUIMediator.getThemeImage("delete_small");
            private Icon iconHi = GUIMediator.getThemeImage("delete_small_hi");

            public DeleteButton() {
                this.setIcon(this.iconReg);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setContentAreaFilled(false);
                this.setVisible(false);
                this.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent e) {
                    }

                    public void mouseEntered(MouseEvent e) {
                    }

                    public void mouseExited(MouseEvent e) {
                    }

                    public void mousePressed(MouseEvent e) {
                        CheckBoxList.this.removeItem(IconDataCheckBox.this.obj);
                    }

                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }

            public void setHighlight(boolean b) {
                if (b) {
                    this.setIcon(this.iconHi);
                } else {
                    this.setIcon(this.iconReg);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TextProvider<E> {
        public String getText(E var1);

        public String getToolTipText(E var1);

        public Icon getIcon(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExtrasProvider<E> {
        public boolean isSeparated(E var1);

        public String getComment(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CheckBoxListCheckChangeListener<E> {
        public void valueChanged(CheckBoxListCheckChangeEvent<E> var1);
    }

    public static interface CheckBoxListSelectionListener {
        public void valueChanged(CheckBoxListSelectionEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckBoxListCheckChangeEvent<E>
    extends EventObject {
        private E selected;
        private boolean checked;

        public CheckBoxListCheckChangeEvent(Object source, E selected, boolean checked) {
            super(source);
            this.selected = selected;
            this.checked = checked;
        }

        public E getSelected() {
            return this.selected;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }

    public static class CheckBoxListSelectionEvent
    extends EventObject {
        private Object selected;

        public CheckBoxListSelectionEvent(Object source, Object selected) {
            super(source);
            this.selected = selected;
        }

        public Object getSelected() {
            return this.selected;
        }
    }

    private class CheckBoxCellEditor
    extends DefaultCellEditor {
        private com.limegroup.gnutella.gui.CheckBoxList$CheckBoxCellEditor.CustomEditorDelegate customDelegate;

        public CheckBoxCellEditor() {
            super(new JCheckBox());
            IconDataCheckBox checkBox = new IconDataCheckBox();
            this.editorComponent = checkBox;
            checkBox.setRequestFocusEnabled(false);
            this.customDelegate = new CustomEditorDelegate();
            this.delegate = this.customDelegate;
            checkBox.addActionListener((ActionListener)this.customDelegate);
            checkBox.addTopMouseListener((MouseListener)this.customDelegate);
        }

        public void notifyChange() {
            this.customDelegate.notifyChange();
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        private class CustomEditorDelegate
        extends DefaultCellEditor.EditorDelegate
        implements MouseListener {
            private static final long serialVersionUID = -7007164079207676831L;
            private Object lastValue;

            public CustomEditorDelegate() {
                super(CheckBoxCellEditor.this);
                this.lastValue = this.value;
            }

            public void notifyChange() {
                this.lastValue = null;
            }

            public void setValue(Object value) {
                boolean isSelected;
                if (value == null) {
                    return;
                }
                IconDataCheckBox box = (IconDataCheckBox)CheckBoxCellEditor.this.editorComponent;
                box.setData(value);
                box.setRemovable(CheckBoxList.this.removeable);
                box.setEnabled(CheckBoxList.this.isEnabled());
                if (CheckBoxList.this.disabled.contains(value)) {
                    if (CheckBoxList.this.disabledTooltip != null) {
                        box.setToolTipText(CheckBoxList.this.disabledTooltip);
                    }
                    box.setEnabled(false);
                    box.setSelected(false);
                    this.value = value;
                    return;
                }
                CheckBoxList.this.selected = value;
                if (this.lastValue == value) {
                    isSelected = true;
                } else {
                    isSelected = false;
                    CheckBoxList.this.repaint();
                    if (CheckBoxList.this.selectionListener != null) {
                        CheckBoxList.this.selectionListener.valueChanged(new CheckBoxListSelectionEvent(CheckBoxList.this.parent, value));
                    }
                }
                if (CheckBoxList.this.selectOff || isSelected) {
                    boolean decheck = CheckBoxList.this.unchecked.contains(value);
                    if (decheck) {
                        CheckBoxList.this.unchecked.remove(value);
                        CheckBoxList.this.checked.add(value);
                    } else {
                        CheckBoxList.this.unchecked.add(value);
                        CheckBoxList.this.checked.remove(value);
                    }
                    if (CheckBoxList.this.checkListener != null) {
                        CheckBoxList.this.checkListener.valueChanged(new CheckBoxListCheckChangeEvent<Object>(CheckBoxList.this.parent, value, decheck));
                    }
                }
                box.setSelected(CheckBoxList.this.checked.contains(value));
                this.lastValue = value;
                this.value = value;
            }

            public Object getCellEditorValue() {
                return this.value;
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.stopCellEditing();
            }

            public void mouseReleased(MouseEvent e) {
            }
        }
    }

    private class CheckBoxCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8209871264709364379L;
        private IconDataCheckBox checkBox;

        private CheckBoxCellRenderer() {
            this.checkBox = new IconDataCheckBox();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.checkBox.setData(value);
            }
            this.checkBox.setRemovable(CheckBoxList.this.removeable);
            this.checkBox.setHighlight(row == CheckBoxList.this.highLightedRow);
            if (!CheckBoxList.this.selectOff && value != null && value.equals(CheckBoxList.this.selected)) {
                this.checkBox.setBackground(UIManager.getColor("List.selectionBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.checkBox.setBackground(UIManager.getColor("List.textBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.textForeground"));
            }
            if (CheckBoxList.this.bolded.contains(value)) {
                this.checkBox.setBold(true);
            } else {
                this.checkBox.setBold(false);
            }
            if (CheckBoxList.this.disabled.contains(value)) {
                if (CheckBoxList.this.disabledTooltip != null) {
                    this.checkBox.setToolTipText(CheckBoxList.this.disabledTooltip);
                }
                this.checkBox.setEnabled(false);
                this.checkBox.setSelected(false);
            } else {
                this.checkBox.setSelected(!CheckBoxList.this.unchecked.contains(value));
                this.checkBox.setEnabled(table.isEnabled());
            }
            return this.checkBox;
        }
    }

    private class CustomJTable
    extends JTable {
        private CustomJTable() {
        }

        private void shift(int row) {
            if (row != CheckBoxList.this.highLightedRow) {
                CheckBoxList.this.highLightedRow = row;
                CheckBoxList.this.repaint();
            }
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            if (CheckBoxList.this.removeable) {
                int row = this.rowAtPoint(e.getPoint());
                Rectangle firstRowRect = this.getCellRect(row, 0, false);
                Rectangle lastRowRect = this.getCellRect(row, this.getColumnCount() - 1, false);
                Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
                if ((double)e.getX() > dirtyRegion.getWidth() - 16.0) {
                    this.shift(row);
                } else {
                    this.shift(-1);
                }
            }
            super.processMouseMotionEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (CheckBoxList.this.removeable) {
                this.shift(-1);
            }
            super.processMouseEvent(e);
        }
    }

    private class DeselectAllAction
    extends AbstractAction {
        public DeselectAllAction() {
            this.putValue("Name", I18n.tr("Deselect All"));
            this.putValue("ShortDescription", I18n.tr("Deselects all Items in the List"));
        }

        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.unchecked.addAll(CheckBoxList.this.checked);
            CheckBoxList.this.checked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", I18n.tr("Select All"));
            this.putValue("ShortDescription", I18n.tr("Marks all Items as Selected"));
        }

        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.checked.addAll(CheckBoxList.this.unchecked);
            CheckBoxList.this.unchecked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultTextProvider<E>
    implements TextProvider<E> {
        @Override
        public String getText(E obj) {
            return obj.toString();
        }

        @Override
        public String getToolTipText(E obj) {
            return null;
        }

        @Override
        public Icon getIcon(E obj) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoldRemoveListener
    implements ActionListener {
        private E key;

        public BoldRemoveListener(E key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxList.this.bolded.remove(this.key);
            CheckBoxList.this.update();
        }
    }
}

