/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.FocusJOptionPane;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MacUtils;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileChooserHandler {
    private FileChooserHandler() {
    }

    public static File getLastInputDirectory() {
        File dir = ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.getValue();
        if (dir == null || dir.getPath().equals("") || !dir.exists() || !dir.isDirectory()) {
            return CommonUtils.getCurrentDirectory();
        }
        return dir;
    }

    private static void setLastInputDirectory(File file) {
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null && file.exists() && file.isDirectory()) {
                ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.setValue(file);
            }
        }
    }

    public static File getInputDirectory() {
        return FileChooserHandler.getInputDirectory(GUIMediator.getAppFrame());
    }

    public static File getInputDirectory(Component parent) {
        return FileChooserHandler.getInputDirectory(parent, I18nMarker.marktr("Select Folder"), FileChooserHandler.getLastInputDirectory());
    }

    public static File getInputDirectory(Component parent, File directory) {
        return FileChooserHandler.getInputDirectory(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), directory);
    }

    public static File getInputDirectory(Component parent, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, I18nMarker.marktr("Select"), directory);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, I18nMarker.marktr("Select"), directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, approveKey, directory, null);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> dirs = FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 1, 0, false, filter);
        assert (dirs == null || dirs.size() <= 1) : "selected more than one folder: " + dirs;
        if (dirs != null && dirs.size() == 1) {
            return dirs.get(0);
        }
        return null;
    }

    public static File getInputFile() {
        return FileChooserHandler.getInputFile(GUIMediator.getAppFrame());
    }

    public static File getInputFile(Component parent) {
        return FileChooserHandler.getInputFile(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory());
    }

    public static File getInputFile(Component parent, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory(), filter);
    }

    public static File getInputFile(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputFile(parent, titleKey, I18nMarker.marktr("Select"), directory);
    }

    public static File getInputFile(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, titleKey, I18nMarker.marktr("Select"), directory, filter);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> files = FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0, false, filter);
        assert (files == null || files.size() <= 1) : "selected more than one folder: " + files;
        if (files != null && files.size() == 1) {
            return files.get(0);
        }
        return null;
    }

    public static File getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option) {
        List<File> files = FileChooserHandler.getInput(parent, titleKey, approveKey, directory, mode, option, false, null);
        assert (files == null || files.size() <= 1) : "selected more than one folder: " + files;
        if (files != null && files.size() == 1) {
            return files.get(0);
        }
        return null;
    }

    public static List<File> getMultiInputFile() {
        return FileChooserHandler.getMultiInputFile(GUIMediator.getAppFrame());
    }

    public static List<File> getMultiInputFile(Component parent) {
        return FileChooserHandler.getMultiInputFile(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory());
    }

    public static List<File> getMultiInputFile(Component parent, FileFilter filter) {
        return FileChooserHandler.getMultiInputFile(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory(), filter);
    }

    public static List<File> getMultiInputFile(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getMultiInputFile(parent, titleKey, I18nMarker.marktr("Select"), directory);
    }

    public static List<File> getMultiInputFile(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getMultiInputFile(parent, titleKey, I18nMarker.marktr("Select"), directory, filter);
    }

    public static List<File> getMultiInputFile(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getMultiInput(parent, titleKey, approveKey, directory, 0, 0);
    }

    public static List<File> getMultiInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0, true, filter);
    }

    public static List<File> getMultiInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, mode, option, true, null);
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile) {
        return FileChooserHandler.getSaveAsFile(parent, titleKey, suggestedFile, null);
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile, final FileFilter filter) {
        if (OSUtils.isAnyMac()) {
            FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), I18n.tr(titleKey), 1);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setFile(suggestedFile.getName());
            if (filter != null) {
                FilenameFilter f = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return filter.accept(new File(dir, name));
                    }
                };
                dialog.setFilenameFilter(f);
            }
            dialog.setVisible(true);
            String dir = dialog.getDirectory();
            FileChooserHandler.setLastInputDirectory(new File(dir));
            String file = dialog.getFile();
            if (dir != null && file != null) {
                File f = new File(dir, file);
                if (filter != null && !filter.accept(f)) {
                    return null;
                }
                return f;
            }
            return null;
        }
        JFileChooser chooser = FileChooserHandler.getDirectoryChooser(titleKey, null, null, 0, filter);
        chooser.setSelectedFile(suggestedFile);
        int ret = chooser.showSaveDialog(parent);
        File file = chooser.getSelectedFile();
        FileChooserHandler.setLastInputDirectory(file);
        return ret != 0 ? null : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option, boolean allowMultiSelect, final FileFilter filter) {
        if (!OSUtils.isAnyMac()) {
            JFileChooser fileChooser = FileChooserHandler.getDirectoryChooser(titleKey, approveKey, directory, mode, filter);
            fileChooser.setMultiSelectionEnabled(allowMultiSelect);
            boolean dispose = false;
            if (parent == null && (parent = MessageService.getParentComponent()) == null) {
                dispose = true;
                parent = FocusJOptionPane.createFocusComponent();
            }
            try {
                if (fileChooser.showOpenDialog(parent) != option) {
                    List<File> list = null;
                    return list;
                }
            }
            catch (NullPointerException npe) {
                List<File> list = null;
                return list;
            }
            finally {
                if (dispose) {
                    ((JFrame)parent).dispose();
                }
            }
            if (allowMultiSelect) {
                File[] chosen = fileChooser.getSelectedFiles();
                if (chosen.length > 0) {
                    FileChooserHandler.setLastInputDirectory(chosen[0]);
                }
                return Arrays.asList(chosen);
            }
            File chosen = fileChooser.getSelectedFile();
            FileChooserHandler.setLastInputDirectory(chosen);
            return Collections.singletonList(chosen);
        }
        FileDialog dialog = mode == 1 ? MacUtils.getFolderDialog() : new FileDialog((Frame)GUIMediator.getAppFrame(), "");
        dialog.setTitle(I18n.tr(titleKey));
        if (filter != null) {
            FilenameFilter f = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return filter.accept(new File(dir, name));
                }
            };
            dialog.setFilenameFilter(f);
        }
        dialog.setVisible(true);
        String dirStr = dialog.getDirectory();
        String fileStr = dialog.getFile();
        if (dirStr == null || fileStr == null) {
            return null;
        }
        FileChooserHandler.setLastInputDirectory(new File(dirStr));
        File f = new File(dirStr, fileStr);
        if (filter != null && !filter.accept(f)) {
            return null;
        }
        return Collections.singletonList(f);
    }

    private static JFileChooser getDirectoryChooser(String titleKey, String approveKey, File directory, int mode, FileFilter filter) {
        JFileChooser chooser = null;
        if (directory == null) {
            directory = FileChooserHandler.getLastInputDirectory();
        }
        if (directory == null) {
            chooser = new JFileChooser();
        } else {
            try {
                chooser = new JFileChooser(directory);
            }
            catch (NullPointerException e) {
                try {
                    chooser = new JFileChooser(directory);
                }
                catch (NullPointerException npe) {
                    UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                    chooser = new JFileChooser(directory);
                }
            }
            catch (ArrayIndexOutOfBoundsException ie) {
                chooser = new JFileChooser(directory);
            }
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        } else if (mode == 1) {
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }

                public String getDescription() {
                    return I18n.tr("All Folders");
                }
            });
        }
        chooser.setFileSelectionMode(mode);
        String title = I18n.tr(titleKey);
        chooser.setDialogTitle(title);
        if (approveKey != null) {
            String approveButtonText = I18n.tr(approveKey);
            chooser.setApproveButtonText(approveButtonText);
        }
        return chooser;
    }
}

