/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class FirewallUtils {
    private static String name = "LimeWire";

    public static boolean addToFirewall() {
        if (!OSUtils.isWindows()) {
            return false;
        }
        String path = SystemUtils.getRunningPath();
        if (path == null) {
            return false;
        }
        if (!path.equalsIgnoreCase(GUIConstants.LIMEWIRE_EXE_FILE.getAbsolutePath())) {
            return false;
        }
        if (SystemUtils.isProgramListedOnFirewall(path)) {
            return true;
        }
        if (SystemUtils.addProgramToFirewall(path, name)) {
            FirewallUtils.scheduleRemovalOnShutdown();
            return true;
        }
        return false;
    }

    public static void removeFromFirewall() {
        if (!OSUtils.isWindows()) {
            return;
        }
        String path = SystemUtils.getRunningPath();
        if (!path.equalsIgnoreCase(GUIConstants.LIMEWIRE_EXE_FILE.getPath())) {
            return;
        }
        if (SystemUtils.isProgramListedOnFirewall(path)) {
            SystemUtils.removeProgramFromFirewall(path);
        }
    }

    public static boolean isStatuschangeCapable() {
        if (!(OSUtils.isWindows() && SystemUtils.isFirewallPresent() && SystemUtils.isFirewallEnabled())) {
            return false;
        }
        String path = SystemUtils.getRunningPath();
        return path.equalsIgnoreCase(GUIConstants.LIMEWIRE_EXE_FILE.getPath());
    }

    private static void scheduleRemovalOnShutdown() {
        Thread waiter = new Thread("Platform Firewall Waiter"){

            public void run() {
                FirewallUtils.removeFromFirewall();
            }
        };
        GuiCoreMediator.getLifecycleManager().addShutdownItem(waiter);
    }
}

