/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeJFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FocusJOptionPane {
    private static final List<String> visibleDialogs = new ArrayList<String>();

    public static Component createFocusComponent() {
        LimeJFrame frame = new LimeJFrame("LimeWire");
        frame.setUndecorated(true);
        frame.setSize(0, 0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2, screenSize.height / 2);
        frame.setVisible(true);
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        String messageString = message.toString();
        if (visibleDialogs.contains(messageString)) {
            return;
        }
        visibleDialogs.add(messageString);
        boolean dispose = false;
        if (parentComponent == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        try {
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
        }
        finally {
            visibleDialogs.remove(messageString);
            if (dispose) {
                ((JFrame)parentComponent).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        boolean dispose = false;
        if (parentComponent == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        try {
            int n = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
            return n;
        }
        finally {
            if (dispose) {
                ((JFrame)parentComponent).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        boolean dispose = false;
        if (parentComponent == null) {
            parentComponent = FocusJOptionPane.createFocusComponent();
            dispose = true;
        }
        try {
            int n = JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
            return n;
        }
        finally {
            if (dispose) {
                ((JFrame)parentComponent).dispose();
            }
        }
    }
}

