/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Provider;
import com.limegroup.bittorrent.gui.TorrentUploadCanceller;
import com.limegroup.gnutella.bugs.FatalBugManager;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.LimeJFrame;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.TrayPopupMenu;
import com.limegroup.gnutella.gui.UpgradeWindow;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.properties.ResultProperties;
import com.limegroup.gnutella.gui.properties.ResultPropertiesDialog;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.gui.shell.ShellAssociationManager;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SWTBrowserSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.LogUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.Connectable;
import org.limewire.lws.server.LWSConnectionListener;
import org.limewire.service.ErrorService;
import org.limewire.service.Switch;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.VersionUtils;

public final class GUIMediator {
    private static final int STABLE_THRESHOLD = 5;
    private static boolean _displayedMessage;
    private static final String DISCONNECTED_MESSAGE;
    private static GUIMediator _instance;
    private static boolean HAS_DONATED;
    private static final JFrame FRAME;
    private static final JPopupMenu TRAY_MENU;
    private static final List<RefreshListener> REFRESH_LIST;
    private final String APP_TITLE = I18n.tr("LimeWire");
    private static OptionsMediator _optionsMediator;
    private static final Provider<ShellAssociationManager> ASSOCIATION_MANAGER;
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final UploadMediator UPLOAD_MEDIATOR = this.MAIN_FRAME.getUploadMediator();
    private final ConnectionMediator CONNECTION_MEDIATOR = this.MAIN_FRAME.getConnectionMediator();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private static boolean _visibleOnce;
    private static boolean _allowVisible;
    private long lastIdleTime = 0L;

    public static boolean isBrowserCapable() {
        return OSUtils.isWindows();
    }

    private GUIMediator() {
        FRAME.setTitle(this.APP_TITLE);
        _optionsMediator = this.MAIN_FRAME.getOptionsMediator();
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static boolean isConstructed() {
        return _instance != null;
    }

    public void coreInitialized() {
        this.startTimer();
        this.createEventListeners();
    }

    private final void startTimer() {
        RefreshTimer timer = new RefreshTimer();
        timer.startTimer();
    }

    private void createEventListeners() {
        GuiCoreMediator.getLWSManager().addConnectionListener(new LWSConnectionListener(){

            public void connectionChanged(boolean isConnected) {
                GUIMediator.instance().getStatusLine().updateLWSLabel(!isConnected);
            }
        });
        TorrentUploadCanceller.createAndRegister(GuiCoreMediator.getTorrentManager());
    }

    public static final boolean isAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(final boolean visible) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                block17: {
                    try {
                        if (visible) {
                            FRAME.toFront();
                        }
                        FRAME.setVisible(visible);
                    }
                    catch (NullPointerException npe) {
                        if (OSUtils.isNativeThemeWindows()) {
                            try {
                                if (ThemeSettings.isWindowsTheme()) {
                                    ThemeMediator.changeTheme(ThemeSettings.LIMEWIRE_THEME_FILE);
                                    try {
                                        if (visible) {
                                            FRAME.toFront();
                                        }
                                        FRAME.setVisible(visible);
                                    }
                                    catch (NullPointerException npe2) {
                                        GUIMediator.showError(I18n.tr("LimeWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing LimeWire's Windows Compatibility. Right-click on the LimeWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart LimeWire."));
                                        System.exit(0);
                                    }
                                }
                                GUIMediator.showError(I18n.tr("LimeWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing LimeWire's Windows Compatibility. Right-click on the LimeWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart LimeWire."));
                                System.exit(0);
                            }
                            catch (Throwable t) {
                                if (visible) {
                                    FatalBugManager.handleFatalBug(npe);
                                    break block17;
                                }
                                ErrorService.error(npe);
                            }
                        }
                        if (visible) {
                            FatalBugManager.handleFatalBug(npe);
                        } else {
                            ErrorService.error(npe);
                        }
                    }
                    catch (Throwable t) {
                        if (visible) {
                            FatalBugManager.handleFatalBug(t);
                        }
                        ErrorService.error(t);
                    }
                }
                if (visible) {
                    SearchMediator.requestSearchFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FRAME.getContentPane().invalidate();
                            FRAME.getContentPane().validate();
                        }
                    });
                }
                if (visible && !_visibleOnce) {
                    GUIMediator.showDialogsForFirstVisibility();
                    _visibleOnce = true;
                }
            }
        });
    }

    public static void showProperties(TableLine line) {
        ResultPropertiesDialog dialog = new ResultPropertiesDialog(new ResultProperties(line));
        GUIUtils.centerOnScreen(dialog.getDialog());
        GUIUtils.addHideAction(dialog.getDialog());
        dialog.getDialog().setVisible(true);
    }

    private static final void showDialogsForFirstVisibility() {
        JDialog dialog;
        if (_displayedMessage) {
            return;
        }
        _displayedMessage = true;
        GUIMediator.getAssociationManager().checkAndGrab(true);
        if (!GUIMediator.hasDonated()) {
            UpgradeWindow.showProDialog();
        }
        if (TipOfTheDayMessages.hasLocalizedMessages() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance();
            ThreadExecutor.startThread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TipOfTheDayMediator.instance().displayTipWindow();
                        }
                    });
                }
            }, "TOTD");
        }
        if ((dialog = JavaVersionNotice.getUpgradeRecommendedDialog(VersionUtils.getJavaVersion())) != null) {
            dialog.setVisible(true);
        }
    }

    public static boolean showFirstDownloadDialog() {
        return DialogOption.YES == GUIMediator.showYesNoCancelMessage(I18n.tr("LimeWire is unable to find a license for this file. Download the file anyway?\n\nPlease note: LimeWire cannot monitor or control the content of the Gnutella network. Please respect your local copyright laws."), QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING);
    }

    public static void closeStartupDialogs() {
        if (SplashWindow.instance().isShowing()) {
            SplashWindow.instance().toBack();
        }
        if (TipOfTheDayMediator.isConstructed()) {
            TipOfTheDayMediator.instance().hide();
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static final JFrame getAppFrame() {
        return FRAME;
    }

    public static final JPopupMenu getTrayMenu() {
        return TRAY_MENU;
    }

    public StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    public final void refreshGUI() {
        for (int i = 0; i < REFRESH_LIST.size(); ++i) {
            try {
                REFRESH_LIST.get(i).refresh();
                continue;
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
        int sharedFiles = GuiCoreMediator.getFileManager().getNumFiles();
        int pendingShare = GuiCoreMediator.getFileManager().getNumPendingFiles();
        int quality = this.getConnectionQuality();
        this.STATUS_LINE.setStatistics(sharedFiles, pendingShare);
        if (quality != 0 && quality != 1) {
            GUIMediator.hideDisposableMessage(DISCONNECTED_MESSAGE);
        }
        this.updateConnectionUI(quality);
    }

    public int getConnectionQuality() {
        int status;
        int stable = GuiCoreMediator.getConnectionServices().countConnectionsWithNMessages(5);
        if (stable == 0) {
            int initializing = this.CONNECTION_MEDIATOR.getConnectingCount();
            int connections = GuiCoreMediator.getConnectionServices().getNumInitializedConnections();
            status = initializing == 0 && connections == 0 ? (!GuiCoreMediator.getConnectionServices().isConnecting() ? 0 : 1) : (connections == 0 ? 1 : 2);
        } else if (GuiCoreMediator.getConnectionManager().isConnectionIdle()) {
            this.lastIdleTime = System.currentTimeMillis();
            status = 7;
        } else {
            double percent;
            int preferred = GuiCoreMediator.getConnectionManager().getPreferredConnectionCount();
            if (LimeWireUtils.isPro()) {
                preferred -= 2;
            }
            if (GuiCoreMediator.getConnectionServices().isSupernode()) {
                preferred -= 5;
            }
            status = (percent = (double)stable / (double)(preferred = Math.max(1, preferred))) <= 0.25 ? 2 : (percent <= 0.5 ? 3 : (percent <= 0.75 ? 4 : (percent <= 1.0 ? 5 : 6)));
        }
        switch (status) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                long now = System.currentTimeMillis();
                if (now >= this.lastIdleTime + 15000L) break;
                status = 8;
            }
        }
        return status;
    }

    public void setOptionsVisible(boolean visible) {
        if (_optionsMediator == null) {
            return;
        }
        _optionsMediator.setOptionsVisible(visible);
    }

    public void setOptionsVisible(boolean visible, String key) {
        if (_optionsMediator == null) {
            return;
        }
        _optionsMediator.setOptionsVisible(visible, key);
    }

    public static boolean isOptionsVisible() {
        if (_optionsMediator == null) {
            return false;
        }
        return _optionsMediator.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (_optionsMediator == null) {
            return null;
        }
        return _optionsMediator.getMainOptionsComponent();
    }

    public static ShellAssociationManager getAssociationManager() {
        return ASSOCIATION_MANAGER.get();
    }

    public void setWindow(Tabs tab) {
        this.MAIN_FRAME.setSelectedTab(tab);
    }

    public void updateTabIcon(Tabs tab) {
        this.MAIN_FRAME.updateTabIcon(tab);
    }

    public void clearConnections() {
        this.CONNECTION_MEDIATOR.clearConnections();
    }

    private void updateConnectionUI(int quality) {
        boolean connected;
        this.STATUS_LINE.setConnectionQuality(quality);
        boolean bl = connected = quality != 0;
        if (!connected) {
            this.setSearching(false);
        }
    }

    public int getTotalUploads() {
        return this.UPLOAD_MEDIATOR.getTotalUploads();
    }

    public int getCurrentUploads() {
        return this.UPLOAD_MEDIATOR.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this.DOWNLOAD_MEDIATOR.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.DOWNLOAD_MEDIATOR.getCurrentDownloads();
    }

    public final void openTorrent(File torrentFile) {
        this.DOWNLOAD_MEDIATOR.openTorrent(torrentFile);
        this.setWindow(Tabs.SEARCH);
    }

    public final void openTorrentURI(URI torrentURI) {
        this.DOWNLOAD_MEDIATOR.openTorrentURI(torrentURI);
        this.setWindow(Tabs.SEARCH);
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public static PlaylistMediator getPlayList() {
        return MainFrame.getPlaylistMediator();
    }

    public static boolean isPlaylistVisible() {
        if (!GUIMediator.isConstructed()) {
            return PlayerSettings.PLAYER_ENABLED.getValue();
        }
        return GUIMediator.getPlayList() != null && PlayerSettings.PLAYER_ENABLED.getValue();
    }

    public static void startupHidden() {
        GUIMediator.showTrayIcon();
        if (OSUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    public static void allowVisibility() {
        if (!_allowVisible && OSUtils.isAnyMac()) {
            MacEventHandler.instance().enablePreferences();
        }
        _allowVisible = true;
    }

    public void loadFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread awt = Thread.currentThread();
                awt.setPriority(awt.getPriority() + 1);
                GUIMediator.this.STATUS_LINE.loadFinished();
            }
        });
    }

    public static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    public static void hideView() {
        FRAME.setState(1);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            GUIMediator.setAppVisible(false);
        }
    }

    public static void restoreView() {
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boolean doHack = false;
            if (!_visibleOnce) {
                doHack = true;
            }
            GUIMediator.setAppVisible(true);
            if (ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                GUIMediator.showTrayIcon();
            } else {
                GUIMediator.hideTrayIcon();
            }
            if (doHack) {
                GUIMediator.restoreView();
            }
        }
        Finalizer.cancelShutdown();
        FRAME.setState(0);
    }

    public static void close(boolean fromFrame) {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (OSUtils.supportsTray() && !ResourceManager.instance().isTrayIconAvailable()) {
                GUIMediator.shutdownAfterTransfers();
            } else {
                GUIMediator.applyWindowSettings();
                GUIMediator.showTrayIcon();
                GUIMediator.hideView();
            }
        } else if (OSUtils.isMacOSX() && fromFrame) {
            GUIMediator.setAppVisible(false);
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    public static void flagUpdate(String toExecute) {
        Finalizer.flagUpdate(toExecute);
    }

    public static final void showAboutWindow() {
        new AboutWindow().showDialog();
    }

    public static void showTrayIcon() {
        NotifyUserProxy.instance().showTrayIcon();
    }

    public static void hideTrayIcon() {
        NotifyUserProxy.instance().hideTrayIcon();
    }

    public static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            if ((GUIMediator.getAppFrame().getExtendedState() & 6) == 6) {
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            } else {
                Dimension dim = GUIMediator.getAppSize();
                if (dim.height > 100 && dim.width > 100) {
                    Point loc = GUIMediator.getAppLocation();
                    ApplicationSettings.APP_WIDTH.setValue(dim.width);
                    ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                    ApplicationSettings.WINDOW_X.setValue(loc.x);
                    ApplicationSettings.WINDOW_Y.setValue(loc.y);
                }
            }
        }
    }

    public static final ImageIcon getThemeImage(String name) {
        return ResourceManager.getThemeImage(name);
    }

    public static final ImageIcon getImageFromResourcePath(String loc) {
        return ResourceManager.getImageFromResourcePath(loc);
    }

    public static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURLResource(FILE_NAME);
    }

    public static void resetLocale() {
        ResourceManager.resetLocaleOptions();
        GUIUtils.resetLocale();
    }

    public static final ResourceBundle getXMLResourceBundle(String schemaname) {
        return ResourceManager.getXMLResourceBundle(schemaname);
    }

    public static final DialogOption showYesNoMessage(String message, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, defaultOption);
    }

    public static final DialogOption showYesNoMessage(String message, IntSetting defaultValue, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, defaultValue, defaultOption);
    }

    public static final DialogOption showYesNoTitledMessage(String message, String title, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, title, defaultOption);
    }

    public static final int showConfirmListMessage(String message, Object[] listModel, int messageType, ListCellRenderer listRenderer) {
        return MessageService.instance().showConfirmListMessage(message, listModel, messageType, listRenderer);
    }

    public static final DialogOption showYesNoOtherMessage(String message, IntSetting defaultValue, String otherOptions) {
        return MessageService.instance().showYesNoOtherMessage(message, defaultValue, otherOptions);
    }

    public static final DialogOption showYesNoCancelMessage(String message) {
        return MessageService.instance().showYesNoCancelMessage(message);
    }

    public static final DialogOption showYesNoCancelMessage(String message, IntSetting defaultValue) {
        return MessageService.instance().showYesNoCancelMessage(message, defaultValue);
    }

    public static final void showMessage(String messageKey) {
        MessageService.instance().showMessage(messageKey);
    }

    public static final void showMessage(String message, Switch ignore) {
        MessageService.instance().showMessage(message, ignore);
    }

    public static final void showDisposableMessage(String messageKey, String message, Switch ignore, int msgType) {
        MessageService.instance().showDisposableMessage(messageKey, message, ignore, msgType);
    }

    public static final void hideDisposableMessage(String messageKey) {
        MessageService.instance().hideDisposableMessage(messageKey);
    }

    public static final void showConfirmMessage(String message) {
        MessageService.instance().showConfirmMessage(message);
    }

    public static final void showConfirmMessage(String message, Switch ignore) {
        MessageService.instance().showConfirmMessage(message, ignore);
    }

    public static final void showError(String message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(message);
    }

    public static final void showError(String message, Switch ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(message, ignore);
    }

    public static final void showWarning(String message, Switch ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(message, ignore);
    }

    public static final void showWarning(String message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(message);
    }

    public static final int openURL(String url) {
        try {
            return Launcher.openURL(url);
        }
        catch (IOException ioe) {
            GUIMediator.showError(I18n.tr("LimeWire could not locate your web browser to display the following webpage: {0}.", url));
            return -1;
        }
    }

    public static final void launchFile(File file) {
        try {
            Launcher.launchFile(file);
        }
        catch (SecurityException se) {
            GUIMediator.showError(I18n.tr("LimeWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException e) {
            GUIMediator.showError(I18n.tr("LimeWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(e.getCommand(), " ")));
        }
        catch (IOException e) {
            GUIMediator.showError(I18n.tr("LimeWire could not launch the specified file."));
        }
    }

    public static final void launchExplorer(File file) {
        try {
            Launcher.launchExplorer(file);
        }
        catch (SecurityException e) {
            GUIMediator.showError(I18n.tr("LimeWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException e) {
            GUIMediator.showError(I18n.tr("LimeWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(e.getCommand(), " ")));
        }
        catch (IOException e) {
            GUIMediator.showError(I18n.tr("LimeWire could not launch the specified file."));
        }
    }

    public static final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    public static final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }

    public void connect() {
        GuiCoreMediator.getConnectionServices().connect();
        GuiCoreMediator.getDHTManager().setEnabled(true);
    }

    public void disconnect() {
        GuiCoreMediator.getConnectionServices().disconnect();
        GuiCoreMediator.getDHTManager().setEnabled(false);
    }

    public static void disconnected() {
        GUIMediator.showDisposableMessage(DISCONNECTED_MESSAGE, I18n.tr("Your machine does not appear to have an active Internet connection or a firewall is blocking LimeWire from accessing the internet. LimeWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu."), QuestionsHandler.NO_INTERNET_RETRYING, 0);
    }

    public static boolean hasDonated() {
        return HAS_DONATED;
    }

    public void setTabVisible(Tabs tab, boolean visible) {
        this.MAIN_FRAME.setTabVisible(tab, visible);
    }

    public static void setSplashScreenString(String text) {
        if (!_allowVisible) {
            SplashWindow.instance().setStatusText(text);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().STATUS_LINE.setStatusText(text);
        }
    }

    public static Point getScreenCenterPoint(Component comp) {
        Dimension COMPONENT_DIMENSION = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width, COMPONENT_DIMENSION.width);
        int appHeight = Math.min(screenSize.height - 40, COMPONENT_DIMENSION.height);
        return new Point((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
    }

    public static void addFinalizeListener(FinalizeListener fin) {
        Finalizer.addFinalizeListener(fin);
    }

    public void setSearching(boolean searching) {
        this.MAIN_FRAME.setSearching(searching);
    }

    public static void addRefreshListener(RefreshListener listener) {
        if (!REFRESH_LIST.contains(listener)) {
            REFRESH_LIST.add(listener);
        }
    }

    public static void removeRefreshListener(RefreshListener listener) {
        REFRESH_LIST.remove(listener);
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public static boolean isEnglishLocale() {
        return LanguageUtils.isEnglishLocale(GUIMediator.getLocale());
    }

    public void launchAudio(PlayListItem song) {
        this.launchAudio(song, true);
    }

    public void launchAudio(PlayListItem song, boolean addSongToPlaylist) {
        if (addSongToPlaylist) {
            PlaylistMediator playList = PlaylistMediator.getInstance();
            playList.add(song, playList.getSize());
            playList.setSelectedIndex(song);
        }
        MediaPlayerComponent mediaPlayer = MediaPlayerComponent.getInstance();
        mediaPlayer.loadSong(song, !addSongToPlaylist);
    }

    public void showUpdateNotification(final UpdateInformation info) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                GUIMediator.this.STATUS_LINE.showUpdatePanel(true, info);
            }
        });
    }

    public byte[] triggerSearch(String query) {
        this.MAIN_FRAME.setSelectedTab(Tabs.SEARCH);
        return SearchMediator.triggerSearch(query);
    }

    public void buttonViewChanged() {
        IconManager.instance().wipeButtonIconCache();
        this.updateButtonView(FRAME);
    }

    private void updateButtonView(Component c) {
        if (c instanceof IconButton) {
            ((IconButton)c).updateUI();
        }
        Component[] children = null;
        if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.updateButtonView(children[i]);
            }
        }
    }

    public void doBrowseHost(Connectable host) {
        this.MAIN_FRAME.setSelectedTab(Tabs.SEARCH);
        SearchMediator.doBrowseHost(host, null);
    }

    public static void safeInvokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                ErrorService.error(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void safeInvokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setPlayerEnabled(boolean value) {
        if (value == PlayerSettings.PLAYER_ENABLED.getValue()) {
            return;
        }
        PlayerSettings.PLAYER_ENABLED.setValue(value);
        this.getStatusLine().refresh();
        this.LIBRARY_MEDIATOR.setPlayerEnabled(value);
        LibraryPlayListTab.setPlayerEnabled(value);
    }

    public void setFrameCursor(Cursor cursor) {
        FRAME.setCursor(cursor);
    }

    public static ChatFrame createChat(String host, int port) {
        InstantMessenger chatter = GuiCoreMediator.getChatManager().createConnection(host, port);
        ChatFrame frame = ChatUIManager.instance().acceptChat(chatter);
        chatter.start();
        return frame;
    }

    static {
        DISCONNECTED_MESSAGE = I18nMarker.marktr("Your machine does not appear to have an active Internet connection or a firewall is blocking LimeWire from accessing the internet. LimeWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu.");
        _instance = null;
        HAS_DONATED = false;
        FRAME = new LimeJFrame();
        TRAY_MENU = new TrayPopupMenu();
        REFRESH_LIST = new ArrayList<RefreshListener>();
        ASSOCIATION_MANAGER = new AbstractLazySingletonProvider<ShellAssociationManager>(){

            @Override
            protected ShellAssociationManager createObject() {
                return new ShellAssociationManager(LimeAssociations.getSupportedAssociations());
            }
        };
        _visibleOnce = false;
        _allowVisible = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tabs {
        SEARCH(I18n.tr("&Search")),
        MONITOR(I18n.tr("&Monitor"), ApplicationSettings.MONITOR_VIEW_ENABLED),
        CONNECTION(I18n.tr("&Connections"), ApplicationSettings.CONNECTION_VIEW_ENABLED),
        LIBRARY(I18n.tr("&Library"), ApplicationSettings.LIBRARY_VIEW_ENABLED),
        CONSOLE(I18n.tr("C&onsole"), ApplicationSettings.CONSOLE_VIEW_ENABLED),
        LOGGING(I18n.tr("Lo&gging"), ApplicationSettings.LOGGING_VIEW_ENABLED),
        LWS(SWTBrowserSettings.getTitleSetting(), ApplicationSettings.SWT_BROWSER_VIEW_ENABLED);

        private final Action navAction;
        private String name;
        private final BooleanSetting visibleSetting;
        private final PropertyChangeSupport propertyChangeSupport;

        private Tabs(String name) {
            this(name, null);
        }

        private Tabs(String nameWithAmpers, BooleanSetting visibleSetting) {
            this.name = GUIUtils.stripAmpersand(nameWithAmpers);
            this.navAction = new NavigationAction(nameWithAmpers, I18n.tr("Display the {0} Screen", this.name));
            this.visibleSetting = visibleSetting;
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }

        private Tabs(StringSetting nameSetting, BooleanSetting visibleSetting) {
            this(nameSetting.getValue(), visibleSetting);
            nameSetting.addSettingListener(new SettingListener(){

                public void settingChanged(final SettingEvent evt) {
                    if (evt.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Tabs.this.setName(evt.getSetting().getValueAsString());
                            }
                        });
                    }
                }
            });
        }

        void setName(String newName) {
            String oldName = this.name;
            this.name = GUIUtils.stripAmpersand(newName);
            this.navAction.putValue("Name", newName);
            this.navAction.putValue("LongDescription", I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport.firePropertyChange("name", oldName, this.name);
        }

        void setEnabled(boolean enabled) {
            this.navAction.setEnabled(enabled);
        }

        public Action getNavigationAction() {
            return this.navAction;
        }

        public boolean isViewEnabled() {
            if (this.visibleSetting == null) {
                throw new IllegalStateException("Should not be called on " + this.getName() + " which is a non-optional tab");
            }
            return this.visibleSetting.getValue();
        }

        public String getName() {
            return this.name;
        }

        public static Tabs[] getOptionalTabs() {
            if (LogUtils.isLog4JAvailable()) {
                if (GUIMediator.isBrowserCapable()) {
                    return new Tabs[]{MONITOR, CONNECTION, LIBRARY, CONSOLE, LOGGING, LWS};
                }
                return new Tabs[]{MONITOR, CONNECTION, LIBRARY, CONSOLE, LOGGING};
            }
            if (GUIMediator.isBrowserCapable()) {
                return new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING, LWS};
            }
            return new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING};
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        private class NavigationAction
        extends AbstractAction {
            public NavigationAction(String name, String description) {
                super(name);
                this.putValue("LongDescription", description);
            }

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().setWindow(Tabs.this);
            }
        }
    }
}

