/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private String message;
    private String iconName;
    private boolean initialized;
    private PropertyChangeListener listener = null;
    private boolean iconOnly;

    public IconButton(String text, String iconName) {
        this.setRolloverEnabled(true);
        this.iconName = iconName;
        this.message = text;
        this.initialized = true;
        this.updateButton();
    }

    public IconButton(String iconName) {
        this.setRolloverEnabled(true);
        this.iconName = iconName;
        this.message = "";
        this.iconOnly = true;
        this.initialized = true;
        this.updateButton();
    }

    public IconButton(Action action) {
        super(action);
        this.setRolloverEnabled(true);
        this.initialized = true;
        this.updateButton();
    }

    public void setAction(Action a) {
        Action oldAction = this.getAction();
        if (oldAction != null) {
            oldAction.removePropertyChangeListener(this.getListener());
        }
        super.setAction(a);
        this.setButtonFromAction(a);
        a.addPropertyChangeListener(this.getListener());
    }

    private void setButtonFromAction(Action action) {
        this.iconName = (String)action.getValue("LimeIconName");
        this.message = (String)action.getValue("LimeShortName");
        if (this.message == null) {
            this.message = (String)action.getValue("Name");
        }
        this.updateButton();
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    IconButton.this.setButtonFromAction((Action)evt.getSource());
                }
            };
        }
        return this.listener;
    }

    public void updateUI() {
        super.updateUI();
        this.updateButton();
    }

    public void setText(String text) {
        this.message = text;
        this.updateButton();
    }

    private void updateButton() {
        if (!this.initialized) {
            return;
        }
        Icon icon = IconManager.instance().getIconForButton(this.iconName);
        if (icon == null) {
            super.setText(this.message);
            this.setVerticalTextPosition(0);
            this.setHorizontalTextPosition(0);
            this.setContentAreaFilled(true);
            this.setBorderPainted(true);
            this.setOpaque(true);
        } else {
            this.setIcon(icon);
            Icon rollover = IconManager.instance().getRolloverIconForButton(this.iconName);
            this.setRolloverIcon(rollover);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setOpaque(false);
            if (!this.iconOnly && UISettings.TEXT_WITH_ICONS.getValue() && this.message != null && this.message.length() > 0) {
                super.setText(this.message);
                this.setPreferredSize(null);
            } else {
                super.setText(null);
                int height = icon.getIconHeight();
                int width = icon.getIconWidth();
                if (this.message == null || this.message.length() > 0) {
                    height += 15;
                    width += 15;
                }
                this.setPreferredSize(new Dimension(height, width));
            }
        }
    }
}

