/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BasicFileIconController;
import com.limegroup.gnutella.gui.ButtonIconController;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.NativeFileIconController;
import java.io.File;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.util.OSUtils;

public class IconManager {
    private static volatile IconManager INSTANCE;
    private FileIconController fileController;
    private ButtonIconController buttonController = new ButtonIconController();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IconManager instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<IconManager> clazz = IconManager.class;
        synchronized (IconManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new IconManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private IconManager() {
        this.fileController = new BasicFileIconController();
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            ThreadExecutor.startThread(new Runnable(){

                public void run() {
                    final NativeFileIconController newController = new NativeFileIconController();
                    if (newController.isValid()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                IconManager.this.fileController = newController;
                            }
                        });
                    }
                }
            }, "NativeFileIconLoader");
        }
    }

    public Icon getIconForFile(File f) {
        this.validate();
        return this.fileController.getIconForFile(f);
    }

    public Icon getIconForExtension(String ext) {
        this.validate();
        return this.fileController.getIconForExtension(ext);
    }

    public boolean isIconForFileAvailable(File f) {
        this.validate();
        return this.fileController.isIconForFileAvailable(f);
    }

    public void wipeButtonIconCache() {
        this.buttonController.wipeButtonIconCache();
    }

    public Icon getIconForButton(String buttonName) {
        return this.buttonController.getIconForButton(buttonName);
    }

    public Icon getRolloverIconForButton(String buttonName) {
        return this.buttonController.getRolloverIconForButton(buttonName);
    }

    private void validate() {
        if (!this.fileController.isValid()) {
            this.fileController = new BasicFileIconController();
        }
    }
}

