/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.limegroup.gnutella.ActiveLimeWireCheck;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.DeadlockSupport;
import com.limegroup.gnutella.gui.DefaultErrorCatcher;
import com.limegroup.gnutella.gui.ErrorHandler;
import com.limegroup.gnutella.gui.FileManagerWarningManager;
import com.limegroup.gnutella.gui.FirewallUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GURLHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LimeWireGUI;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MessageHandler;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SettingsWarningManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.LogUtils;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;
import org.limewire.util.Stopwatch;
import org.limewire.util.SystemUtils;

public final class Initializer {
    private final Log LOG;
    private final long EXPIRATION_DATE = Long.MAX_VALUE;
    private volatile boolean isStartup = false;
    private long startMemory;
    private final Stopwatch stopwatch;

    Initializer() {
        if (LogUtils.isLog4JAvailable()) {
            System.getProperties().remove("org.apache.commons.logging.Log");
        }
        this.LOG = LogFactory.getLog(Initializer.class);
        if (this.LOG.isTraceEnabled()) {
            this.startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("START Initializer, using: " + this.startMemory + " memory");
        }
        this.stopwatch = new Stopwatch(this.LOG);
    }

    void initialize(String[] args, Frame awtSplash) throws Throwable {
        this.preinit();
        this.setupCallbacksAndListeners();
        this.validateStartup(args);
        LimeWireGUI limewireGUI = this.createLimeWire();
        LimeWireCore limeWireCore = limewireGUI.getLimeWireCore();
        this.glueCore(limeWireCore);
        this.validateEarlyCore(limeWireCore);
        this.runExternalChecks(limeWireCore, args);
        DeadlockSupport.startDeadlockMonitoring();
        this.stopwatch.resetAndLog("Start deadlock monitor");
        this.installProperties();
        this.installResources();
        SetupManager setupManager = new SetupManager();
        this.stopwatch.resetAndLog("construct SetupManager");
        this.switchSplashes(awtSplash);
        this.startEarlyCore(setupManager, limeWireCore);
        this.initializeEarlyUI();
        this.startSetupManager(setupManager);
        this.validateSaveDirectory();
        this.loadUI();
        this.loadTrayAndNotifications();
        this.hideSplashAndShowUI();
        this.loadLateTasksForUI();
        this.installListenersForUI(limeWireCore);
        this.startCore(limeWireCore);
        this.runQueuedRequests(limeWireCore);
        this.startDAAP();
        this.postinit();
    }

    private void preinit() {
        try {
            LimeCoreGlue.preinstall();
            this.stopwatch.resetAndLog("Preinstall");
        }
        catch (LimeCoreGlue.InstallFailedException ife) {
            this.failPreferencesPermissions();
        }
    }

    private void setupCallbacksAndListeners() {
        ErrorService.setErrorCallback(new ErrorHandler());
        this.stopwatch.resetAndLog("ErrorHandler install");
        MessageService.setCallback(new MessageHandler());
        this.stopwatch.resetAndLog("MessageHandler install");
        DefaultErrorCatcher.install();
        this.stopwatch.resetAndLog("DefaultErrorCatcher install");
        if (OSUtils.isMacOSX()) {
            SystemUtils.setOpenFileLimit(1024);
            this.stopwatch.resetAndLog("Open file limit raise");
            if (ThemeSettings.isBrushedMetalTheme()) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            MacEventHandler.instance();
            this.stopwatch.resetAndLog("MacEventHandler instance");
        }
    }

    private void validateStartup(String[] args) {
        if (System.currentTimeMillis() > Long.MAX_VALUE) {
            this.failExpired();
        }
        if (args.length >= 2 && "-pmf".equals(args[0])) {
            PackagedMediaFileLauncher.launchFile(args[1], false);
            System.exit(0);
        }
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            this.stopwatch.reset();
            Thread.yield();
            this.stopwatch.resetAndLog("Thread yield");
        }
        if (args.length >= 1 && "-startup".equals(args[0])) {
            this.isStartup = true;
        }
        if (this.isStartup) {
            args = null;
            if (!StartupSettings.RUN_ON_STARTUP.getValue()) {
                System.exit(0);
            }
        }
        ActiveLimeWireCheck activeLimeWireCheck = new ActiveLimeWireCheck(args, StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue());
        this.stopwatch.resetAndLog("Create ActiveLimeWireCheck");
        if (activeLimeWireCheck.checkForActiveLimeWire()) {
            System.exit(0);
        }
        this.stopwatch.resetAndLog("Run ActiveLimeWireCheck");
    }

    private LimeWireGUI createLimeWire() {
        this.stopwatch.reset();
        Injector injector = Guice.createInjector(new LimeWireModule());
        this.stopwatch.resetAndLog("Create injector");
        LimeWireGUI limeWireGUI = injector.getInstance(LimeWireGUI.class);
        this.stopwatch.resetAndLog("Get LimeWireGUI");
        return limeWireGUI;
    }

    private void glueCore(LimeWireCore limeWireCore) {
        limeWireCore.getLimeCoreGlue().install();
        this.stopwatch.resetAndLog("Install core glue");
    }

    private void validateEarlyCore(LimeWireCore limeWireCore) {
        if (!limeWireCore.getNIODispatcher().isRunning()) {
            this.failInternetBlocked();
        }
        this.stopwatch.resetAndLog("Check for NIO dispatcher");
    }

    private void runExternalChecks(LimeWireCore limeWireCore, String[] args) {
        ExternalControl externalControl = limeWireCore.getExternalControl();
        this.stopwatch.resetAndLog("Get externalControl");
        if (OSUtils.isMacOSX()) {
            GURLHandler.getInstance().enable(externalControl);
            this.stopwatch.resetAndLog("Enable GURL");
            MacEventHandler.instance().enable(externalControl, this);
            this.stopwatch.resetAndLog("Enable macEventHandler");
        }
        if (args.length > 0 && !args[0].equals("-startup")) {
            String arg = ExternalControl.preprocessArgs(args);
            this.stopwatch.resetAndLog("Preprocess args");
            externalControl.enqueueControlRequest(arg);
            this.stopwatch.resetAndLog("Enqueue control req");
        }
    }

    private void installProperties() {
        System.setProperty("http.agent", LimeWireUtils.getHttpServer());
        this.stopwatch.resetAndLog("set system properties");
        if (OSUtils.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.stopwatch.resetAndLog("set OSX properties");
        }
    }

    private void installResources() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                Initializer.this.stopwatch.resetAndLog("wait for event queue");
                ResourceManager.instance();
                Initializer.this.stopwatch.resetAndLog("ResourceManager instance");
            }
        });
        this.stopwatch.resetAndLog("come back from evt queue");
    }

    private void startEarlyCore(SetupManager setupManager, LimeWireCore limeWireCore) {
        boolean inFirewallException = FirewallUtils.addToFirewall();
        this.stopwatch.resetAndLog("add firewall exception");
        if (!inFirewallException && !setupManager.shouldShowFirewallWindow()) {
            limeWireCore.getLifecycleManager().loadBackgroundTasks();
            this.stopwatch.resetAndLog("load background tasks");
        }
    }

    private void switchSplashes(Frame awtSplash) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                if (!Initializer.this.isStartup) {
                    SplashWindow.instance().begin();
                    Initializer.this.stopwatch.resetAndLog("begin splash window");
                }
            }
        });
        if (awtSplash != null) {
            awtSplash.dispose();
            this.stopwatch.resetAndLog("dispose AWT splash");
        }
    }

    private void initializeEarlyUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading HTML Engine..."));
        this.stopwatch.resetAndLog("update splash for HTML engine");
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                Initializer.this.stopwatch.resetAndLog("enter evt queue");
                JLabel label = new JLabel();
                label.setFont(null);
                label.setForeground(null);
                BasicHTML.createHTMLView(label, "<html>.</html>");
                Initializer.this.stopwatch.resetAndLog("create HTML view");
            }
        });
        this.stopwatch.resetAndLog("return from evt queue");
        BugManager.instance();
        this.stopwatch.resetAndLog("BugManager instance");
    }

    private void startSetupManager(final SetupManager setupManager) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                Initializer.this.stopwatch.resetAndLog("event evt queue");
                setupManager.createIfNeeded();
                Initializer.this.stopwatch.resetAndLog("create setupManager if needed");
            }
        });
        this.stopwatch.resetAndLog("return from evt queue");
    }

    private void validateSaveDirectory() {
        SaveDirectoryHandler.validateSaveDirectoryAndPromptForNewOne();
        this.stopwatch.resetAndLog("check save directory validity");
    }

    private void loadUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading User Interface..."));
        this.stopwatch.resetAndLog("update splash for UI");
        if (OSUtils.isMacOSX()) {
            GUIMediator.instance();
            this.stopwatch.resetAndLog("OSX GUIMediator instance");
        } else {
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    Initializer.this.stopwatch.resetAndLog("enter evt queue");
                    GUIMediator.instance();
                    Initializer.this.stopwatch.resetAndLog("GUImediator instance");
                }
            });
            this.stopwatch.resetAndLog("return from evt queue");
        }
        GUIMediator.setSplashScreenString(I18n.tr("Loading Core Components..."));
        this.stopwatch.resetAndLog("update splash for core");
    }

    private void loadTrayAndNotifications() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                Initializer.this.stopwatch.resetAndLog("enter evt queue");
                NotifyUserProxy.instance();
                Initializer.this.stopwatch.resetAndLog("NotifYUserProxy instance");
                if (!ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                    NotifyUserProxy.instance().hideTrayIcon();
                }
                SettingsWarningManager.checkTemporaryDirectoryUsage();
                SettingsWarningManager.checkSettingsLoadSaveFailure();
                Initializer.this.stopwatch.resetAndLog("end notify runner");
            }
        });
        this.stopwatch.resetAndLog("return from evt queue");
    }

    private void hideSplashAndShowUI() {
        if (!this.isStartup) {
            SplashWindow.instance().dispose();
            this.stopwatch.resetAndLog("hide splash");
        }
        GUIMediator.allowVisibility();
        this.stopwatch.resetAndLog("allow viz");
        if (!this.isStartup) {
            GUIMediator.setAppVisible(true);
            this.stopwatch.resetAndLog("set app visible TRUE");
        } else {
            GUIMediator.startupHidden();
            this.stopwatch.resetAndLog("start hidden");
        }
    }

    private void loadLateTasksForUI() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Icons..."));
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                IconManager.instance();
            }
        });
        this.stopwatch.resetAndLog("IconManager instance");
        GUIMediator.setSplashScreenString(I18n.tr("Loading Internationalization Support..."));
        I18NConvert.instance();
        this.stopwatch.resetAndLog("I18nConvert instance");
    }

    private void installListenersForUI(LimeWireCore limeWireCore) {
        limeWireCore.getFileManager().addFileEventListener(new FileManagerWarningManager(NotifyUserProxy.instance()));
    }

    private void startCore(LimeWireCore limeWireCore) {
        limeWireCore.getLifecycleManager().start();
        this.stopwatch.resetAndLog("lifecycle manager start");
        if (!ConnectionSettings.DISABLE_UPNP.getValue()) {
            limeWireCore.getUPnPManager().start();
            this.stopwatch.resetAndLog("start UPnPManager");
        }
        GUIMediator.instance().coreInitialized();
        this.stopwatch.resetAndLog("core initialized");
    }

    private void runQueuedRequests(LimeWireCore limeWireCore) {
        limeWireCore.getExternalControl().runQueuedControlRequest();
        this.stopwatch.resetAndLog("run queued control req");
    }

    private void startDAAP() {
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            try {
                GUIMediator.setSplashScreenString(I18n.tr("Loading Digital Audio Access Protocol..."));
                DaapManager.instance().start();
                this.stopwatch.resetAndLog("daap start");
                DaapManager.instance().init();
                this.stopwatch.resetAndLog("daap init");
            }
            catch (IOException err) {
                GUIMediator.showError(I18n.tr("LimeWire was unable to start the Digital Audio Access Protocol Service (for sharing files in iTunes). This feature will be turned off. You can turn it back on in options, under iTunes -> Sharing."));
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
        }
    }

    private void postinit() {
        GUIMediator.instance().loadFinished();
        this.stopwatch.resetAndLog("load finished");
        if (OSUtils.isMacOSX()) {
            UIManager.put("ProgressBar.repaintInterval", new Integer(500));
        }
        if (this.LOG.isTraceEnabled()) {
            long stopMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("STOP Initializer, using: " + stopMemory + " memory, consumed: " + (stopMemory - this.startMemory));
        }
    }

    void setStartup() {
        this.isStartup = true;
    }

    private void failExpired() {
        this.fail(I18nMarker.marktr("This Alpha version has expired.  Press Ok to exit. "));
    }

    private void failInternetBlocked() {
        this.fail(I18nMarker.marktr("LimeWire was unable to initialize and start. This is usually due to a firewall program blocking LimeWire's access to the internet or loopback connections on the local machine. Please allow LimeWire access to the internet and restart LimeWire."));
    }

    private void failPreferencesPermissions() {
        this.fail(I18nMarker.marktr("LimeWire could not create a temporary preferences folder.\n\nThis is generally caused by a lack of permissions.  Please make sure that LimeWire (and you) have access to create files/folders on your computer.  If the problem persists, please visit www.limewire.com and click the 'Support' link.\n\nLimeWire will now exit.  Thank You."));
    }

    private void fail(final String msgKey) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, new MultiLineLabel(I18n.tr(msgKey), 400), I18n.tr("Error"), 0);
                }
            });
        }
        catch (InterruptedException ignored) {
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        System.exit(1);
    }
}

