/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.SizedTextField;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.limewire.i18n.I18nMarker;

public final class InputFieldDialog {
    public static final int NO_TEXT_ENTERED = 77;
    public static final int CANCELLED = 78;
    public static final int TEXT_ENTERED = 79;
    private JDialog _dialog;
    private final PaddedPanel MAIN_PANEL = new PaddedPanel();
    private final SizedTextField TEXT_FIELD = new SizedTextField();
    private int _returnCode = 77;

    public InputFieldDialog(String LABEL_KEY) {
        this(I18nMarker.marktr("Input"), LABEL_KEY);
    }

    public InputFieldDialog(String CAPTION_KEY, String LABEL_KEY) {
        String caption = I18n.tr(CAPTION_KEY);
        JFrame frame = GUIMediator.getAppFrame();
        this._dialog = new JDialog(frame, caption, true);
        this._dialog.setSize(340, 180);
        LabeledComponent component = new LabeledComponent(LABEL_KEY, this.TEXT_FIELD, 120);
        String[] buttonLabelKeys = new String[]{I18nMarker.marktr("OK"), I18nMarker.marktr("Cancel")};
        String[] buttonLabelTips = new String[]{I18nMarker.marktr("Apply Operation"), I18nMarker.marktr("Cancel Operation")};
        ActionListener[] buttonListeners = new ActionListener[]{new OKListener(), new CancelListener()};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonLabelTips, buttonListeners, 0, 12);
        Container contentPane = this._dialog.getContentPane();
        BoxPanel componentPanel = new BoxPanel(1);
        componentPanel.add(Box.createVerticalGlue());
        componentPanel.add(component.getComponent());
        componentPanel.add(Box.createVerticalGlue());
        this.MAIN_PANEL.add(componentPanel);
        this.MAIN_PANEL.add(Box.createVerticalGlue());
        this.MAIN_PANEL.add(buttons);
        contentPane.add(this.MAIN_PANEL);
    }

    public int showDialog() {
        this.setVisible(true);
        return this._returnCode;
    }

    private void setVisible(boolean visible) {
        if (visible) {
            this._dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        }
        this._dialog.setVisible(visible);
    }

    public String getText() {
        return this.TEXT_FIELD.getText();
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            InputFieldDialog.this._returnCode = 78;
            InputFieldDialog.this.setVisible(false);
        }
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (InputFieldDialog.this.TEXT_FIELD.getText().equals("")) {
                InputFieldDialog.this._returnCode = 77;
            } else {
                InputFieldDialog.this._returnCode = 79;
            }
            InputFieldDialog.this.setVisible(false);
        }
    }
}

