/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

class JavaVersionNotice {
    static final String REQUIRED = "1.5.0";
    static final String JAVA_16_BETA_VERSION = "1.6.0-beta";
    static final String JAVA_16_RC_VERSION = "1.6.0-rc";
    private static final String URL = "http://www.limewire.com/whyupgradejava";

    JavaVersionNotice() {
    }

    public static boolean upgradeRequired(String javaVersion) {
        try {
            Version rq = new Version(REQUIRED);
            Version cr = new Version(javaVersion);
            if (cr.compareTo(rq) < 0) {
                return true;
            }
        }
        catch (VersionFormatException versionFormatException) {
            // empty catch block
        }
        return false;
    }

    public static void showUpgradeRequiredDialog() {
        new UpgradeRequiredDialog().setVisible(true);
    }

    public static JDialog getUpgradeRecommendedDialog(String javaVersion) {
        if (QuestionsHandler.LAST_CHECKED_JAVA_VERSION.getValue().equals(javaVersion)) {
            return null;
        }
        if (javaVersion.startsWith(JAVA_16_BETA_VERSION) || javaVersion.startsWith(JAVA_16_RC_VERSION)) {
            String text = I18n.tr(I18nMarker.marktr("You are currently using a beta or pre-release version of Java 1.6.0. This version is known to have caused problems with LimeWire. Please upgrade to the final 1.6.0 release.\n"));
            return new UpgradeRecommendedDialog(text);
        }
        return null;
    }

    private static class UpgradeRecommendedDialog
    extends JDialog {
        private UpgradeRecommendedDialog(String text) {
            this.setTitle(I18n.tr("Upgrade Java"));
            this.setSize(new Dimension(100, 500));
            this.setModal(true);
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            MultiLineLabel label = new MultiLineLabel(text, 500);
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            labelPanel.add(Box.createHorizontalGlue());
            labelPanel.add(label);
            JPanel buttonPanel = new JPanel();
            JButton nowButton = new JButton(I18n.tr("More Information"));
            nowButton.setToolTipText(I18n.tr(I18nMarker.marktr("Visit {0}"), JavaVersionNotice.URL));
            nowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UpgradeRecommendedDialog.this.dispose();
                    GUIMediator.openURL(JavaVersionNotice.URL);
                }
            });
            JButton laterButton = new JButton(I18n.tr("Remind Me Later"));
            laterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UpgradeRecommendedDialog.this.dispose();
                }
            });
            JButton doNotShowAgainButton = new JButton(I18n.tr("Do not Show Again"));
            doNotShowAgainButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QuestionsHandler.LAST_CHECKED_JAVA_VERSION.setValue(VersionUtils.getJavaVersion());
                    UpgradeRecommendedDialog.this.dispose();
                }
            });
            buttonPanel.add(nowButton);
            buttonPanel.add(laterButton);
            buttonPanel.add(doNotShowAgainButton);
            mainPanel.add(labelPanel);
            mainPanel.add(GUIMediator.getVerticalSeparator());
            mainPanel.add(buttonPanel);
            this.getContentPane().add(mainPanel);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = this.getSize();
            this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }
    }

    private static class UpgradeRequiredDialog
    extends JDialog {
        private UpgradeRequiredDialog() {
            this.setTitle("Upgrade Java");
            this.setSize(new Dimension(100, 300));
            this.setModal(true);
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            String text = "LimeWire requires Java 1.5.0 or higher in order to run. You are currently running an out-of-date version of Java.  Please visit http://www.limewire.com/whyupgradejava in order to upgrade your version of Java.\n\nCurrent Java Version : " + VersionUtils.getJavaVersion() + "\n" + "Required Java Version: " + JavaVersionNotice.REQUIRED + "\n\n";
            MultiLineLabel label = new MultiLineLabel(text, 500);
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            labelPanel.add(Box.createHorizontalGlue());
            labelPanel.add(label);
            JPanel buttonPanel = new JPanel();
            JButton now = new JButton("Upgrade Java");
            now.setToolTipText("Visit http://www.limewire.com/whyupgradejava");
            now.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Launcher.openURL(JavaVersionNotice.URL);
                    }
                    catch (IOException iox) {
                        UpgradeRequiredDialog.this.openURLFailed();
                    }
                    System.exit(1);
                }
            });
            JButton later = new JButton("Upgrade Later");
            later.setToolTipText("Exit LimeWire");
            later.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(1);
                }
            });
            buttonPanel.add(now);
            buttonPanel.add(later);
            mainPanel.add(labelPanel);
            mainPanel.add(buttonPanel);
            this.getContentPane().add(mainPanel);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = this.getSize();
            this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }

        private void openURLFailed() {
            JOptionPane.showMessageDialog(this, "To update, please direct your web-browser to http://www.limewire.com/whyupgradejava.", "Unable to open browser", 0);
        }
    }
}

