/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LanguageWindow
extends JDialog {
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final String TRANSLATE_URL = "http://www.limewire.org/translate.shtml";
    private JCheckBox showLanguageCheckbox;
    private JComboBox localeComboBox;
    private JPanel mainPanel;
    private OkayAction okayAction;
    private CancelAction cancelAction;
    private Locale currentLocale = GUIMediator.getLocale();
    private URLLabel helpTranslateLabel;
    private boolean defaultLocaleSelectable;

    public LanguageWindow() {
        super(GUIMediator.getAppFrame());
        this.initializeWindow();
        Font font = new Font("Dialog", 0, 11);
        Locale[] locales = LanguageUtils.getLocales(font);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.initializeContent(locales);
        this.initializeButtons();
        this.initializeWindow();
        this.updateLabels(this.currentLocale);
        this.pack();
        if (this.getWidth() < 350) {
            this.setSize(350, this.getHeight());
        }
    }

    private void initializeWindow() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction(this);
    }

    private void initializeContent(Locale[] locales) {
        FormLayout layout = new FormLayout("pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        DefaultComboBoxModel<Locale> localeModel = new DefaultComboBoxModel<Locale>();
        int selectedScore = -1;
        int selectedIndex = -1;
        Locale systemLocale = Locale.getDefault();
        for (int i = 0; i < locales.length; ++i) {
            localeModel.addElement(locales[i]);
            int score = LanguageUtils.getMatchScore(this.currentLocale, locales[i]);
            if (score > selectedScore) {
                selectedScore = score;
                selectedIndex = i;
            }
            if (!locales[i].equals(systemLocale)) continue;
            this.defaultLocaleSelectable = true;
        }
        this.localeComboBox = new JComboBox(localeModel);
        this.localeComboBox.setRenderer(LanguageFlagFactory.getListRenderer());
        this.localeComboBox.setMaximumRowCount(15);
        if (selectedIndex != -1) {
            this.localeComboBox.setSelectedIndex(selectedIndex);
        }
        builder.append(this.localeComboBox);
        builder.nextLine();
        this.localeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Locale selected;
                if (e.getStateChange() == 1 && (selected = (Locale)e.getItem()) != null && !LanguageWindow.this.currentLocale.equals(selected)) {
                    LanguageWindow.this.updateLabels(selected);
                    LanguageWindow.this.showLanguageCheckbox.setSelected(!LanguageUtils.isEnglishLocale(selected));
                    LanguageWindow.this.currentLocale = selected;
                }
            }
        });
        this.helpTranslateLabel = new URLLabel(TRANSLATE_URL, "");
        builder.append(this.helpTranslateLabel);
        builder.nextLine();
        builder.append(Box.createVerticalStrut(15));
        builder.nextLine();
        this.showLanguageCheckbox = new JCheckBox();
        this.showLanguageCheckbox.setSelected(StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.getValue());
        builder.append(this.showLanguageCheckbox);
        builder.nextLine();
        builder.append(Box.createVerticalStrut(5));
        builder.nextLine();
        this.mainPanel.add((Component)builder.getPanel(), "Center");
    }

    private void initializeButtons() {
        this.okayAction = new OkayAction();
        this.cancelAction = new CancelAction();
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(new JButton(this.okayAction));
        if (!LanguageUtils.isEnglishLocale(this.currentLocale)) {
            buttonPanel.add(new JButton(new UseEnglishAction()));
        }
        buttonPanel.add(new JButton(this.cancelAction));
        this.mainPanel.add((Component)buttonPanel, "South");
    }

    private void switchLanguage(Locale locale, boolean showLanguageInStatusBar) {
        if (!this.defaultLocaleSelectable && LanguageUtils.matchesDefaultLocale(locale)) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(GUIMediator.getLocale())) {
            LanguageUtils.setLocale(locale);
            GUIMediator.instance().getStatusLine().updateLanguage();
            String message = I18n.trl("LimeWire must be restarted for the new language to take effect.", locale);
            GUIMediator.showMessage(message);
        }
        StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(showLanguageInStatusBar);
        if (LanguageUtils.isEnglishLocale(locale)) {
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(showLanguageInStatusBar);
        }
        GUIMediator.instance().getStatusLine().refresh();
        this.dispose();
    }

    private void updateLabels(Locale locale) {
        this.setTitle(I18n.trl("Change Language", locale));
        this.okayAction.putValue("Name", I18n.trl("OK", locale));
        this.cancelAction.putValue("Name", I18n.trl("Cancel", locale));
        this.helpTranslateLabel.setText(I18n.trl("Help Translate LimeWire", locale));
        this.showLanguageCheckbox.setText(I18n.trl("Show Language in status bar", locale));
    }

    private class UseEnglishAction
    extends AbstractAction {
        public UseEnglishAction() {
            this.putValue("Name", "Use English");
        }

        public void actionPerformed(ActionEvent event) {
            LanguageWindow.this.switchLanguage(Locale.ENGLISH, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            GUIUtils.getDisposeAction().actionPerformed(event);
        }
    }

    private class OkayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            Locale locale = (Locale)LanguageWindow.this.localeComboBox.getSelectedItem();
            LanguageWindow.this.switchLanguage(locale, LanguageWindow.this.showLanguageCheckbox.isSelected());
        }
    }
}

