/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditor
extends JPanel {
    protected Vector<String> model;
    protected DefaultListModel realModel;
    protected Vector<ListDataListener> listeners = new Vector();
    private static final int DEFAULT_COLUMNS = 10;
    protected JTextField editor;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList list;
    private boolean addTail = true;

    public ListEditor() {
        this(new Vector<String>());
    }

    public ListEditor(Vector<String> model) {
        this.setLayout(new GridBagLayout());
        this.editor = new LimeTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.add((Component)this.editor, gbc);
        AddAction addAction = new AddAction();
        this.addButton = new JButton(addAction);
        GUIUtils.bindKeyToAction(this.editor, KeyStroke.getKeyStroke(10, 0), addAction);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.addButton, gbc);
        RemoveAction removeAction = new RemoveAction();
        this.removeButton = new JButton(removeAction);
        this.removeButton.setEnabled(false);
        gbc.gridwidth = 0;
        this.add((Component)this.removeButton, gbc);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        GUIUtils.bindKeyToAction(this.list, KeyStroke.getKeyStroke(127, 0), removeAction);
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(model);
        scrollPane.setPreferredSize(new Dimension(500, 50));
        scrollPane.setMaximumSize(new Dimension(500, 50));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
    }

    public Vector<String> getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector<String> model) {
        this.model = model;
        this.realModel = new DefaultListModel();
        for (int i = 0; i < model.size(); ++i) {
            this.realModel.addElement(model.get(i));
        }
        this.list.setModel(this.realModel);
    }

    public void setAddTail(boolean addTail) {
        this.addTail = addTail;
    }

    public boolean getAddTail() {
        return this.addTail;
    }

    public synchronized void removeItem(int i) {
        this.model.remove(i);
        this.realModel.remove(i);
        this.editor.setText("");
        ListDataEvent event = new ListDataEvent(this.model, 2, i, i);
        for (int j = 0; j < this.listeners.size(); ++j) {
            ListDataListener listener = this.listeners.get(j);
            listener.intervalRemoved(event);
        }
    }

    public synchronized void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Remove"));
        }

        public void actionPerformed(ActionEvent e) {
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.removeItem(i);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
        }

        public void actionPerformed(ActionEvent e) {
            String text = ListEditor.this.editor.getText();
            if (text.trim().equals("")) {
                return;
            }
            int i = ListEditor.this.list.getSelectedIndex();
            if (i != -1) {
                ListEditor.this.model.setElementAt(text, i);
                ListEditor.this.realModel.setElementAt(text, i);
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 0, i, i);
                for (int j = 0; j < ListEditor.this.listeners.size(); ++j) {
                    ListDataListener listener = ListEditor.this.listeners.get(j);
                    listener.contentsChanged(event);
                }
            } else {
                int last;
                if (ListEditor.this.addTail) {
                    ListEditor.this.model.addElement(text);
                    ListEditor.this.realModel.addElement(text);
                    last = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, text);
                    ListEditor.this.realModel.add(0, text);
                    last = 0;
                }
                ListDataEvent event = new ListDataEvent(ListEditor.this.model, 1, last, last);
                for (int j = 0; j < ListEditor.this.listeners.size(); ++j) {
                    ListDataListener listener = ListEditor.this.listeners.get(j);
                    listener.intervalAdded(event);
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (ListEditor.this.list.isSelectionEmpty()) {
                ListEditor.this.removeButton.setEnabled(false);
            } else {
                ListEditor.this.removeButton.setEnabled(true);
            }
            Object val = ListEditor.this.list.getSelectedValue();
            if (val == null) {
                return;
            }
            ListEditor.this.editor.setText((String)val);
        }
    }
}

