/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

final class LogoPanel
extends BoxPanel {
    private ImageIcon _searchingIcon;
    private ImageIcon _notSearchingIcon;
    private final JLabel ICON_LABEL = new JLabel();
    private final JLabel LOGO_LABEL = new JLabel();
    private boolean _searching;

    LogoPanel() {
        super(0);
        this.updateTheme();
        final LogoPanel LOGO_PANEL = this;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                GUIMediator.openURL("http://www.limewire.com");
            }

            public void mouseEntered(MouseEvent me) {
                LOGO_PANEL.setCursor(new Cursor(12));
            }
        });
    }

    public void updateTheme() {
        this._searchingIcon = GUIMediator.getThemeImage("radar_lime");
        this._notSearchingIcon = GUIMediator.getThemeImage("still_lime");
        if (this._searching) {
            this.ICON_LABEL.setIcon(this._searchingIcon);
        } else {
            this.ICON_LABEL.setIcon(this._notSearchingIcon);
        }
        ImageIcon logoIcon = GUIMediator.getThemeImage("lw_logo");
        this.LOGO_LABEL.setIcon(logoIcon);
        this.LOGO_LABEL.setSize(logoIcon.getIconWidth(), logoIcon.getIconHeight());
        this.ICON_LABEL.setSize(this._searchingIcon.getIconWidth(), this._searchingIcon.getIconHeight());
        Dimension dim = new Dimension(this.LOGO_LABEL.getSize().width + this.ICON_LABEL.getSize().width + 12, this.ICON_LABEL.getSize().height);
        this.setPreferredSize(dim);
        this.setSize(dim.width, dim.height);
        this.buildPanel();
        GUIUtils.setOpaque(false, this);
    }

    private void buildPanel() {
        this.removeAll();
        this.add(this.ICON_LABEL);
        this.add(this.LOGO_LABEL);
    }

    void setSearching(boolean searching) {
        this._searching = searching;
        if (searching) {
            this.ICON_LABEL.setIcon(this._searchingIcon);
        } else {
            this.ICON_LABEL.setIcon(this._notSearchingIcon);
        }
    }
}

